/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0003J\u0016\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003J\u0016\u0010'\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0005J\u0018\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0005H\u0002J\u000e\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200R+\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "currentPage", "", "currentPageOffsetFraction", "", "state", "Landroidx/compose/foundation/pager/PagerState;", "(IFLandroidx/compose/foundation/pager/PagerState;)V", "<set-?>", "getCurrentPage", "()I", "setCurrentPage", "(I)V", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "getCurrentPageOffsetFraction", "()F", "setCurrentPageOffsetFraction", "(F)V", "currentPageOffsetFraction$delegate", "Landroidx/compose/runtime/MutableFloatState;", "hadFirstNotEmptyLayout", "", "lastKnownCurrentPageKey", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "applyScrollDelta", "", "delta", "currentScrollOffset", "matchPageWithKey", "itemProvider", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "index", "requestPosition", "scrollOffsetFraction", "update", "page", "pageOffsetFraction", "updateCurrentPageOffsetFraction", "offsetFraction", "updateFromMeasureResult", "measureResult", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPagerScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 4 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPositionKt\n*L\n1#1,151:1\n75#2:152\n108#2,2:153\n76#3:155\n109#3,2:156\n147#4,4:158\n*S KotlinDebug\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n*L\n40#1:152\n40#1:153,2\n43#1:155\n43#1:156,2\n124#1:158,4\n*E\n"})
public final class PagerScrollPosition {
    @NotNull
    private final PagerState state;
    @NotNull
    private final MutableIntState currentPage$delegate;
    @NotNull
    private final MutableFloatState currentPageOffsetFraction$delegate;
    private boolean hadFirstNotEmptyLayout;
    @Nullable
    private Object lastKnownCurrentPageKey;
    @NotNull
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    public PagerScrollPosition(int currentPage, float currentPageOffsetFraction, @NotNull PagerState state) {
        this.state = state;
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)currentPage);
        this.currentPageOffsetFraction$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)currentPageOffsetFraction);
        this.nearestRangeState = new LazyLayoutNearestRangeState(currentPage, 30, 100);
    }

    public /* synthetic */ PagerScrollPosition(int n, float f, PagerState pagerState, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        this(n, f, pagerState);
    }

    @NotNull
    public final PagerState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCurrentPage() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPage(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final float getCurrentPageOffsetFraction() {
        void $this$getValue$iv;
        FloatState floatState = (FloatState)this.currentPageOffsetFraction$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPageOffsetFraction(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.currentPageOffsetFraction$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    @NotNull
    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    public final void updateFromMeasureResult(@NotNull PagerMeasureResult measureResult) {
        MeasuredPage measuredPage = measureResult.getCurrentPage();
        Object object = this.lastKnownCurrentPageKey = measuredPage != null ? measuredPage.getKey() : null;
        if (this.hadFirstNotEmptyLayout || !((Collection)measureResult.getVisiblePagesInfo()).isEmpty()) {
            this.hadFirstNotEmptyLayout = true;
            MeasuredPage measuredPage2 = measureResult.getCurrentPage();
            this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, measureResult.getCurrentPageOffsetFraction());
        }
    }

    public final void requestPosition(int index2, float scrollOffsetFraction) {
        this.update(index2, scrollOffsetFraction);
        this.lastKnownCurrentPageKey = null;
    }

    public final int matchPageWithKey(@NotNull PagerLazyLayoutItemProvider itemProvider, int index2) {
        int newIndex = LazyLayoutItemProviderKt.findIndexByKey(itemProvider, this.lastKnownCurrentPageKey, index2);
        if (index2 != newIndex) {
            this.setCurrentPage(newIndex);
            this.nearestRangeState.update(index2);
        }
        return newIndex;
    }

    private final void update(int page, float pageOffsetFraction) {
        this.setCurrentPage(page);
        this.nearestRangeState.update(page);
        this.setCurrentPageOffsetFraction(Math.abs(pageOffsetFraction) == 0.0f ? 0.0f : pageOffsetFraction);
    }

    public final void updateCurrentPageOffsetFraction(float offsetFraction) {
        this.setCurrentPageOffsetFraction(offsetFraction);
    }

    public final int currentScrollOffset() {
        return MathKt.roundToInt((float)(((float)this.getCurrentPage() + this.getCurrentPageOffsetFraction()) * (float)this.state.getPageSizeWithSpacing$foundation_release()));
    }

    public final void applyScrollDelta(int delta) {
        boolean $i$f$debugLog = false;
        float fractionDelta = this.state.getPageSizeWithSpacing$foundation_release() == 0 ? 0.0f : (float)delta / (float)this.state.getPageSizeWithSpacing$foundation_release();
        this.setCurrentPageOffsetFraction(this.getCurrentPageOffsetFraction() + fractionDelta);
    }
}

