/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import android.os.Trace;
import android.view.Choreographer;
import android.view.Display;
import android.view.View;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.layout.LazyLayoutItemContentFactory;
import androidx.compose.foundation.lazy.layout.LazyLayoutItemProvider;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.layout.SubcomposeLayoutState;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 02\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u000201B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0002J\b\u0010$\u001a\u00020\u001eH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J%\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b.\u0010/R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00062"}, d2={"Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetcher;", "Landroidx/compose/runtime/RememberObserver;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$Prefetcher;", "Ljava/lang/Runnable;", "Landroid/view/Choreographer$FrameCallback;", "prefetchState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "subcomposeLayoutState", "Landroidx/compose/ui/layout/SubcomposeLayoutState;", "itemContentFactory", "Landroidx/compose/foundation/lazy/layout/LazyLayoutItemContentFactory;", "view", "Landroid/view/View;", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;Landroidx/compose/ui/layout/SubcomposeLayoutState;Landroidx/compose/foundation/lazy/layout/LazyLayoutItemContentFactory;Landroid/view/View;)V", "averagePrecomposeTimeNs", "", "averagePremeasureTimeNs", "choreographer", "Landroid/view/Choreographer;", "kotlin.jvm.PlatformType", "isActive", "", "prefetchRequests", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetcher$PrefetchRequest;", "prefetchScheduled", "calculateAverageTime", "new", "current", "doFrame", "", "frameTimeNanos", "enoughTimeLeft", "now", "nextFrame", "average", "onAbandoned", "onForgotten", "onRemembered", "run", "schedulePrefetch", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "index", "", "constraints", "Landroidx/compose/ui/unit/Constraints;", "schedulePrefetch-0kLqBqw", "(IJ)Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "Companion", "PrefetchRequest", "foundation_release"})
@ExperimentalFoundationApi
@SourceDebugExtension(value={"SMAP\nLazyLayoutPrefetcher.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyLayoutPrefetcher.android.kt\nandroidx/compose/foundation/lazy/layout/LazyLayoutPrefetcher\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 AndroidTrace.android.kt\nandroidx/compose/ui/util/AndroidTrace_androidKt\n*L\n1#1,312:1\n1182#2:313\n1161#2,2:314\n523#3:316\n26#4,5:317\n26#4,5:322\n*S KotlinDebug\n*F\n+ 1 LazyLayoutPrefetcher.android.kt\nandroidx/compose/foundation/lazy/layout/LazyLayoutPrefetcher\n*L\n122#1:313\n122#1:314,2\n159#1:316\n164#1:317,5\n183#1:322,5\n*E\n"})
public final class LazyLayoutPrefetcher
implements RememberObserver,
LazyLayoutPrefetchState.Prefetcher,
Runnable,
Choreographer.FrameCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LazyLayoutPrefetchState prefetchState;
    @NotNull
    private final SubcomposeLayoutState subcomposeLayoutState;
    @NotNull
    private final LazyLayoutItemContentFactory itemContentFactory;
    @NotNull
    private final View view;
    @NotNull
    private final MutableVector<PrefetchRequest> prefetchRequests;
    private long averagePrecomposeTimeNs;
    private long averagePremeasureTimeNs;
    private boolean prefetchScheduled;
    private final Choreographer choreographer;
    private boolean isActive;
    private static long frameIntervalNs;

    public LazyLayoutPrefetcher(@NotNull LazyLayoutPrefetchState prefetchState, @NotNull SubcomposeLayoutState subcomposeLayoutState, @NotNull LazyLayoutItemContentFactory itemContentFactory2, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)prefetchState, (String)"prefetchState");
        Intrinsics.checkNotNullParameter((Object)subcomposeLayoutState, (String)"subcomposeLayoutState");
        Intrinsics.checkNotNullParameter((Object)itemContentFactory2, (String)"itemContentFactory");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.prefetchState = prefetchState;
        this.subcomposeLayoutState = subcomposeLayoutState;
        this.itemContentFactory = itemContentFactory2;
        this.view = view;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.prefetchRequests = new MutableVector((Object[])new PrefetchRequest[capacity$iv$iv], 0);
        this.choreographer = Choreographer.getInstance();
        LazyLayoutPrefetcher.Companion.calculateFrameIntervalIfNeeded(this.view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.prefetchRequests.isEmpty() || !this.prefetchScheduled || !this.isActive || this.view.getWindowVisibility() != 0) {
            this.prefetchScheduled = false;
            return;
        }
        long latestFrameVsyncNs = TimeUnit.MILLISECONDS.toNanos(this.view.getDrawingTime());
        long nextFrameNs = latestFrameVsyncNs + frameIntervalNs;
        boolean scheduleForNextFrame = false;
        while (this.prefetchRequests.isNotEmpty() && !scheduleForNextFrame) {
            long beforeTimeNs;
            boolean $i$f$trace2;
            LazyLayoutItemProvider itemProvider;
            PrefetchRequest request;
            block21: {
                block20: {
                    void this_$iv;
                    MutableVector<PrefetchRequest> mutableVector = this.prefetchRequests;
                    int index$iv = 0;
                    int $i$f$get = 0;
                    request = (PrefetchRequest)this_$iv.getContent()[index$iv];
                    itemProvider = (LazyLayoutItemProvider)this.itemContentFactory.getItemProvider().invoke();
                    if (request.getCanceled()) break block20;
                    index$iv = itemProvider.getItemCount();
                    $i$f$get = request.getIndex();
                    if (0 <= $i$f$get ? $i$f$get < index$iv : false) break block21;
                }
                this.prefetchRequests.removeAt(0);
                continue;
            }
            if (request.getPrecomposeHandle() == null) {
                String sectionName$iv = "compose:lazylist:prefetch:compose";
                $i$f$trace2 = false;
                Trace.beginSection((String)sectionName$iv);
                try {
                    boolean bl = false;
                    beforeTimeNs = System.nanoTime();
                    if (this.enoughTimeLeft(beforeTimeNs, nextFrameNs, this.averagePrecomposeTimeNs)) {
                        Object key = itemProvider.getKey(request.getIndex());
                        Object contentType = itemProvider.getContentType(request.getIndex());
                        Function2<Composer, Integer, Unit> content = this.itemContentFactory.getContent(request.getIndex(), key, contentType);
                        request.setPrecomposeHandle(this.subcomposeLayoutState.precompose(key, content));
                        this.averagePrecomposeTimeNs = this.calculateAverageTime(System.nanoTime() - beforeTimeNs, this.averagePrecomposeTimeNs);
                    } else {
                        scheduleForNextFrame = true;
                    }
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                finally {
                    Trace.endSection();
                    continue;
                }
            }
            if (!(!request.getMeasured())) {
                String $i$f$trace2 = "Check failed.";
                throw new IllegalStateException($i$f$trace2.toString());
            }
            String sectionName$iv = "compose:lazylist:prefetch:measure";
            $i$f$trace2 = false;
            Trace.beginSection((String)sectionName$iv);
            try {
                Object object;
                boolean bl = false;
                beforeTimeNs = System.nanoTime();
                if (this.enoughTimeLeft(beforeTimeNs, nextFrameNs, this.averagePremeasureTimeNs)) {
                    SubcomposeLayoutState.PrecomposedSlotHandle handle;
                    Intrinsics.checkNotNull((Object)request.getPrecomposeHandle());
                    int n = handle.getPlaceablesCount();
                    int n2 = 0;
                    while (n2 < n) {
                        int placeableIndex = n2++;
                        boolean bl2 = false;
                        handle.premeasure-0kLqBqw(placeableIndex, request.getConstraints-msEJaDk());
                    }
                    this.averagePremeasureTimeNs = this.calculateAverageTime(System.nanoTime() - beforeTimeNs, this.averagePremeasureTimeNs);
                    object = this.prefetchRequests.removeAt(0);
                } else {
                    scheduleForNextFrame = true;
                    object = Unit.INSTANCE;
                }
                Unit unit = object;
            }
            finally {
                Trace.endSection();
            }
        }
        if (scheduleForNextFrame) {
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        } else {
            this.prefetchScheduled = false;
        }
    }

    private final boolean enoughTimeLeft(long now, long nextFrame, long average) {
        return now > nextFrame || now + average < nextFrame;
    }

    public void doFrame(long frameTimeNanos) {
        if (this.isActive) {
            this.view.post((Runnable)this);
        }
    }

    private final long calculateAverageTime(long l, long current) {
        return current == 0L ? l : current / (long)4 * (long)3 + l / (long)4;
    }

    @Override
    @NotNull
    public LazyLayoutPrefetchState.PrefetchHandle schedulePrefetch-0kLqBqw(int index2, long constraints) {
        PrefetchRequest request = new PrefetchRequest(index2, constraints, null);
        this.prefetchRequests.add((Object)request);
        if (!this.prefetchScheduled) {
            this.prefetchScheduled = true;
            this.view.post((Runnable)this);
        }
        return request;
    }

    public void onRemembered() {
        this.prefetchState.setPrefetcher$foundation_release(this);
        this.isActive = true;
    }

    public void onForgotten() {
        this.isActive = false;
        this.prefetchState.setPrefetcher$foundation_release(null);
        this.view.removeCallbacks((Runnable)this);
        this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
    }

    public void onAbandoned() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetcher$Companion;", "", "()V", "frameIntervalNs", "", "calculateFrameIntervalIfNeeded", "", "view", "Landroid/view/View;", "foundation_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void calculateFrameIntervalIfNeeded(View view) {
            if (frameIntervalNs == 0L) {
                float displayRefreshRate;
                Display display = view.getDisplay();
                float refreshRate = 60.0f;
                if (!view.isInEditMode() && display != null && (displayRefreshRate = display.getRefreshRate()) >= 30.0f) {
                    refreshRate = displayRefreshRate;
                }
                frameIntervalNs = (long)((float)1000000000 / refreshRate);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0018\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\fR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetcher$PrefetchRequest;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "index", "", "constraints", "Landroidx/compose/ui/unit/Constraints;", "(IJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "canceled", "", "getCanceled", "()Z", "setCanceled", "(Z)V", "getConstraints-msEJaDk", "()J", "J", "getIndex", "()I", "measured", "getMeasured", "setMeasured", "precomposeHandle", "Landroidx/compose/ui/layout/SubcomposeLayoutState$PrecomposedSlotHandle;", "getPrecomposeHandle", "()Landroidx/compose/ui/layout/SubcomposeLayoutState$PrecomposedSlotHandle;", "setPrecomposeHandle", "(Landroidx/compose/ui/layout/SubcomposeLayoutState$PrecomposedSlotHandle;)V", "cancel", "", "foundation_release"})
    private static final class PrefetchRequest
    implements LazyLayoutPrefetchState.PrefetchHandle {
        private final int index;
        private final long constraints;
        @Nullable
        private SubcomposeLayoutState.PrecomposedSlotHandle precomposeHandle;
        private boolean canceled;
        private boolean measured;

        private PrefetchRequest(int index2, long constraints) {
            this.index = index2;
            this.constraints = constraints;
        }

        public final int getIndex() {
            return this.index;
        }

        public final long getConstraints-msEJaDk() {
            return this.constraints;
        }

        @Nullable
        public final SubcomposeLayoutState.PrecomposedSlotHandle getPrecomposeHandle() {
            return this.precomposeHandle;
        }

        public final void setPrecomposeHandle(@Nullable SubcomposeLayoutState.PrecomposedSlotHandle precomposedSlotHandle) {
            this.precomposeHandle = precomposedSlotHandle;
        }

        public final boolean getCanceled() {
            return this.canceled;
        }

        public final void setCanceled(boolean bl) {
            this.canceled = bl;
        }

        public final boolean getMeasured() {
            return this.measured;
        }

        public final void setMeasured(boolean bl) {
            this.measured = bl;
        }

        @Override
        public void cancel() {
            if (!this.canceled) {
                this.canceled = true;
                SubcomposeLayoutState.PrecomposedSlotHandle precomposedSlotHandle = this.precomposeHandle;
                if (precomposedSlotHandle != null) {
                    precomposedSlotHandle.dispose();
                }
                this.precomposeHandle = null;
            }
        }

        public /* synthetic */ PrefetchRequest(int index2, long constraints, DefaultConstructorMarker $constructor_marker) {
            this(index2, constraints);
        }
    }
}

