/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.Animations;
import androidx.compose.animation.core.FloatSpringSpec;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a1\u0010\u0002\u001a\u00020\u0003\"\b\b\u0000\u0010\u0004*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0018\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a9\u0010\u000f\u001a\u00020\f\"\b\b\u0000\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u00102\u0006\u0010\u0011\u001a\u0002H\u00042\u0006\u0010\u0012\u001a\u0002H\u00042\u0006\u0010\u0013\u001a\u0002H\u0004H\u0000\u00a2\u0006\u0002\u0010\u0014\u001aA\u0010\u0015\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u00102\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u0002H\u00042\u0006\u0010\u0018\u001a\u0002H\u00042\u0006\u0010\u0019\u001a\u0002H\u0004H\u0000\u00a2\u0006\u0002\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"InfiniteIterations", "", "createSpringAnimations", "Landroidx/compose/animation/core/Animations;", "V", "Landroidx/compose/animation/core/AnimationVector;", "visibilityThreshold", "dampingRatio", "", "stiffness", "(Landroidx/compose/animation/core/AnimationVector;FF)Landroidx/compose/animation/core/Animations;", "clampPlayTime", "", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "playTime", "getDurationMillis", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValueFromMillis", "playTimeMillis", "start", "end", "startVelocity", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "animation-core_release"})
public final class VectorizedAnimationSpecKt {
    private static final int InfiniteIterations = Integer.MAX_VALUE;

    public static final <V extends AnimationVector> long getDurationMillis(@NotNull VectorizedAnimationSpec<V> $this$getDurationMillis, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter($this$getDurationMillis, (String)"<this>");
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return $this$getDurationMillis.getDurationNanos(initialValue, targetValue, initialVelocity) / 1000000L;
    }

    @NotNull
    public static final <V extends AnimationVector> V getValueFromMillis(@NotNull VectorizedAnimationSpec<V> $this$getValueFromMillis, long playTimeMillis, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter($this$getValueFromMillis, (String)"<this>");
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return $this$getValueFromMillis.getValueFromNanos(playTimeMillis * 1000000L, start, end, startVelocity);
    }

    private static final long clampPlayTime(VectorizedDurationBasedAnimationSpec<?> $this$clampPlayTime, long playTime) {
        return RangesKt.coerceIn((long)(playTime - (long)$this$clampPlayTime.getDelayMillis()), (long)0L, (long)$this$clampPlayTime.getDurationMillis());
    }

    private static final <V extends AnimationVector> Animations createSpringAnimations(V visibilityThreshold, float dampingRatio, float stiffness) {
        if (visibilityThreshold != null) {
            return new Animations(visibilityThreshold, dampingRatio, stiffness){
                @NotNull
                private final List<FloatSpringSpec> anims;
                {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = (Iterable)RangesKt.until((int)0, (int)((AnimationVector)$visibilityThreshold).getSize$animation_core_release());
                    createSpringAnimations.1 var13_5 = this;
                    boolean $i$f$map = false;
                    void var6_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void index;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new FloatSpringSpec($dampingRatio, $stiffness, ((AnimationVector)$visibilityThreshold).get$animation_core_release((int)index)));
                    }
                    var13_5.anims = (List)destination$iv$iv;
                }

                @NotNull
                public FloatSpringSpec get(int index) {
                    return this.anims.get(index);
                }
            };
        }
        return new Animations(dampingRatio, stiffness){
            @NotNull
            private final FloatSpringSpec anim;
            {
                this.anim = new FloatSpringSpec($dampingRatio, $stiffness, 0.0f, 4, null);
            }

            @NotNull
            public FloatSpringSpec get(int index) {
                return this.anim;
            }
        };
    }

    public static final /* synthetic */ long access$clampPlayTime(VectorizedDurationBasedAnimationSpec $receiver, long playTime) {
        return VectorizedAnimationSpecKt.clampPlayTime($receiver, playTime);
    }

    public static final /* synthetic */ Animations access$createSpringAnimations(AnimationVector visibilityThreshold, float dampingRatio, float stiffness) {
        return VectorizedAnimationSpecKt.createSpringAnimations(visibilityThreshold, dampingRatio, stiffness);
    }
}

