/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.IntList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0018\u0010\b\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001J\u0018\u0010\r\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0001J\u0018\u0010\r\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0003J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0003H\u0086\nJ\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0003H\u0086\nJ\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00032\b\b\u0001\u0010\f\u001a\u00020\u0003J\u001a\u0010\u0017\u001a\u00020\u000b2\b\b\u0001\u0010\u0018\u001a\u00020\u00032\b\b\u0001\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u001b\u001a\u00020\u00032\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Landroidx/collection/MutableIntList;", "Landroidx/collection/IntList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "add", "", "element", "", "index", "addAll", "elements", "", "clear", "ensureCapacity", "minusAssign", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "set", "sort", "sortDescending", "trim", "minCapacity", "collection"})
@SourceDebugExtension(value={"SMAP\nIntList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntList.kt\nandroidx/collection/MutableIntList\n+ 2 IntList.kt\nandroidx/collection/IntList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,958:1\n546#1:959\n68#2:960\n250#2,6:963\n68#2:969\n68#2:970\n68#2:971\n68#2:978\n68#2:979\n13600#3,2:961\n1663#3,6:972\n*S KotlinDebug\n*F\n+ 1 IntList.kt\nandroidx/collection/MutableIntList\n*L\n683#1:959\n744#1:960\n763#1:963,6\n774#1:969\n778#1:970\n822#1:971\n838#1:978\n854#1:979\n754#1:961,2\n824#1:972,6\n*E\n"})
public final class MutableIntList
extends IntList {
    public MutableIntList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableIntList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    public final boolean add(int element) {
        this.ensureCapacity(this._size + 1);
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void add(@IntRange(from=0L) int index, int element) {
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        this.ensureCapacity(this._size + 1);
        int[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((int[])content, (int[])content, (int)(index + 1), (int)index, (int)this._size);
        }
        content[index] = element;
        int n = this._size;
        this._size = n + 1;
    }

    public final boolean addAll(@IntRange(from=0L) int index, @NotNull int[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements.length);
        int[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((int[])content, (int[])content, (int)(index + elements.length), (int)index, (int)this._size);
        }
        ArraysKt.copyInto$default((int[])elements, (int[])content, (int)index, (int)0, (int)0, (int)12, null);
        this._size += elements.length;
        return true;
    }

    public final boolean addAll(@IntRange(from=0L) int index, @NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!(0 <= index ? index <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
        }
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this._size + elements._size);
        int[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((int[])content, (int[])content, (int)(index + elements._size), (int)index, (int)this._size);
        }
        ArraysKt.copyInto((int[])elements.content, (int[])content, (int)index, (int)0, (int)elements._size);
        this._size += elements._size;
        return true;
    }

    public final boolean addAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return this.addAll(this._size, elements);
    }

    public final boolean addAll(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.addAll(this._size, elements);
    }

    public final void clear() {
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableIntList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            int[] nArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.content = nArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableIntList mutableIntList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableIntList._size;
        }
        mutableIntList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        int[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            int[] nArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.content = nArray;
        }
    }

    public final void plusAssign(int element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(int element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(int element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            this.remove(elements[i]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int initialSize = this._size;
        int i = 0;
        IntList this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv._size - 1;
        if (i <= n) {
            while (true) {
                this.remove(elements.get(i));
                if (i == n) break;
                ++i;
            }
        }
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int element = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final void minusAssign(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        IntList this_$iv = elements;
        boolean $i$f$forEach = false;
        int[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            int element = content$iv[i$iv];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final int removeAt(@IntRange(from=0L) int index) {
        if (!(0 <= index ? index < this._size : false)) {
            IntList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("Index " + index + " must be in 0.." + (this_$iv._size - 1));
        }
        int[] content = this.content;
        int item = content[index];
        IntList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index != this_$iv._size - 1) {
            ArraysKt.copyInto((int[])content, (int[])content, (int)index, (int)(index + 1), (int)this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return item;
    }

    public final void removeRange(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        block7: {
            block6: {
                boolean bl = 0 <= start ? start <= this._size : false;
                if (!bl) break block6;
                if (0 <= end ? end <= this._size : false) break block7;
            }
            throw new IndexOutOfBoundsException("Start (" + start + ") and end (" + end + ") must be in 0.." + this._size);
        }
        if (end < start) {
            throw new IllegalArgumentException("Start (" + start + ") is more than end (" + end + ')');
        }
        if (end != start) {
            if (end < this._size) {
                ArraysKt.copyInto((int[])this.content, (int[])this.content, (int)start, (int)end, (int)this._size);
            }
            this._size -= end - start;
        }
    }

    public final boolean retainAll(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int initialSize = this._size;
        int[] content = this.content;
        IntList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            int n;
            block2: {
                int item = content[i];
                int[] $this$indexOfFirst$iv = elements;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    int it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == item)) continue;
                    n = index$iv;
                    break block2;
                }
                n = -1;
            }
            if (n >= 0) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int initialSize = this._size;
        int[] content = this.content;
        IntList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            int item = content[i];
            if (elements.contains(item)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final int set(@IntRange(from=0L) int index, int element) {
        if (!(0 <= index ? index < this._size : false)) {
            IntList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("set index " + index + " must be between 0 .. " + (this_$iv._size - 1));
        }
        int[] content = this.content;
        int old = content[index];
        content[index] = element;
        return old;
    }

    public final void sort() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sort((int[])this.content, (int)0, (int)this._size);
    }

    public final void sortDescending() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sortDescending((int[])this.content, (int)0, (int)this._size);
    }

    public MutableIntList() {
        this(0, 1, null);
    }
}

