/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.internal.Lock;
import androidx.collection.internal.LruHashMap;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u000f\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0007\u001a\u00020\u0005J/\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\b\u0010\u0019\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u001d\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010\u000f\u001a\u00020\u0005J\u0015\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010!\u001a\u00020\u00152\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\"\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010#J\u0006\u0010\u0010\u001a\u00020\u0005J\u001d\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010#J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/collection/LruCache;", "K", "", "V", "maxSize", "", "(I)V", "createCount", "evictionCount", "hitCount", "lock", "Landroidx/collection/internal/Lock;", "map", "Landroidx/collection/internal/LruHashMap;", "missCount", "putCount", "size", "create", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryRemoved", "", "evicted", "", "oldValue", "newValue", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "evictAll", "get", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "resize", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "snapshot", "", "toString", "", "trimToSize", "collection"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 LockExt.kt\nandroidx/collection/internal/LockExtKt\n+ 4 Lock.jvm.kt\nandroidx/collection/internal/Lock\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n46#2,5:376\n46#2,5:381\n32#2,5:406\n32#2,5:415\n23#3,3:386\n23#3,3:390\n23#3,3:394\n23#3,3:398\n23#3,3:402\n23#3,3:411\n23#3,3:420\n23#3,3:424\n23#3,3:428\n23#3,3:432\n23#3,3:436\n23#3,3:440\n23#3,3:444\n23#3,3:448\n23#3,3:454\n26#4:389\n26#4:393\n26#4:397\n26#4:401\n26#4:405\n26#4:414\n26#4:423\n26#4:427\n26#4:431\n26#4:435\n26#4:439\n26#4:443\n26#4:447\n26#4:451\n26#4:457\n1855#5,2:452\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n*L\n62#1:376,5\n85#1:381,5\n174#1:406,5\n252#1:415,5\n87#1:386,3\n100#1:390,3\n117#1:394,3\n144#1:398,3\n173#1:402,3\n202#1:411,3\n277#1:420,3\n284#1:424,3\n290#1:428,3\n296#1:432,3\n301#1:436,3\n306#1:440,3\n311#1:444,3\n320#1:448,3\n328#1:454,3\n87#1:389\n100#1:393\n117#1:397\n144#1:401\n173#1:405\n202#1:414\n277#1:423\n284#1:427\n290#1:431\n296#1:435\n301#1:439\n306#1:443\n311#1:447\n320#1:451\n328#1:457\n322#1:452,2\n*E\n"})
public class LruCache<K, V> {
    private int maxSize;
    @NotNull
    private final LruHashMap<K, V> map;
    @NotNull
    private final Lock lock;
    private int size;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(@IntRange(from=1L, to=0x7FFFFFFFL) int maxSize) {
        this.maxSize = maxSize;
        boolean value$iv = this.maxSize > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        this.map = new LruHashMap(0, 0.75f);
        this.lock = new Lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(@IntRange(from=1L, to=0x7FFFFFFFL) int maxSize) {
        boolean value$iv = maxSize > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            this.maxSize = maxSize;
            Unit unit = Unit.INSTANCE;
        }
        this.trimToSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V get(@NotNull K key) {
        V v;
        int n;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        V mapValue = null;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            block12: {
                boolean bl = false;
                mapValue = this.map.get(key);
                if (mapValue == null) break block12;
                int n2 = this.hitCount;
                this.hitCount = n2 + 1;
                V v2 = mapValue;
                return v2;
            }
            int n3 = this.missCount;
            this.missCount = n3 + 1;
            n = n3;
        }
        V v3 = this.create(key);
        if (v3 == null) {
            return null;
        }
        V createdValue = v3;
        Lock $this$synchronized$iv2 = this.lock;
        boolean $i$f$synchronized2 = false;
        Lock this_$iv$iv2 = $this$synchronized$iv2;
        boolean $i$f$synchronizedImpl2 = false;
        Lock lock2 = this_$iv$iv2;
        synchronized (lock2) {
            Unit unit;
            boolean bl = false;
            n = this.createCount;
            this.createCount = n + 1;
            mapValue = this.map.put(key, createdValue);
            if (mapValue != null) {
                unit = this.map.put(key, mapValue);
            } else {
                this.size += this.safeSizeOf(key, createdValue);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            v = mapValue;
        } else {
            this.trimToSize(this.maxSize);
            v = createdValue;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V put(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        V previous = null;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            int n = this.putCount;
            this.putCount = n + 1;
            this.size += this.safeSizeOf(key, value);
            previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            K key = null;
            V value = null;
            Lock $this$synchronized$iv = this.lock;
            boolean $i$f$synchronized = false;
            Lock this_$iv$iv = $this$synchronized$iv;
            boolean $i$f$synchronizedImpl = false;
            Lock lock = this_$iv$iv;
            synchronized (lock) {
                Map.Entry toEvict;
                block10: {
                    block9: {
                        boolean bl = false;
                        boolean value$iv = this.size >= 0 && (!this.map.isEmpty() || this.size == 0);
                        boolean $i$f$checkPrecondition = false;
                        if (!value$iv) {
                            boolean bl2 = false;
                            RuntimeHelpersKt.throwIllegalStateException("LruCache.sizeOf() is reporting inconsistent results!");
                        }
                        if (this.size <= maxSize) break block9;
                        if (!this.map.isEmpty()) break block10;
                    }
                    return;
                }
                if ((Map.Entry)CollectionsKt.firstOrNull((Iterable)this.map.getEntries()) == null) {
                    return;
                }
                key = toEvict.getKey();
                value = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.safeSizeOf(key, value);
                int n = this.evictionCount;
                this.evictionCount = n + 1;
                int n2 = n;
            }
            this.entryRemoved(true, key, value, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        V previous = null;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    protected void entryRemoved(boolean evicted, @NotNull K key, @NotNull V oldValue, @Nullable V newValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(oldValue, (String)"oldValue");
    }

    @Nullable
    protected V create(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    private final int safeSizeOf(K key, V value) {
        int result = this.sizeOf(key, value);
        boolean value$iv = result >= 0;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalStateException("Negative size: " + key + '=' + value);
        }
        return result;
    }

    protected int sizeOf(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.size;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int maxSize() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.maxSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hitCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.hitCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int missCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.missCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int createCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.createCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.putCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int evictionCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.evictionCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<K, V> snapshot() {
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            LinkedHashMap copy = new LinkedHashMap(this.map.getEntries().size());
            Iterable $this$forEach$iv = this.map.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                ((Map)copy).put(key, value);
            }
            Map map = copy;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + hitPercent + "%]";
            return string;
        }
    }
}

