/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.view.CameraController;
import androidx.camera.view.internal.ScreenFlashUiInfo;

public final class ScreenFlashView
extends View {
    private static final String TAG = "ScreenFlashView";
    private CameraController mCameraController;
    private Window mScreenFlashWindow;
    private ImageCapture.ScreenFlash mScreenFlash;
    private static final long ANIMATION_DURATION_MILLIS = 1000L;

    @UiThread
    public ScreenFlashView(@NonNull Context context) {
        this(context, null);
    }

    @UiThread
    public ScreenFlashView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @UiThread
    public ScreenFlashView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @UiThread
    public ScreenFlashView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setBackgroundColor(-1);
        this.setAlpha(0.0f);
        this.setElevation(Float.MAX_VALUE);
    }

    @UiThread
    public void setController(@Nullable CameraController cameraController) {
        Threads.checkMainThread();
        if (this.mCameraController != null && this.mCameraController != cameraController) {
            this.setScreenFlashUiInfo(null);
        }
        this.mCameraController = cameraController;
        if (cameraController == null) {
            return;
        }
        if (cameraController.getImageCaptureFlashMode() == 3 && this.mScreenFlashWindow == null) {
            throw new IllegalStateException("No window set despite setting FLASH_MODE_SCREEN in CameraController");
        }
        this.setScreenFlashUiInfo(this.getScreenFlash());
    }

    private void setScreenFlashUiInfo(ImageCapture.ScreenFlash control) {
        if (this.mCameraController == null) {
            Logger.d((String)TAG, (String)"setScreenFlashUiInfo: mCameraController is null!");
            return;
        }
        this.mCameraController.setScreenFlashUiInfo(new ScreenFlashUiInfo(ScreenFlashUiInfo.ProviderType.SCREEN_FLASH_VIEW, control));
    }

    @UiThread
    public void setScreenFlashWindow(@Nullable Window screenFlashWindow) {
        Threads.checkMainThread();
        this.updateScreenFlash(screenFlashWindow);
        this.mScreenFlashWindow = screenFlashWindow;
        this.setScreenFlashUiInfo(this.getScreenFlash());
    }

    private void updateScreenFlash(Window window) {
        if (this.mScreenFlashWindow != window) {
            this.mScreenFlash = window == null ? null : new ImageCapture.ScreenFlash(){
                private float mPreviousBrightness;
                private ValueAnimator mAnimator;

                public void apply(long expirationTimeMillis, @NonNull ImageCapture.ScreenFlashListener screenFlashListener) {
                    Logger.d((String)ScreenFlashView.TAG, (String)"ScreenFlash#apply");
                    this.mPreviousBrightness = ScreenFlashView.this.getBrightness();
                    ScreenFlashView.this.setBrightness(1.0f);
                    if (this.mAnimator != null) {
                        this.mAnimator.cancel();
                    }
                    this.mAnimator = ScreenFlashView.this.animateToFullOpacity(() -> ((ImageCapture.ScreenFlashListener)screenFlashListener).onCompleted());
                }

                public void clear() {
                    Logger.d((String)ScreenFlashView.TAG, (String)"ScreenFlash#clearScreenFlashUi");
                    if (this.mAnimator != null) {
                        this.mAnimator.cancel();
                        this.mAnimator = null;
                    }
                    ScreenFlashView.this.setAlpha(0.0f);
                    ScreenFlashView.this.setBrightness(this.mPreviousBrightness);
                }
            };
        }
    }

    private ValueAnimator animateToFullOpacity(final @Nullable Runnable onAnimationEnd) {
        Logger.d((String)TAG, (String)"animateToFullOpacity");
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(this.getVisibilityRampUpAnimationDurationMillis());
        animator.addUpdateListener(animation -> {
            Logger.d((String)TAG, (String)("animateToFullOpacity: value = " + ((Float)animation.getAnimatedValue()).floatValue()));
            this.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(@NonNull Animator animation) {
            }

            public void onAnimationEnd(@NonNull Animator animation) {
                Logger.d((String)ScreenFlashView.TAG, (String)"ScreenFlash#apply: onAnimationEnd");
                if (onAnimationEnd != null) {
                    onAnimationEnd.run();
                }
            }

            public void onAnimationCancel(@NonNull Animator animation) {
            }

            public void onAnimationRepeat(@NonNull Animator animation) {
            }
        });
        animator.start();
        return animator;
    }

    private float getBrightness() {
        if (this.mScreenFlashWindow == null) {
            Logger.e((String)TAG, (String)"setBrightness: mScreenFlashWindow is null!");
            return Float.NaN;
        }
        WindowManager.LayoutParams layoutParam = this.mScreenFlashWindow.getAttributes();
        return layoutParam.screenBrightness;
    }

    private void setBrightness(float value) {
        if (this.mScreenFlashWindow == null) {
            Logger.e((String)TAG, (String)"setBrightness: mScreenFlashWindow is null!");
            return;
        }
        if (Float.isNaN(value)) {
            Logger.e((String)TAG, (String)"setBrightness: value is NaN!");
            return;
        }
        WindowManager.LayoutParams layoutParam = this.mScreenFlashWindow.getAttributes();
        layoutParam.screenBrightness = value;
        this.mScreenFlashWindow.setAttributes(layoutParam);
        Logger.d((String)TAG, (String)("Brightness set to " + layoutParam.screenBrightness));
    }

    @UiThread
    @Nullable
    public ImageCapture.ScreenFlash getScreenFlash() {
        return this.mScreenFlash;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getVisibilityRampUpAnimationDurationMillis() {
        return 1000L;
    }
}

