/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.PreviewView;
import androidx.camera.view.PreviewViewImplementation;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

final class PreviewStreamStateObserver
implements Observable.Observer<CameraInternal.State> {
    private static final String TAG = "StreamStateObserver";
    private final CameraInfoInternal mCameraInfoInternal;
    private final MutableLiveData<PreviewView.StreamState> mPreviewStreamStateLiveData;
    @GuardedBy(value="this")
    private PreviewView.StreamState mPreviewStreamState;
    private final PreviewViewImplementation mPreviewViewImplementation;
    ListenableFuture<Void> mFlowFuture;
    private boolean mHasStartedPreviewStreamFlow = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreviewStreamStateObserver(CameraInfoInternal cameraInfoInternal, MutableLiveData<PreviewView.StreamState> previewStreamLiveData, PreviewViewImplementation implementation) {
        this.mCameraInfoInternal = cameraInfoInternal;
        this.mPreviewStreamStateLiveData = previewStreamLiveData;
        this.mPreviewViewImplementation = implementation;
        PreviewStreamStateObserver previewStreamStateObserver = this;
        synchronized (previewStreamStateObserver) {
            this.mPreviewStreamState = (PreviewView.StreamState)((Object)previewStreamLiveData.getValue());
        }
    }

    @MainThread
    public void onNewData(@Nullable CameraInternal.State value) {
        if (value == CameraInternal.State.CLOSING || value == CameraInternal.State.CLOSED || value == CameraInternal.State.RELEASING || value == CameraInternal.State.RELEASED) {
            this.updatePreviewStreamState(PreviewView.StreamState.IDLE);
            if (this.mHasStartedPreviewStreamFlow) {
                this.mHasStartedPreviewStreamFlow = false;
                this.cancelFlow();
            }
        } else if (!(value != CameraInternal.State.OPENING && value != CameraInternal.State.OPEN && value != CameraInternal.State.PENDING_OPEN || this.mHasStartedPreviewStreamFlow)) {
            this.startPreviewStreamStateFlow((CameraInfo)this.mCameraInfoInternal);
            this.mHasStartedPreviewStreamFlow = true;
        }
    }

    @MainThread
    public void onError(@NonNull Throwable t) {
        this.clear();
        this.updatePreviewStreamState(PreviewView.StreamState.IDLE);
    }

    void clear() {
        this.cancelFlow();
    }

    private void cancelFlow() {
        if (this.mFlowFuture != null) {
            this.mFlowFuture.cancel(false);
            this.mFlowFuture = null;
        }
    }

    @MainThread
    private void startPreviewStreamStateFlow(final CameraInfo cameraInfo) {
        this.updatePreviewStreamState(PreviewView.StreamState.IDLE);
        final ArrayList<CameraCaptureCallback> callbacksToClear = new ArrayList<CameraCaptureCallback>();
        this.mFlowFuture = FutureChain.from(this.waitForCaptureResult(cameraInfo, callbacksToClear)).transformAsync(v -> this.mPreviewViewImplementation.waitForNextFrame(), CameraXExecutors.directExecutor()).transform(v -> {
            this.updatePreviewStreamState(PreviewView.StreamState.STREAMING);
            return null;
        }, CameraXExecutors.directExecutor());
        Futures.addCallback(this.mFlowFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                PreviewStreamStateObserver.this.mFlowFuture = null;
            }

            public void onFailure(@NonNull Throwable t) {
                PreviewStreamStateObserver.this.mFlowFuture = null;
                if (!callbacksToClear.isEmpty()) {
                    for (CameraCaptureCallback callback : callbacksToClear) {
                        ((CameraInfoInternal)cameraInfo).removeSessionCaptureCallback(callback);
                    }
                    callbacksToClear.clear();
                }
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePreviewStreamState(PreviewView.StreamState streamState) {
        PreviewStreamStateObserver previewStreamStateObserver = this;
        synchronized (previewStreamStateObserver) {
            if (this.mPreviewStreamState.equals((Object)streamState)) {
                return;
            }
            this.mPreviewStreamState = streamState;
        }
        Logger.d((String)TAG, (String)("Update Preview stream state to " + (Object)((Object)streamState)));
        this.mPreviewStreamStateLiveData.postValue((Object)streamState);
    }

    private ListenableFuture<Void> waitForCaptureResult(final CameraInfo cameraInfo, List<CameraCaptureCallback> callbacksToClear) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            CameraCaptureCallback callback = new CameraCaptureCallback(){

                public void onCaptureCompleted(int captureConfigId, @NonNull CameraCaptureResult result) {
                    completer.set(null);
                    ((CameraInfoInternal)cameraInfo).removeSessionCaptureCallback((CameraCaptureCallback)this);
                }
            };
            callbacksToClear.add(callback);
            ((CameraInfoInternal)cameraInfo).addSessionCaptureCallback(CameraXExecutors.directExecutor(), callback);
            return "waitForCaptureResult";
        });
    }
}

