/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.PreviewTransformation;
import androidx.camera.view.PreviewViewImplementation;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
final class TextureViewImplementation
extends PreviewViewImplementation {
    private static final String TAG = "TextureViewImpl";
    TextureView mTextureView;
    SurfaceTexture mSurfaceTexture;
    ListenableFuture<SurfaceRequest.Result> mSurfaceReleaseFuture;
    SurfaceRequest mSurfaceRequest;
    boolean mIsSurfaceTextureDetachedFromView = false;
    SurfaceTexture mDetachedSurfaceTexture;
    AtomicReference<CallbackToFutureAdapter.Completer<Void>> mNextFrameCompleter = new AtomicReference();
    @Nullable
    PreviewViewImplementation.OnSurfaceNotInUseListener mOnSurfaceNotInUseListener;

    TextureViewImplementation(@NonNull FrameLayout parent, @NonNull PreviewTransformation previewTransform) {
        super(parent, previewTransform);
    }

    @Override
    @Nullable
    View getPreview() {
        return this.mTextureView;
    }

    @Override
    void onAttachedToWindow() {
        this.reattachSurfaceTexture();
    }

    @Override
    void onDetachedFromWindow() {
        this.mIsSurfaceTextureDetachedFromView = true;
    }

    @Override
    void onSurfaceRequested(@NonNull SurfaceRequest surfaceRequest, @Nullable PreviewViewImplementation.OnSurfaceNotInUseListener onSurfaceNotInUseListener) {
        this.mResolution = surfaceRequest.getResolution();
        this.mOnSurfaceNotInUseListener = onSurfaceNotInUseListener;
        this.initializePreview();
        if (this.mSurfaceRequest != null) {
            this.mSurfaceRequest.willNotProvideSurface();
        }
        this.mSurfaceRequest = surfaceRequest;
        surfaceRequest.addRequestCancellationListener(ContextCompat.getMainExecutor((Context)this.mTextureView.getContext()), () -> {
            if (this.mSurfaceRequest != null && this.mSurfaceRequest == surfaceRequest) {
                this.mSurfaceRequest = null;
                this.mSurfaceReleaseFuture = null;
            }
            this.notifySurfaceNotInUse();
        });
        this.tryToProvidePreviewSurface();
    }

    private void notifySurfaceNotInUse() {
        if (this.mOnSurfaceNotInUseListener != null) {
            this.mOnSurfaceNotInUseListener.onSurfaceNotInUse();
            this.mOnSurfaceNotInUseListener = null;
        }
    }

    @Override
    public void initializePreview() {
        Preconditions.checkNotNull((Object)this.mParent);
        Preconditions.checkNotNull((Object)this.mResolution);
        this.mTextureView = new TextureView(this.mParent.getContext());
        this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mResolution.getWidth(), this.mResolution.getHeight()));
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surfaceTexture, int width, int height) {
                Logger.d((String)TextureViewImplementation.TAG, (String)("SurfaceTexture available. Size: " + width + "x" + height));
                TextureViewImplementation.this.mSurfaceTexture = surfaceTexture;
                if (TextureViewImplementation.this.mSurfaceReleaseFuture != null) {
                    Preconditions.checkNotNull((Object)TextureViewImplementation.this.mSurfaceRequest);
                    Logger.d((String)TextureViewImplementation.TAG, (String)("Surface invalidated " + TextureViewImplementation.this.mSurfaceRequest));
                    TextureViewImplementation.this.mSurfaceRequest.getDeferrableSurface().close();
                } else {
                    TextureViewImplementation.this.tryToProvidePreviewSurface();
                }
            }

            public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surfaceTexture, int width, int height) {
                Logger.d((String)TextureViewImplementation.TAG, (String)("SurfaceTexture size changed: " + width + "x" + height));
            }

            public boolean onSurfaceTextureDestroyed(final @NonNull SurfaceTexture surfaceTexture) {
                TextureViewImplementation.this.mSurfaceTexture = null;
                if (TextureViewImplementation.this.mSurfaceReleaseFuture != null) {
                    Futures.addCallback(TextureViewImplementation.this.mSurfaceReleaseFuture, (FutureCallback)new FutureCallback<SurfaceRequest.Result>(){

                        public void onSuccess(SurfaceRequest.Result result) {
                            Preconditions.checkState((result.getResultCode() != 3 ? 1 : 0) != 0, (String)"Unexpected result from SurfaceRequest. Surface was provided twice.");
                            Logger.d((String)TextureViewImplementation.TAG, (String)"SurfaceTexture about to manually be destroyed");
                            surfaceTexture.release();
                            if (TextureViewImplementation.this.mDetachedSurfaceTexture != null) {
                                TextureViewImplementation.this.mDetachedSurfaceTexture = null;
                            }
                        }

                        public void onFailure(Throwable t) {
                            throw new IllegalStateException("SurfaceReleaseFuture did not complete nicely.", t);
                        }
                    }, (Executor)ContextCompat.getMainExecutor((Context)TextureViewImplementation.this.mTextureView.getContext()));
                    TextureViewImplementation.this.mDetachedSurfaceTexture = surfaceTexture;
                    return false;
                }
                Logger.d((String)TextureViewImplementation.TAG, (String)"SurfaceTexture about to be destroyed");
                return true;
            }

            public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surfaceTexture) {
                CallbackToFutureAdapter.Completer completer = TextureViewImplementation.this.mNextFrameCompleter.getAndSet(null);
                if (completer != null) {
                    completer.set(null);
                }
            }
        });
        this.mParent.removeAllViews();
        this.mParent.addView((View)this.mTextureView);
    }

    void tryToProvidePreviewSurface() {
        ListenableFuture surfaceReleaseFuture;
        if (this.mResolution == null || this.mSurfaceTexture == null || this.mSurfaceRequest == null) {
            return;
        }
        this.mSurfaceTexture.setDefaultBufferSize(this.mResolution.getWidth(), this.mResolution.getHeight());
        Surface surface = new Surface(this.mSurfaceTexture);
        SurfaceRequest surfaceRequest = this.mSurfaceRequest;
        this.mSurfaceReleaseFuture = surfaceReleaseFuture = CallbackToFutureAdapter.getFuture(completer -> {
            Logger.d((String)TAG, (String)"Surface set on Preview.");
            this.mSurfaceRequest.provideSurface(surface, CameraXExecutors.directExecutor(), arg_0 -> ((CallbackToFutureAdapter.Completer)completer).set(arg_0));
            return "provideSurface[request=" + this.mSurfaceRequest + " surface=" + surface + "]";
        });
        this.mSurfaceReleaseFuture.addListener(() -> {
            Logger.d((String)TAG, (String)"Safe to release surface.");
            this.notifySurfaceNotInUse();
            surface.release();
            if (this.mSurfaceReleaseFuture == surfaceReleaseFuture) {
                this.mSurfaceReleaseFuture = null;
            }
            if (this.mSurfaceRequest == surfaceRequest) {
                this.mSurfaceRequest = null;
            }
        }, ContextCompat.getMainExecutor((Context)this.mTextureView.getContext()));
        this.onSurfaceProvided();
    }

    private void reattachSurfaceTexture() {
        if (this.mIsSurfaceTextureDetachedFromView && this.mDetachedSurfaceTexture != null && this.mTextureView.getSurfaceTexture() != this.mDetachedSurfaceTexture) {
            this.mTextureView.setSurfaceTexture(this.mDetachedSurfaceTexture);
            this.mDetachedSurfaceTexture = null;
            this.mIsSurfaceTextureDetachedFromView = false;
        }
    }

    @Override
    @NonNull
    ListenableFuture<Void> waitForNextFrame() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mNextFrameCompleter.set((CallbackToFutureAdapter.Completer<Void>)completer);
            return "textureViewImpl_waitForNextFrame";
        });
    }

    @Override
    @Nullable
    Bitmap getPreviewBitmap() {
        if (this.mTextureView == null || !this.mTextureView.isAvailable()) {
            return null;
        }
        return this.mTextureView.getBitmap();
    }
}

