/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Size;
import android.view.Display;
import androidx.annotation.DoNotInline;
import androidx.annotation.FloatRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalAnalyzer;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.ViewPort;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.ForwardingLiveData;
import androidx.camera.view.RotationProvider;
import androidx.camera.view.TransformExperimental;
import androidx.camera.view.transform.OutputTransform;
import androidx.camera.view.video.ExperimentalVideo;
import androidx.camera.view.video.OnVideoSavedCallback;
import androidx.camera.view.video.OutputFileOptions;
import androidx.camera.view.video.OutputFileResults;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public abstract class CameraController {
    private static final String TAG = "CameraController";
    private static final String CAMERA_NOT_INITIALIZED = "Camera not initialized.";
    private static final String PREVIEW_VIEW_NOT_ATTACHED = "PreviewView not attached to CameraController.";
    private static final String CAMERA_NOT_ATTACHED = "Use cases not attached to camera.";
    private static final String IMAGE_CAPTURE_DISABLED = "ImageCapture disabled.";
    private static final String VIDEO_CAPTURE_DISABLED = "VideoCapture disabled.";
    private static final float AF_SIZE = 0.16666667f;
    private static final float AE_SIZE = 0.25f;
    @ExperimentalAnalyzer
    public static final int COORDINATE_SYSTEM_VIEW_REFERENCED = 1;
    public static final int TAP_TO_FOCUS_NOT_STARTED = 0;
    public static final int TAP_TO_FOCUS_STARTED = 1;
    public static final int TAP_TO_FOCUS_FOCUSED = 2;
    public static final int TAP_TO_FOCUS_NOT_FOCUSED = 3;
    public static final int TAP_TO_FOCUS_FAILED = 4;
    public static final int IMAGE_CAPTURE = 1;
    public static final int IMAGE_ANALYSIS = 2;
    @ExperimentalVideo
    public static final int VIDEO_CAPTURE = 4;
    CameraSelector mCameraSelector = CameraSelector.DEFAULT_BACK_CAMERA;
    private int mEnabledUseCases = 3;
    @NonNull
    Preview mPreview;
    @Nullable
    OutputSize mPreviewTargetSize;
    @NonNull
    ImageCapture mImageCapture;
    @Nullable
    OutputSize mImageCaptureTargetSize;
    @Nullable
    Executor mImageCaptureIoExecutor;
    @Nullable
    private Executor mAnalysisExecutor;
    @Nullable
    private Executor mAnalysisBackgroundExecutor;
    @Nullable
    private ImageAnalysis.Analyzer mAnalysisAnalyzer;
    @NonNull
    ImageAnalysis mImageAnalysis;
    @Nullable
    OutputSize mImageAnalysisTargetSize;
    @NonNull
    VideoCapture mVideoCapture;
    @NonNull
    final AtomicBoolean mVideoIsRecording = new AtomicBoolean(false);
    @Nullable
    OutputSize mVideoCaptureOutputSize;
    @Nullable
    Camera mCamera;
    @Nullable
    ProcessCameraProvider mCameraProvider;
    @Nullable
    ViewPort mViewPort;
    @Nullable
    Preview.SurfaceProvider mSurfaceProvider;
    @Nullable
    Display mPreviewDisplay;
    private final RotationProvider mRotationProvider;
    @VisibleForTesting
    @NonNull
    final RotationProvider.Listener mDeviceRotationListener;
    private boolean mPinchToZoomEnabled = true;
    private boolean mTapToFocusEnabled = true;
    private final ForwardingLiveData<ZoomState> mZoomState = new ForwardingLiveData();
    private final ForwardingLiveData<Integer> mTorchState = new ForwardingLiveData();
    final MutableLiveData<Integer> mTapToFocusState = new MutableLiveData((Object)0);
    private final Context mAppContext;
    @NonNull
    private final ListenableFuture<Void> mInitializationFuture;

    CameraController(@NonNull Context context) {
        this.mAppContext = CameraController.getApplicationContext(context);
        this.mPreview = new Preview.Builder().build();
        this.mImageCapture = new ImageCapture.Builder().build();
        this.mImageAnalysis = new ImageAnalysis.Builder().build();
        this.mVideoCapture = new VideoCapture.Builder().build();
        this.mInitializationFuture = Futures.transform((ListenableFuture)ProcessCameraProvider.getInstance((Context)this.mAppContext), provider -> {
            this.mCameraProvider = provider;
            this.startCameraAndTrackStates();
            return null;
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        this.mRotationProvider = new RotationProvider(this.mAppContext);
        this.mDeviceRotationListener = rotation -> {
            this.mImageAnalysis.setTargetRotation(rotation);
            this.mImageCapture.setTargetRotation(rotation);
            this.mVideoCapture.setTargetRotation(rotation);
        };
    }

    private static Context getApplicationContext(@NonNull Context context) {
        String attributeTag;
        Context applicationContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 30 && (attributeTag = Api30Impl.getAttributionTag(context)) != null) {
            return Api30Impl.createAttributionContext(applicationContext, attributeTag);
        }
        return applicationContext;
    }

    @NonNull
    public ListenableFuture<Void> getInitializationFuture() {
        return this.mInitializationFuture;
    }

    @Nullable
    abstract Camera startCamera();

    private boolean isCameraInitialized() {
        return this.mCameraProvider != null;
    }

    private boolean isPreviewViewAttached() {
        return this.mSurfaceProvider != null && this.mViewPort != null && this.mPreviewDisplay != null;
    }

    private boolean isCameraAttached() {
        return this.mCamera != null;
    }

    @MainThread
    @OptIn(markerClass={ExperimentalVideo.class})
    public void setEnabledUseCases(int enabledUseCases) {
        Threads.checkMainThread();
        if (enabledUseCases == this.mEnabledUseCases) {
            return;
        }
        int oldEnabledUseCases = this.mEnabledUseCases;
        this.mEnabledUseCases = enabledUseCases;
        if (!this.isVideoCaptureEnabled()) {
            this.stopRecording();
        }
        this.startCameraAndTrackStates(() -> {
            this.mEnabledUseCases = oldEnabledUseCases;
        });
    }

    private boolean isUseCaseEnabled(int useCaseMask) {
        return (this.mEnabledUseCases & useCaseMask) != 0;
    }

    private void setTargetOutputSize(@NonNull ImageOutputConfig.Builder<?> builder, @Nullable OutputSize outputSize) {
        if (outputSize == null) {
            return;
        }
        if (outputSize.getResolution() != null) {
            builder.setTargetResolution(outputSize.getResolution());
        } else if (outputSize.getAspectRatio() != -1) {
            builder.setTargetAspectRatio(outputSize.getAspectRatio());
        } else {
            Logger.e((String)TAG, (String)("Invalid target surface size. " + outputSize));
        }
    }

    private boolean isOutputSizeEqual(@Nullable OutputSize currentSize, @Nullable OutputSize newSize) {
        if (currentSize == newSize) {
            return true;
        }
        return currentSize != null && currentSize.equals(newSize);
    }

    @SuppressLint(value={"MissingPermission", "WrongConstant"})
    @MainThread
    void attachPreviewSurface(@NonNull Preview.SurfaceProvider surfaceProvider, @NonNull ViewPort viewPort, @NonNull Display display) {
        Threads.checkMainThread();
        if (this.mSurfaceProvider != surfaceProvider) {
            this.mSurfaceProvider = surfaceProvider;
            this.mPreview.setSurfaceProvider(surfaceProvider);
        }
        this.mViewPort = viewPort;
        this.mPreviewDisplay = display;
        this.startListeningToRotationEvents();
        this.startCameraAndTrackStates();
    }

    @MainThread
    void clearPreviewSurface() {
        Threads.checkMainThread();
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbind(new UseCase[]{this.mPreview, this.mImageCapture, this.mImageAnalysis, this.mVideoCapture});
        }
        this.mPreview.setSurfaceProvider(null);
        this.mCamera = null;
        this.mSurfaceProvider = null;
        this.mViewPort = null;
        this.mPreviewDisplay = null;
        this.stopListeningToRotationEvents();
    }

    private void startListeningToRotationEvents() {
        this.mRotationProvider.addListener(CameraXExecutors.mainThreadExecutor(), this.mDeviceRotationListener);
    }

    private void stopListeningToRotationEvents() {
        this.mRotationProvider.removeListener(this.mDeviceRotationListener);
    }

    @MainThread
    public void setPreviewTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mPreviewTargetSize, targetSize)) {
            return;
        }
        this.mPreviewTargetSize = targetSize;
        this.unbindPreviewAndRecreate();
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public OutputSize getPreviewTargetSize() {
        Threads.checkMainThread();
        return this.mPreviewTargetSize;
    }

    private void unbindPreviewAndRecreate() {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mPreview});
        }
        Preview.Builder builder = new Preview.Builder();
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mPreviewTargetSize);
        this.mPreview = builder.build();
    }

    @MainThread
    public boolean isImageCaptureEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(1);
    }

    @MainThread
    public int getImageCaptureFlashMode() {
        Threads.checkMainThread();
        return this.mImageCapture.getFlashMode();
    }

    @MainThread
    public void setImageCaptureFlashMode(int flashMode) {
        Threads.checkMainThread();
        this.mImageCapture.setFlashMode(flashMode);
    }

    @MainThread
    public void takePicture(@NonNull ImageCapture.OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull ImageCapture.OnImageSavedCallback imageSavedCallback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isImageCaptureEnabled(), (String)IMAGE_CAPTURE_DISABLED);
        this.updateMirroringFlagInOutputFileOptions(outputFileOptions);
        this.mImageCapture.takePicture(outputFileOptions, executor, imageSavedCallback);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void updateMirroringFlagInOutputFileOptions(@NonNull ImageCapture.OutputFileOptions outputFileOptions) {
        if (this.mCameraSelector.getLensFacing() != null && !outputFileOptions.getMetadata().isReversedHorizontalSet()) {
            outputFileOptions.getMetadata().setReversedHorizontal(this.mCameraSelector.getLensFacing() == 0);
        }
    }

    @MainThread
    public void takePicture(@NonNull Executor executor, @NonNull ImageCapture.OnImageCapturedCallback callback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isImageCaptureEnabled(), (String)IMAGE_CAPTURE_DISABLED);
        this.mImageCapture.takePicture(executor, callback);
    }

    @MainThread
    public void setImageCaptureMode(int captureMode) {
        Threads.checkMainThread();
        if (this.mImageCapture.getCaptureMode() == captureMode) {
            return;
        }
        this.unbindImageCaptureAndRecreate(captureMode);
        this.startCameraAndTrackStates();
    }

    @MainThread
    public int getImageCaptureMode() {
        Threads.checkMainThread();
        return this.mImageCapture.getCaptureMode();
    }

    @MainThread
    public void setImageCaptureTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mImageCaptureTargetSize, targetSize)) {
            return;
        }
        this.mImageCaptureTargetSize = targetSize;
        this.unbindImageCaptureAndRecreate(this.getImageCaptureMode());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public OutputSize getImageCaptureTargetSize() {
        Threads.checkMainThread();
        return this.mImageCaptureTargetSize;
    }

    @MainThread
    public void setImageCaptureIoExecutor(@Nullable Executor executor) {
        Threads.checkMainThread();
        if (this.mImageCaptureIoExecutor == executor) {
            return;
        }
        this.mImageCaptureIoExecutor = executor;
        this.unbindImageCaptureAndRecreate(this.mImageCapture.getCaptureMode());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public Executor getImageCaptureIoExecutor() {
        Threads.checkMainThread();
        return this.mImageCaptureIoExecutor;
    }

    private void unbindImageCaptureAndRecreate(int imageCaptureMode) {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageCapture});
        }
        ImageCapture.Builder builder = new ImageCapture.Builder().setCaptureMode(imageCaptureMode);
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mImageCaptureTargetSize);
        if (this.mImageCaptureIoExecutor != null) {
            builder.setIoExecutor(this.mImageCaptureIoExecutor);
        }
        this.mImageCapture = builder.build();
    }

    @MainThread
    public boolean isImageAnalysisEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(2);
    }

    @MainThread
    public void setImageAnalysisAnalyzer(@NonNull Executor executor, @NonNull ImageAnalysis.Analyzer analyzer) {
        Threads.checkMainThread();
        if (this.mAnalysisAnalyzer == analyzer && this.mAnalysisExecutor == executor) {
            return;
        }
        ImageAnalysis.Analyzer oldAnalyzer = this.mAnalysisAnalyzer;
        this.mAnalysisExecutor = executor;
        this.mAnalysisAnalyzer = analyzer;
        this.mImageAnalysis.setAnalyzer(executor, analyzer);
        this.restartCameraIfAnalyzerResolutionChanged(oldAnalyzer, analyzer);
    }

    @MainThread
    public void clearImageAnalysisAnalyzer() {
        Threads.checkMainThread();
        ImageAnalysis.Analyzer oldAnalyzer = this.mAnalysisAnalyzer;
        this.mAnalysisExecutor = null;
        this.mAnalysisAnalyzer = null;
        this.mImageAnalysis.clearAnalyzer();
        this.restartCameraIfAnalyzerResolutionChanged(oldAnalyzer, null);
    }

    @OptIn(markerClass={ExperimentalAnalyzer.class})
    private void restartCameraIfAnalyzerResolutionChanged(@Nullable ImageAnalysis.Analyzer oldAnalyzer, @Nullable ImageAnalysis.Analyzer newAnalyzer) {
        Size newResolution;
        Size oldResolution = oldAnalyzer == null ? null : oldAnalyzer.getTargetResolutionOverride();
        Size size = newResolution = newAnalyzer == null ? null : newAnalyzer.getTargetResolutionOverride();
        if (!Objects.equals(oldResolution, newResolution)) {
            this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), this.mImageAnalysis.getImageQueueDepth());
            this.startCameraAndTrackStates();
        }
    }

    @MainThread
    public int getImageAnalysisBackpressureStrategy() {
        Threads.checkMainThread();
        return this.mImageAnalysis.getBackpressureStrategy();
    }

    @MainThread
    public void setImageAnalysisBackpressureStrategy(int strategy) {
        Threads.checkMainThread();
        if (this.mImageAnalysis.getBackpressureStrategy() == strategy) {
            return;
        }
        this.unbindImageAnalysisAndRecreate(strategy, this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    public void setImageAnalysisImageQueueDepth(int depth) {
        Threads.checkMainThread();
        if (this.mImageAnalysis.getImageQueueDepth() == depth) {
            return;
        }
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), depth);
        this.startCameraAndTrackStates();
    }

    @MainThread
    public int getImageAnalysisImageQueueDepth() {
        Threads.checkMainThread();
        return this.mImageAnalysis.getImageQueueDepth();
    }

    @MainThread
    public void setImageAnalysisTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mImageAnalysisTargetSize, targetSize)) {
            return;
        }
        this.mImageAnalysisTargetSize = targetSize;
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public OutputSize getImageAnalysisTargetSize() {
        Threads.checkMainThread();
        return this.mImageAnalysisTargetSize;
    }

    @MainThread
    public void setImageAnalysisBackgroundExecutor(@Nullable Executor executor) {
        Threads.checkMainThread();
        if (this.mAnalysisBackgroundExecutor == executor) {
            return;
        }
        this.mAnalysisBackgroundExecutor = executor;
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public Executor getImageAnalysisBackgroundExecutor() {
        Threads.checkMainThread();
        return this.mAnalysisBackgroundExecutor;
    }

    @MainThread
    private void unbindImageAnalysisAndRecreate(int strategy, int imageQueueDepth) {
        Threads.checkMainThread();
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalysis});
        }
        ImageAnalysis.Builder builder = new ImageAnalysis.Builder().setBackpressureStrategy(strategy).setImageQueueDepth(imageQueueDepth);
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mImageAnalysisTargetSize);
        if (this.mAnalysisBackgroundExecutor != null) {
            builder.setBackgroundExecutor(this.mAnalysisBackgroundExecutor);
        }
        this.mImageAnalysis = builder.build();
        if (this.mAnalysisExecutor != null && this.mAnalysisAnalyzer != null) {
            this.mImageAnalysis.setAnalyzer(this.mAnalysisExecutor, this.mAnalysisAnalyzer);
        }
    }

    @OptIn(markerClass={TransformExperimental.class, ExperimentalAnalyzer.class})
    @MainThread
    void updatePreviewViewTransform(@Nullable OutputTransform outputTransform) {
        Threads.checkMainThread();
        if (this.mAnalysisAnalyzer == null) {
            return;
        }
        if (outputTransform == null) {
            this.mAnalysisAnalyzer.updateTransform(null);
        } else if (this.mAnalysisAnalyzer.getTargetCoordinateSystem() == 1) {
            this.mAnalysisAnalyzer.updateTransform(outputTransform.getMatrix());
        }
    }

    @ExperimentalVideo
    @MainThread
    public boolean isVideoCaptureEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(4);
    }

    @SuppressLint(value={"MissingPermission"})
    @ExperimentalVideo
    @MainThread
    public void startRecording(@NonNull OutputFileOptions outputFileOptions, @NonNull Executor executor, final @NonNull OnVideoSavedCallback callback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isVideoCaptureEnabled(), (String)VIDEO_CAPTURE_DISABLED);
        this.mVideoCapture.startRecording(outputFileOptions.toVideoCaptureOutputFileOptions(), executor, new VideoCapture.OnVideoSavedCallback(){

            public void onVideoSaved(@NonNull VideoCapture.OutputFileResults outputFileResults) {
                CameraController.this.mVideoIsRecording.set(false);
                callback.onVideoSaved(OutputFileResults.create(outputFileResults.getSavedUri()));
            }

            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                CameraController.this.mVideoIsRecording.set(false);
                callback.onError(videoCaptureError, message, cause);
            }
        });
        this.mVideoIsRecording.set(true);
    }

    @ExperimentalVideo
    @MainThread
    public void stopRecording() {
        Threads.checkMainThread();
        if (this.mVideoIsRecording.get()) {
            this.mVideoCapture.stopRecording();
        }
    }

    @ExperimentalVideo
    @MainThread
    public boolean isRecording() {
        Threads.checkMainThread();
        return this.mVideoIsRecording.get();
    }

    @ExperimentalVideo
    @MainThread
    public void setVideoCaptureTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mVideoCaptureOutputSize, targetSize)) {
            return;
        }
        this.mVideoCaptureOutputSize = targetSize;
        this.unbindVideoAndRecreate();
        this.startCameraAndTrackStates();
    }

    @ExperimentalVideo
    @MainThread
    @Nullable
    public OutputSize getVideoCaptureTargetSize() {
        Threads.checkMainThread();
        return this.mVideoCaptureOutputSize;
    }

    private void unbindVideoAndRecreate() {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mVideoCapture});
        }
        VideoCapture.Builder builder = new VideoCapture.Builder();
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mVideoCaptureOutputSize);
        this.mVideoCapture = builder.build();
    }

    @MainThread
    public void setCameraSelector(@NonNull CameraSelector cameraSelector) {
        Threads.checkMainThread();
        if (this.mCameraSelector == cameraSelector) {
            return;
        }
        CameraSelector oldCameraSelector = this.mCameraSelector;
        this.mCameraSelector = cameraSelector;
        if (this.mCameraProvider == null) {
            return;
        }
        this.mCameraProvider.unbind(new UseCase[]{this.mPreview, this.mImageCapture, this.mImageAnalysis, this.mVideoCapture});
        this.startCameraAndTrackStates(() -> {
            this.mCameraSelector = oldCameraSelector;
        });
    }

    @MainThread
    public boolean hasCamera(@NonNull CameraSelector cameraSelector) {
        Threads.checkMainThread();
        Preconditions.checkNotNull((Object)cameraSelector);
        if (this.mCameraProvider == null) {
            throw new IllegalStateException("Camera not initialized. Please wait for the initialization future to finish. See #getInitializationFuture().");
        }
        try {
            return this.mCameraProvider.hasCamera(cameraSelector);
        }
        catch (CameraInfoUnavailableException e) {
            Logger.w((String)TAG, (String)"Failed to check camera availability", (Throwable)e);
            return false;
        }
    }

    @NonNull
    @MainThread
    public CameraSelector getCameraSelector() {
        Threads.checkMainThread();
        return this.mCameraSelector;
    }

    @MainThread
    public boolean isPinchToZoomEnabled() {
        Threads.checkMainThread();
        return this.mPinchToZoomEnabled;
    }

    @MainThread
    public void setPinchToZoomEnabled(boolean enabled) {
        Threads.checkMainThread();
        this.mPinchToZoomEnabled = enabled;
    }

    void onPinchToZoom(float pinchToZoomScale) {
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        if (!this.mPinchToZoomEnabled) {
            Logger.d((String)TAG, (String)"Pinch to zoom disabled.");
            return;
        }
        Logger.d((String)TAG, (String)("Pinch to zoom with scale: " + pinchToZoomScale));
        ZoomState zoomState = (ZoomState)this.getZoomState().getValue();
        if (zoomState == null) {
            return;
        }
        float clampedRatio = zoomState.getZoomRatio() * this.speedUpZoomBy2X(pinchToZoomScale);
        clampedRatio = Math.min(Math.max(clampedRatio, zoomState.getMinZoomRatio()), zoomState.getMaxZoomRatio());
        this.setZoomRatio(clampedRatio);
    }

    private float speedUpZoomBy2X(float scaleFactor) {
        if (scaleFactor > 1.0f) {
            return 1.0f + (scaleFactor - 1.0f) * 2.0f;
        }
        return 1.0f - (1.0f - scaleFactor) * 2.0f;
    }

    void onTapToFocus(MeteringPointFactory meteringPointFactory, float x, float y) {
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        if (!this.mTapToFocusEnabled) {
            Logger.d((String)TAG, (String)"Tap to focus disabled. ");
            return;
        }
        Logger.d((String)TAG, (String)("Tap to focus started: " + x + ", " + y));
        this.mTapToFocusState.postValue((Object)1);
        MeteringPoint afPoint = meteringPointFactory.createPoint(x, y, 0.16666667f);
        MeteringPoint aePoint = meteringPointFactory.createPoint(x, y, 0.25f);
        FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(afPoint, 1).addPoint(aePoint, 2).build();
        Futures.addCallback((ListenableFuture)this.mCamera.getCameraControl().startFocusAndMetering(focusMeteringAction), (FutureCallback)new FutureCallback<FocusMeteringResult>(){

            public void onSuccess(@Nullable FocusMeteringResult result) {
                if (result == null) {
                    return;
                }
                Logger.d((String)CameraController.TAG, (String)("Tap to focus onSuccess: " + result.isFocusSuccessful()));
                CameraController.this.mTapToFocusState.postValue((Object)(result.isFocusSuccessful() ? 2 : 3));
            }

            public void onFailure(Throwable t) {
                if (t instanceof CameraControl.OperationCanceledException) {
                    Logger.d((String)CameraController.TAG, (String)"Tap-to-focus is canceled by new action.");
                    return;
                }
                Logger.d((String)CameraController.TAG, (String)"Tap to focus failed.", (Throwable)t);
                CameraController.this.mTapToFocusState.postValue((Object)4);
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    @MainThread
    public boolean isTapToFocusEnabled() {
        Threads.checkMainThread();
        return this.mTapToFocusEnabled;
    }

    @MainThread
    public void setTapToFocusEnabled(boolean enabled) {
        Threads.checkMainThread();
        this.mTapToFocusEnabled = enabled;
    }

    @MainThread
    @NonNull
    public LiveData<Integer> getTapToFocusState() {
        Threads.checkMainThread();
        return this.mTapToFocusState;
    }

    @NonNull
    @MainThread
    public LiveData<ZoomState> getZoomState() {
        Threads.checkMainThread();
        return this.mZoomState;
    }

    @Nullable
    @MainThread
    public CameraInfo getCameraInfo() {
        Threads.checkMainThread();
        return this.mCamera == null ? null : this.mCamera.getCameraInfo();
    }

    @Nullable
    @MainThread
    public CameraControl getCameraControl() {
        Threads.checkMainThread();
        return this.mCamera == null ? null : this.mCamera.getCameraControl();
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> setZoomRatio(float zoomRatio) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return Futures.immediateFuture(null);
        }
        return this.mCamera.getCameraControl().setZoomRatio(zoomRatio);
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> setLinearZoom(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return Futures.immediateFuture(null);
        }
        return this.mCamera.getCameraControl().setLinearZoom(linearZoom);
    }

    @NonNull
    @MainThread
    public LiveData<Integer> getTorchState() {
        Threads.checkMainThread();
        return this.mTorchState;
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> enableTorch(boolean torchEnabled) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return Futures.immediateFuture(null);
        }
        return this.mCamera.getCameraControl().enableTorch(torchEnabled);
    }

    void startCameraAndTrackStates() {
        this.startCameraAndTrackStates(null);
    }

    void startCameraAndTrackStates(@Nullable Runnable restoreStateRunnable) {
        try {
            this.mCamera = this.startCamera();
        }
        catch (IllegalArgumentException exception) {
            if (restoreStateRunnable != null) {
                restoreStateRunnable.run();
            }
            String errorMessage = "The selected camera does not support the enabled use cases. Please disable use case and/or select a different camera. e.g. #setVideoCaptureEnabled(false)";
            throw new IllegalStateException(errorMessage, exception);
        }
        if (!this.isCameraAttached()) {
            Logger.d((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        this.mZoomState.setSource((LiveData<ZoomState>)this.mCamera.getCameraInfo().getZoomState());
        this.mTorchState.setSource((LiveData<Integer>)this.mCamera.getCameraInfo().getTorchState());
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @OptIn(markerClass={ExperimentalVideo.class})
    protected UseCaseGroup createUseCaseGroup() {
        if (!this.isCameraInitialized()) {
            Logger.d((String)TAG, (String)CAMERA_NOT_INITIALIZED);
            return null;
        }
        if (!this.isPreviewViewAttached()) {
            Logger.d((String)TAG, (String)PREVIEW_VIEW_NOT_ATTACHED);
            return null;
        }
        UseCaseGroup.Builder builder = new UseCaseGroup.Builder().addUseCase((UseCase)this.mPreview);
        if (this.isImageCaptureEnabled()) {
            builder.addUseCase((UseCase)this.mImageCapture);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageCapture});
        }
        if (this.isImageAnalysisEnabled()) {
            builder.addUseCase((UseCase)this.mImageAnalysis);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalysis});
        }
        if (this.isVideoCaptureEnabled()) {
            builder.addUseCase((UseCase)this.mVideoCapture);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mVideoCapture});
        }
        builder.setViewPort(this.mViewPort);
        return builder.build();
    }

    @RequiresApi(value=21)
    public static final class OutputSize {
        public static final int UNASSIGNED_ASPECT_RATIO = -1;
        private final int mAspectRatio;
        @Nullable
        private final Size mResolution;

        public OutputSize(int aspectRatio) {
            Preconditions.checkArgument((aspectRatio != -1 ? 1 : 0) != 0);
            this.mAspectRatio = aspectRatio;
            this.mResolution = null;
        }

        public OutputSize(@NonNull Size resolution) {
            Preconditions.checkNotNull((Object)resolution);
            this.mAspectRatio = -1;
            this.mResolution = resolution;
        }

        public int getAspectRatio() {
            return this.mAspectRatio;
        }

        @Nullable
        public Size getResolution() {
            return this.mResolution;
        }

        @NonNull
        public String toString() {
            return "aspect ratio: " + this.mAspectRatio + " resolution: " + this.mResolution;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface OutputAspectRatio {
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        @NonNull
        static Context createAttributionContext(@NonNull Context context, @Nullable String attributeTag) {
            return context.createAttributionContext(attributeTag);
        }

        @DoNotInline
        @Nullable
        static String getAttributionTag(@NonNull Context context) {
            return context.getAttributionTag();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @OptIn(markerClass={ExperimentalVideo.class})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface UseCases {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface TapToFocusStates {
    }
}

