/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodec;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.video.internal.encoder.EncodedData;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class EncodedDataImpl
implements EncodedData {
    private final MediaCodec mMediaCodec;
    private final MediaCodec.BufferInfo mBufferInfo;
    private final int mBufferIndex;
    private final ByteBuffer mByteBuffer;
    private final ListenableFuture<Void> mClosedFuture;
    private final CallbackToFutureAdapter.Completer<Void> mClosedCompleter;
    private final AtomicBoolean mClosed = new AtomicBoolean(false);

    EncodedDataImpl(@NonNull MediaCodec mediaCodec, int bufferIndex, @NonNull MediaCodec.BufferInfo bufferInfo) throws MediaCodec.CodecException {
        this.mMediaCodec = (MediaCodec)Preconditions.checkNotNull((Object)mediaCodec);
        this.mBufferIndex = bufferIndex;
        this.mByteBuffer = mediaCodec.getOutputBuffer(bufferIndex);
        this.mBufferInfo = (MediaCodec.BufferInfo)Preconditions.checkNotNull((Object)bufferInfo);
        AtomicReference ref = new AtomicReference();
        this.mClosedFuture = CallbackToFutureAdapter.getFuture(completer -> {
            ref.set(completer);
            return "Data closed";
        });
        this.mClosedCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)((CallbackToFutureAdapter.Completer)ref.get()));
    }

    @Override
    @NonNull
    public ByteBuffer getByteBuffer() {
        this.throwIfClosed();
        this.mByteBuffer.position(this.mBufferInfo.offset);
        this.mByteBuffer.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
        return this.mByteBuffer;
    }

    @Override
    @NonNull
    public MediaCodec.BufferInfo getBufferInfo() {
        return this.mBufferInfo;
    }

    @Override
    public long getPresentationTimeUs() {
        return this.mBufferInfo.presentationTimeUs;
    }

    @Override
    public long size() {
        return this.mBufferInfo.size;
    }

    @Override
    public boolean isKeyFrame() {
        return (this.mBufferInfo.flags & 1) != 0;
    }

    @Override
    public void close() {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        try {
            this.mMediaCodec.releaseOutputBuffer(this.mBufferIndex, false);
        }
        catch (IllegalStateException e) {
            this.mClosedCompleter.setException((Throwable)e);
            return;
        }
        this.mClosedCompleter.set(null);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getClosedFuture() {
        return Futures.nonCancellationPropagating(this.mClosedFuture);
    }

    private void throwIfClosed() {
        if (this.mClosed.get()) {
            throw new IllegalStateException("encoded data is closed.");
        }
    }
}

