/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.camera.core.Logger;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.audio.AudioSettings;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.core.util.Supplier;

public final class AudioSettingsDefaultResolver
implements Supplier<AudioSettings> {
    private static final String TAG = "DefAudioResolver";
    private final AudioSpec mAudioSpec;

    public AudioSettingsDefaultResolver(@NonNull AudioSpec audioSpec) {
        this.mAudioSpec = audioSpec;
    }

    @NonNull
    public AudioSettings get() {
        int resolvedSampleRate;
        int resolvedChannelCount;
        int resolvedAudioSource = AudioConfigUtil.resolveAudioSource(this.mAudioSpec);
        int resolvedSourceFormat = AudioConfigUtil.resolveAudioSourceFormat(this.mAudioSpec);
        int audioSpecChannelCount = this.mAudioSpec.getChannelCount();
        if (audioSpecChannelCount == -1) {
            resolvedChannelCount = 1;
            Logger.d((String)TAG, (String)("Using fallback AUDIO channel count: " + resolvedChannelCount));
        } else {
            resolvedChannelCount = audioSpecChannelCount;
            Logger.d((String)TAG, (String)("Using supplied AUDIO channel count: " + audioSpecChannelCount));
        }
        Range<Integer> audioSpecSampleRateRange = this.mAudioSpec.getSampleRate();
        if (AudioSpec.SAMPLE_RATE_RANGE_AUTO.equals(audioSpecSampleRateRange)) {
            resolvedSampleRate = 44100;
            Logger.d((String)TAG, (String)("Using fallback AUDIO sample rate: " + resolvedSampleRate + "Hz"));
        } else {
            resolvedSampleRate = AudioConfigUtil.selectSampleRateOrNearestSupported(audioSpecSampleRateRange, resolvedChannelCount, resolvedSourceFormat, (Integer)audioSpecSampleRateRange.getUpper());
            Logger.d((String)TAG, (String)("Using AUDIO sample rate resolved from AudioSpec: " + resolvedSampleRate + "Hz"));
        }
        return AudioSettings.builder().setAudioSource(resolvedAudioSource).setAudioFormat(resolvedSourceFormat).setChannelCount(resolvedChannelCount).setSampleRate(resolvedSampleRate).build();
    }
}

