/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.core.Logger;
import androidx.core.util.Pair;
import androidx.core.util.Preconditions;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public final class SharedByteBuffer
implements Closeable {
    private static final String TAG = "SharedByteBuffer";
    private final ByteBuffer mSharedByteBuffer;
    private final int mShareId;
    private final Object mCloseLock = new Object();
    private final Pair<Executor, Runnable> mFinalCloseAction;
    @GuardedBy(value="mCloseLock")
    private final AtomicInteger mSharedRefCount;
    @GuardedBy(value="mCloseLock")
    private boolean mClosed = false;

    @NonNull
    static SharedByteBuffer newSharedInstance(@NonNull ByteBuffer sharedBuf, @NonNull Executor closeActionExecutor, @NonNull Runnable finalCloseAction) {
        AtomicInteger sharedRefCount = new AtomicInteger(1);
        int shareId = System.identityHashCode(sharedBuf);
        ByteBuffer readOnlyBuf = ((ByteBuffer)Preconditions.checkNotNull((Object)sharedBuf)).asReadOnlyBuffer();
        return new SharedByteBuffer(readOnlyBuf, sharedRefCount, (Pair<Executor, Runnable>)new Pair((Object)((Executor)Preconditions.checkNotNull((Object)closeActionExecutor)), (Object)((Runnable)Preconditions.checkNotNull((Object)finalCloseAction))), shareId);
    }

    private SharedByteBuffer(@NonNull ByteBuffer sharedBuf, @NonNull AtomicInteger sharedRefCount, @NonNull Pair<Executor, Runnable> finalCloseAction, int shareId) {
        int refCount;
        this.mSharedByteBuffer = sharedBuf;
        this.mSharedRefCount = sharedRefCount;
        this.mFinalCloseAction = finalCloseAction;
        this.mShareId = shareId;
        if (Logger.isDebugEnabled((String)TAG) && (refCount = sharedRefCount.get()) < 1) {
            throw new AssertionError((Object)String.format(Locale.US, "Cannot create new instance of SharedByteBuffer with invalid ref count %d. Ref count must be >= 1. [%s]", refCount, this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    SharedByteBuffer share() {
        AtomicInteger sharedRefCountLocal;
        int newRefCount;
        Object object = this.mCloseLock;
        synchronized (object) {
            this.checkNotClosed("share()");
            newRefCount = this.mSharedRefCount.incrementAndGet();
            sharedRefCountLocal = this.mSharedRefCount;
        }
        if (Logger.isDebugEnabled((String)TAG)) {
            if (newRefCount <= 1) {
                throw new AssertionError((Object)"Invalid ref count. share() should always produce a ref count of 2 or more.");
            }
            Logger.d((String)TAG, (String)String.format(Locale.US, "Ref count incremented: %d [%s]", newRefCount, this.toString()));
        }
        return new SharedByteBuffer(this.mSharedByteBuffer.asReadOnlyBuffer(), sharedRefCountLocal, this.mFinalCloseAction, this.mShareId);
    }

    @Override
    public void close() {
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ByteBuffer get() {
        Object object = this.mCloseLock;
        synchronized (object) {
            this.checkNotClosed("get()");
            return this.mSharedByteBuffer;
        }
    }

    @GuardedBy(value="mCloseLock")
    private void checkNotClosed(@NonNull String caller) {
        if (this.mClosed) {
            throw new IllegalStateException("Cannot call " + caller + " on a closed SharedByteBuffer.");
        }
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "SharedByteBuffer[buf: %s, shareId: 0x%x, instanceId:0x%x]", this.mSharedByteBuffer, this.mShareId, System.identityHashCode(this));
    }

    protected void finalize() throws Throwable {
        try {
            if (this.closeInternal()) {
                Logger.w((String)TAG, (String)String.format(Locale.US, "SharedByteBuffer closed by finalizer, but should have been closed manually with SharedByteBuffer.close() [%s]", this.toString()));
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal() {
        int newRefCount;
        Object object = this.mCloseLock;
        synchronized (object) {
            if (this.mClosed) {
                return false;
            }
            this.mClosed = true;
            newRefCount = this.mSharedRefCount.decrementAndGet();
        }
        if (Logger.isDebugEnabled((String)TAG)) {
            if (newRefCount < 0) {
                throw new AssertionError((Object)"Invalid ref count. close() should never produce a ref count below 0");
            }
            Logger.d((String)TAG, (String)String.format(Locale.US, "Ref count decremented: %d [%s]", newRefCount, this.toString()));
        }
        if (newRefCount == 0) {
            if (Logger.isDebugEnabled((String)TAG)) {
                Logger.d((String)TAG, (String)String.format(Locale.US, "Final reference released. Running final close action. [%s]", this.toString()));
            }
            try {
                Executor executor = (Executor)Preconditions.checkNotNull((Object)((Executor)this.mFinalCloseAction.first));
                Runnable runnable = (Runnable)Preconditions.checkNotNull((Object)((Runnable)this.mFinalCloseAction.second));
                executor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                Logger.e((String)TAG, (String)String.format(Locale.US, "Unable to execute final close action. [%s]", this.toString()), (Throwable)e);
            }
        }
        return true;
    }
}

