/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.ConstantObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.StreamInfo;
import androidx.camera.video.VideoCapabilities;

public interface VideoOutput {
    public void onSurfaceRequested(@NonNull SurfaceRequest var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    default public void onSurfaceRequested(@NonNull SurfaceRequest request, @NonNull Timebase timebase) {
        this.onSurfaceRequested(request);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    default public Observable<StreamInfo> getStreamInfo() {
        return StreamInfo.ALWAYS_ACTIVE_OBSERVABLE;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    default public Observable<MediaSpec> getMediaSpec() {
        return ConstantObservable.withValue(null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    default public Observable<Boolean> isSourceStreamRequired() {
        return ConstantObservable.withValue((Object)false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    default public void onSourceStateChanged(@NonNull SourceState sourceState) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    default public VideoCapabilities getMediaCapabilities(@NonNull CameraInfo cameraInfo) {
        return VideoCapabilities.EMPTY;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static enum SourceState {
        ACTIVE_STREAMING,
        ACTIVE_NON_STREAMING,
        INACTIVE;

    }
}

