/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.video.AutoValue_MediaStoreOutputOptions_MediaStoreOutputOptionsInternal;
import androidx.camera.video.OutputOptions;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;

public final class MediaStoreOutputOptions
extends OutputOptions {
    @NonNull
    public static final ContentValues EMPTY_CONTENT_VALUES = new ContentValues();
    private final MediaStoreOutputOptionsInternal mMediaStoreOutputOptionsInternal;

    MediaStoreOutputOptions(@NonNull MediaStoreOutputOptionsInternal mediaStoreOutputOptionsInternal) {
        super(mediaStoreOutputOptionsInternal);
        this.mMediaStoreOutputOptionsInternal = mediaStoreOutputOptionsInternal;
    }

    @NonNull
    public ContentResolver getContentResolver() {
        return this.mMediaStoreOutputOptionsInternal.getContentResolver();
    }

    @NonNull
    public Uri getCollectionUri() {
        return this.mMediaStoreOutputOptionsInternal.getCollectionUri();
    }

    @NonNull
    public ContentValues getContentValues() {
        return this.mMediaStoreOutputOptionsInternal.getContentValues();
    }

    @NonNull
    public String toString() {
        return this.mMediaStoreOutputOptionsInternal.toString().replaceFirst("MediaStoreOutputOptionsInternal", "MediaStoreOutputOptions");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaStoreOutputOptions)) {
            return false;
        }
        return this.mMediaStoreOutputOptionsInternal.equals(((MediaStoreOutputOptions)o).mMediaStoreOutputOptionsInternal);
    }

    public int hashCode() {
        return this.mMediaStoreOutputOptionsInternal.hashCode();
    }

    @AutoValue
    static abstract class MediaStoreOutputOptionsInternal
    extends OutputOptions.OutputOptionsInternal {
        MediaStoreOutputOptionsInternal() {
        }

        @NonNull
        abstract ContentResolver getContentResolver();

        @NonNull
        abstract Uri getCollectionUri();

        @NonNull
        abstract ContentValues getContentValues();

        @AutoValue.Builder
        static abstract class Builder
        extends OutputOptions.OutputOptionsInternal.Builder<Builder> {
            Builder() {
            }

            @NonNull
            abstract Builder setContentResolver(@NonNull ContentResolver var1);

            @NonNull
            abstract Builder setCollectionUri(@NonNull Uri var1);

            @NonNull
            abstract Builder setContentValues(@NonNull ContentValues var1);

            @Override
            @NonNull
            abstract MediaStoreOutputOptionsInternal build();
        }
    }

    public static final class Builder
    extends OutputOptions.Builder<MediaStoreOutputOptions, Builder> {
        private final MediaStoreOutputOptionsInternal.Builder mInternalBuilder;

        public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri collectionUri) {
            super(new AutoValue_MediaStoreOutputOptions_MediaStoreOutputOptionsInternal.Builder());
            Preconditions.checkNotNull((Object)contentResolver, (Object)"Content resolver can't be null.");
            Preconditions.checkNotNull((Object)collectionUri, (Object)"Collection Uri can't be null.");
            this.mInternalBuilder = (MediaStoreOutputOptionsInternal.Builder)this.mRootInternalBuilder;
            this.mInternalBuilder.setContentResolver(contentResolver).setCollectionUri(collectionUri).setContentValues(EMPTY_CONTENT_VALUES);
        }

        @NonNull
        public Builder setContentValues(@NonNull ContentValues contentValues) {
            Preconditions.checkNotNull((Object)contentValues, (Object)"Content values can't be null.");
            this.mInternalBuilder.setContentValues(contentValues);
            return this;
        }

        @Override
        @NonNull
        public MediaStoreOutputOptions build() {
            return new MediaStoreOutputOptions(this.mInternalBuilder.build());
        }
    }
}

