/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.MediaCodecInfoReportIncorrectInfoQuirk;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.core.util.Preconditions;
import java.util.HashSet;
import java.util.Set;

public class VideoEncoderInfoWrapper
implements VideoEncoderInfo {
    private static final String TAG = "VideoEncoderInfoWrapper";
    private static final int WIDTH_4KDCI = 4096;
    private static final int HEIGHT_4KDCI = 2160;
    private final VideoEncoderInfo mVideoEncoderInfo;
    private final Range<Integer> mSupportedWidths;
    private final Range<Integer> mSupportedHeights;
    private final Set<Size> mExtraSupportedSizes = new HashSet<Size>();

    @NonNull
    public static VideoEncoderInfo from(@NonNull VideoEncoderInfo videoEncoderInfo, @Nullable Size validSizeToCheck) {
        boolean toWrap;
        if (videoEncoderInfo instanceof VideoEncoderInfoWrapper) {
            toWrap = false;
        } else if (DeviceQuirks.get(MediaCodecInfoReportIncorrectInfoQuirk.class) != null) {
            toWrap = true;
        } else if (validSizeToCheck != null && !videoEncoderInfo.isSizeSupportedAllowSwapping(validSizeToCheck.getWidth(), validSizeToCheck.getHeight())) {
            Logger.w((String)TAG, (String)String.format("Detected that the device does not support a size %s that should be valid in widths/heights = %s/%s", validSizeToCheck, videoEncoderInfo.getSupportedWidths(), videoEncoderInfo.getSupportedHeights()));
            toWrap = true;
        } else {
            toWrap = false;
        }
        if (toWrap) {
            videoEncoderInfo = new VideoEncoderInfoWrapper(videoEncoderInfo);
        }
        if (validSizeToCheck != null && videoEncoderInfo instanceof VideoEncoderInfoWrapper) {
            ((VideoEncoderInfoWrapper)videoEncoderInfo).addExtraSupportedSize(validSizeToCheck);
        }
        return videoEncoderInfo;
    }

    private VideoEncoderInfoWrapper(@NonNull VideoEncoderInfo videoEncoderInfo) {
        this.mVideoEncoderInfo = videoEncoderInfo;
        int widthAlignment = videoEncoderInfo.getWidthAlignment();
        int maxWidth = (int)Math.ceil(4096.0 / (double)widthAlignment) * widthAlignment;
        this.mSupportedWidths = Range.create((Comparable)Integer.valueOf(widthAlignment), (Comparable)Integer.valueOf(maxWidth));
        int heightAlignment = videoEncoderInfo.getHeightAlignment();
        int maxHeight = (int)Math.ceil(2160.0 / (double)heightAlignment) * heightAlignment;
        this.mSupportedHeights = Range.create((Comparable)Integer.valueOf(heightAlignment), (Comparable)Integer.valueOf(maxHeight));
        this.mExtraSupportedSizes.addAll(MediaCodecInfoReportIncorrectInfoQuirk.getExtraSupportedSizes());
    }

    @Override
    @NonNull
    public String getName() {
        return this.mVideoEncoderInfo.getName();
    }

    @Override
    public boolean canSwapWidthHeight() {
        return this.mVideoEncoderInfo.canSwapWidthHeight();
    }

    @Override
    public boolean isSizeSupported(int width, int height) {
        if (this.mVideoEncoderInfo.isSizeSupported(width, height)) {
            return true;
        }
        for (Size size : this.mExtraSupportedSizes) {
            if (size.getWidth() != width || size.getHeight() != height) continue;
            return true;
        }
        return this.mSupportedWidths.contains((Comparable)Integer.valueOf(width)) && this.mSupportedHeights.contains((Comparable)Integer.valueOf(height)) && width % this.mVideoEncoderInfo.getWidthAlignment() == 0 && height % this.mVideoEncoderInfo.getHeightAlignment() == 0;
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedWidths() {
        return this.mSupportedWidths;
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedHeights() {
        return this.mSupportedHeights;
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedWidthsFor(int height) {
        Preconditions.checkArgument((this.mSupportedHeights.contains((Comparable)Integer.valueOf(height)) && height % this.mVideoEncoderInfo.getHeightAlignment() == 0 ? 1 : 0) != 0, (Object)("Not supported height: " + height + " which is not in " + this.mSupportedHeights + " or can not be divided by alignment " + this.mVideoEncoderInfo.getHeightAlignment()));
        return this.mSupportedWidths;
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedHeightsFor(int width) {
        Preconditions.checkArgument((this.mSupportedWidths.contains((Comparable)Integer.valueOf(width)) && width % this.mVideoEncoderInfo.getWidthAlignment() == 0 ? 1 : 0) != 0, (Object)("Not supported width: " + width + " which is not in " + this.mSupportedWidths + " or can not be divided by alignment " + this.mVideoEncoderInfo.getWidthAlignment()));
        return this.mSupportedHeights;
    }

    @Override
    public int getWidthAlignment() {
        return this.mVideoEncoderInfo.getWidthAlignment();
    }

    @Override
    public int getHeightAlignment() {
        return this.mVideoEncoderInfo.getHeightAlignment();
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedBitrateRange() {
        return this.mVideoEncoderInfo.getSupportedBitrateRange();
    }

    private void addExtraSupportedSize(@NonNull Size size) {
        this.mExtraSupportedSizes.add(size);
    }
}

