/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.video.internal.compat.quirk.StretchedVideoResolutionQuirk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QualityResolutionModifiedEncoderProfilesProvider
implements EncoderProfilesProvider {
    @NonNull
    private final EncoderProfilesProvider mProvider;
    @NonNull
    private final Quirks mQuirks;
    @NonNull
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();

    public QualityResolutionModifiedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull Quirks quirks) {
        this.mProvider = provider;
        this.mQuirks = quirks;
    }

    public boolean hasProfile(int quality) {
        if (!this.mProvider.hasProfile(quality)) {
            return false;
        }
        return this.getProfilesInternal(quality) != null;
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        return this.getProfilesInternal(quality);
    }

    @Nullable
    private EncoderProfilesProxy getProfilesInternal(int quality) {
        if (this.mEncoderProfilesCache.containsKey(quality)) {
            return this.mEncoderProfilesCache.get(quality);
        }
        EncoderProfilesProxy profiles = null;
        if (this.mProvider.hasProfile(quality)) {
            EncoderProfilesProxy baseProfiles = Objects.requireNonNull(this.mProvider.getAll(quality));
            Size alternativeResolution = this.getAlternativeResolution(quality);
            profiles = alternativeResolution == null ? baseProfiles : this.createNewEncoderProfiles(baseProfiles, alternativeResolution);
        }
        this.mEncoderProfilesCache.put(quality, profiles);
        return profiles;
    }

    @Nullable
    private Size getAlternativeResolution(int quality) {
        for (StretchedVideoResolutionQuirk quirk : this.mQuirks.getAll(StretchedVideoResolutionQuirk.class)) {
            if (quirk == null) continue;
            return quirk.getAlternativeResolution(quality);
        }
        return null;
    }

    @Nullable
    private EncoderProfilesProxy createNewEncoderProfiles(@NonNull EncoderProfilesProxy baseProfiles, @NonNull Size resolution) {
        ArrayList<EncoderProfilesProxy.VideoProfileProxy> newVideoProfiles = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>();
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : baseProfiles.getVideoProfiles()) {
            EncoderProfilesProxy.VideoProfileProxy newVideoProfile = QualityResolutionModifiedEncoderProfilesProvider.generateVideoProfile(videoProfile, resolution);
            newVideoProfiles.add(newVideoProfile);
        }
        return newVideoProfiles.isEmpty() ? null : EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)baseProfiles.getDefaultDurationSeconds(), (int)baseProfiles.getRecommendedFileFormat(), (List)baseProfiles.getAudioProfiles(), newVideoProfiles);
    }

    @NonNull
    private static EncoderProfilesProxy.VideoProfileProxy generateVideoProfile(@NonNull EncoderProfilesProxy.VideoProfileProxy baseProfile, @NonNull Size resolution) {
        return EncoderProfilesProxy.VideoProfileProxy.create((int)baseProfile.getCodec(), (String)baseProfile.getMediaType(), (int)baseProfile.getBitrate(), (int)baseProfile.getFrameRate(), (int)resolution.getWidth(), (int)resolution.getHeight(), (int)baseProfile.getProfile(), (int)baseProfile.getBitDepth(), (int)baseProfile.getChromaSubsampling(), (int)baseProfile.getHdrFormat());
    }
}

