/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.utils;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.util.LruCache;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.video.internal.encoder.EncoderConfig;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import java.io.IOException;

public final class CodecUtil {
    private static final int MAX_CODEC_INFO_CACHE_COUNT = 10;
    @GuardedBy(value="sCodecInfoCache")
    private static final LruCache<String, MediaCodecInfo> sCodecInfoCache = new LruCache(10);

    private CodecUtil() {
    }

    @NonNull
    public static MediaCodec createCodec(@NonNull EncoderConfig encoderConfig) throws InvalidConfigException {
        return CodecUtil.createCodec(encoderConfig.getMimeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MediaCodecInfo findCodecAndGetCodecInfo(@NonNull EncoderConfig encoderConfig) throws InvalidConfigException {
        MediaCodecInfo codecInfo;
        String mimeType = encoderConfig.getMimeType();
        LruCache<String, MediaCodecInfo> lruCache = sCodecInfoCache;
        synchronized (lruCache) {
            codecInfo = (MediaCodecInfo)sCodecInfoCache.get((Object)mimeType);
        }
        if (codecInfo != null) {
            return codecInfo;
        }
        MediaCodec codec = null;
        try {
            codec = CodecUtil.createCodec(mimeType);
            codecInfo = codec.getCodecInfo();
            MediaCodecInfo mediaCodecInfo = sCodecInfoCache;
            synchronized (mediaCodecInfo) {
                sCodecInfoCache.put((Object)mimeType, (Object)codecInfo);
            }
            mediaCodecInfo = codecInfo;
            return mediaCodecInfo;
        }
        finally {
            if (codec != null) {
                codec.release();
            }
        }
    }

    @NonNull
    private static MediaCodec createCodec(@NonNull String mimeType) throws InvalidConfigException {
        try {
            return MediaCodec.createEncoderByType((String)mimeType);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidConfigException(e);
        }
    }
}

