/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodecInfo;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import androidx.camera.video.internal.encoder.AudioEncoderInfo;
import androidx.camera.video.internal.encoder.EncoderInfoImpl;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.camera.video.internal.utils.CodecUtil;
import java.util.Objects;

public class AudioEncoderInfoImpl
extends EncoderInfoImpl
implements AudioEncoderInfo {
    private final MediaCodecInfo.AudioCapabilities mAudioCapabilities;

    @NonNull
    public static AudioEncoderInfoImpl from(@NonNull AudioEncoderConfig encoderConfig) throws InvalidConfigException {
        return new AudioEncoderInfoImpl(CodecUtil.findCodecAndGetCodecInfo(encoderConfig), encoderConfig.getMimeType());
    }

    AudioEncoderInfoImpl(@NonNull MediaCodecInfo codecInfo, @NonNull String mime) throws InvalidConfigException {
        super(codecInfo, mime);
        this.mAudioCapabilities = Objects.requireNonNull(this.mCodecCapabilities.getAudioCapabilities());
    }

    @Override
    @NonNull
    public Range<Integer> getBitrateRange() {
        return this.mAudioCapabilities.getBitrateRange();
    }
}

