/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.audio.AudioSettings;
import androidx.camera.video.internal.audio.AudioSource;
import androidx.camera.video.internal.config.AudioEncoderConfigAudioProfileResolver;
import androidx.camera.video.internal.config.AudioEncoderConfigDefaultResolver;
import androidx.camera.video.internal.config.AudioMimeInfo;
import androidx.camera.video.internal.config.AudioSettingsAudioProfileResolver;
import androidx.camera.video.internal.config.AudioSettingsDefaultResolver;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public final class AudioConfigUtil {
    private static final String TAG = "AudioConfigUtil";
    static final int AUDIO_SAMPLE_RATE_DEFAULT = 44100;
    static final int AUDIO_CHANNEL_COUNT_DEFAULT = 1;
    static final int AUDIO_SOURCE_FORMAT_DEFAULT = 2;
    static final int AUDIO_SOURCE_DEFAULT = 5;

    private AudioConfigUtil() {
    }

    @NonNull
    public static AudioMimeInfo resolveAudioMimeInfo(@NonNull MediaSpec mediaSpec, @Nullable VideoValidatedEncoderProfilesProxy encoderProfiles) {
        String mediaSpecAudioMime = MediaSpec.outputFormatToAudioMime(mediaSpec.getOutputFormat());
        int mediaSpecAudioProfile = MediaSpec.outputFormatToAudioProfile(mediaSpec.getOutputFormat());
        String resolvedAudioMime = mediaSpecAudioMime;
        int resolvedAudioProfile = mediaSpecAudioProfile;
        EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile = null;
        if (encoderProfiles != null && encoderProfiles.getDefaultAudioProfile() != null) {
            EncoderProfilesProxy.AudioProfileProxy audioProfile = encoderProfiles.getDefaultAudioProfile();
            String encoderProfileAudioMime = audioProfile.getMediaType();
            int encoderProfileAudioProfile = audioProfile.getProfile();
            if (Objects.equals(encoderProfileAudioMime, "audio/none")) {
                Logger.d((String)TAG, (String)("EncoderProfiles contains undefined AUDIO mime type so cannot be used. May rely on fallback defaults to derive settings [chosen mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            } else if (mediaSpec.getOutputFormat() == -1) {
                compatibleAudioProfile = audioProfile;
                resolvedAudioMime = encoderProfileAudioMime;
                resolvedAudioProfile = encoderProfileAudioProfile;
                Logger.d((String)TAG, (String)("MediaSpec contains OUTPUT_FORMAT_AUTO. Using EncoderProfiles to derive AUDIO settings [mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            } else if (Objects.equals(mediaSpecAudioMime, encoderProfileAudioMime) && mediaSpecAudioProfile == encoderProfileAudioProfile) {
                compatibleAudioProfile = audioProfile;
                resolvedAudioMime = encoderProfileAudioMime;
                Logger.d((String)TAG, (String)("MediaSpec audio mime/profile matches EncoderProfiles. Using EncoderProfiles to derive AUDIO settings [mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            } else {
                Logger.d((String)TAG, (String)("MediaSpec audio mime or profile does not match EncoderProfiles, so EncoderProfiles settings cannot be used. May rely on fallback defaults to derive AUDIO settings [EncoderProfiles mime type: " + encoderProfileAudioMime + "(profile: " + encoderProfileAudioProfile + "), chosen mime type: " + resolvedAudioMime + "(profile: " + resolvedAudioProfile + ")]"));
            }
        }
        AudioMimeInfo.Builder mimeInfoBuilder = (AudioMimeInfo.Builder)AudioMimeInfo.builder(resolvedAudioMime).setProfile(resolvedAudioProfile);
        if (compatibleAudioProfile != null) {
            mimeInfoBuilder.setCompatibleAudioProfile(compatibleAudioProfile);
        }
        return mimeInfoBuilder.build();
    }

    @NonNull
    public static AudioSettings resolveAudioSettings(@NonNull AudioMimeInfo audioMimeInfo, @NonNull AudioSpec audioSpec) {
        EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile = audioMimeInfo.getCompatibleAudioProfile();
        Object settingsSupplier = compatibleAudioProfile != null ? new AudioSettingsAudioProfileResolver(audioSpec, compatibleAudioProfile) : new AudioSettingsDefaultResolver(audioSpec);
        return (AudioSettings)settingsSupplier.get();
    }

    @NonNull
    public static AudioEncoderConfig resolveAudioEncoderConfig(@NonNull AudioMimeInfo audioMimeInfo, @NonNull Timebase inputTimebase, @NonNull AudioSettings audioSettings, @NonNull AudioSpec audioSpec) {
        EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile = audioMimeInfo.getCompatibleAudioProfile();
        Object configSupplier = compatibleAudioProfile != null ? new AudioEncoderConfigAudioProfileResolver(audioMimeInfo.getMimeType(), audioMimeInfo.getProfile(), inputTimebase, audioSpec, audioSettings, compatibleAudioProfile) : new AudioEncoderConfigDefaultResolver(audioMimeInfo.getMimeType(), audioMimeInfo.getProfile(), inputTimebase, audioSpec, audioSettings);
        return (AudioEncoderConfig)configSupplier.get();
    }

    static int resolveAudioSource(@NonNull AudioSpec audioSpec) {
        int resolvedAudioSource = audioSpec.getSource();
        if (resolvedAudioSource == -1) {
            resolvedAudioSource = 5;
            Logger.d((String)TAG, (String)("Using default AUDIO source: " + resolvedAudioSource));
        } else {
            Logger.d((String)TAG, (String)("Using provided AUDIO source: " + resolvedAudioSource));
        }
        return resolvedAudioSource;
    }

    static int resolveAudioSourceFormat(@NonNull AudioSpec audioSpec) {
        int resolvedAudioSourceFormat = audioSpec.getSourceFormat();
        if (resolvedAudioSourceFormat == -1) {
            resolvedAudioSourceFormat = 2;
            Logger.d((String)TAG, (String)("Using default AUDIO source format: " + resolvedAudioSourceFormat));
        } else {
            Logger.d((String)TAG, (String)("Using provided AUDIO source format: " + resolvedAudioSourceFormat));
        }
        return resolvedAudioSourceFormat;
    }

    static int selectSampleRateOrNearestSupported(@NonNull Range<Integer> targetRange, int channelCount, int sourceFormat, int initialTargetSampleRate) {
        int selectedSampleRate = initialTargetSampleRate;
        ArrayList<Integer> sortedCommonSampleRates = null;
        int i = 0;
        while (true) {
            if (targetRange.contains((Comparable)Integer.valueOf(selectedSampleRate))) {
                if (AudioSource.isSettingsSupported(selectedSampleRate, channelCount, sourceFormat)) {
                    return selectedSampleRate;
                }
                Logger.d((String)TAG, (String)("Sample rate " + selectedSampleRate + "Hz is not supported by audio source with channel count " + channelCount + " and source format " + sourceFormat));
            } else {
                Logger.d((String)TAG, (String)("Sample rate " + selectedSampleRate + "Hz is not in target range " + targetRange));
            }
            if (sortedCommonSampleRates == null) {
                Logger.d((String)TAG, (String)("Trying common sample rates in proximity order to target " + initialTargetSampleRate + "Hz"));
                sortedCommonSampleRates = new ArrayList<Integer>(AudioSettings.COMMON_SAMPLE_RATES);
                Collections.sort(sortedCommonSampleRates, (x, y) -> {
                    int relativeDifference = Math.abs(x - initialTargetSampleRate) - Math.abs(y - initialTargetSampleRate);
                    if (relativeDifference == 0) {
                        return (int)Math.signum(x - y);
                    }
                    return (int)Math.signum(relativeDifference);
                });
            }
            if (i >= sortedCommonSampleRates.size()) break;
            selectedSampleRate = (Integer)sortedCommonSampleRates.get(i++);
        }
        Logger.d((String)TAG, (String)"No sample rate found in target range or supported by audio source. Falling back to default sample rate of 44100Hz");
        return 44100;
    }

    static int scaleAndClampBitrate(int baseBitrate, int actualChannelCount, int baseChannelCount, int actualSampleRate, int baseSampleRate, Range<Integer> clampedRange) {
        Rational channelCountRatio = new Rational(actualChannelCount, baseChannelCount);
        Rational sampleRateRatio = new Rational(actualSampleRate, baseSampleRate);
        int resolvedBitrate = (int)((double)baseBitrate * channelCountRatio.doubleValue() * sampleRateRatio.doubleValue());
        String debugString = "";
        if (Logger.isDebugEnabled((String)TAG)) {
            debugString = String.format("Base Bitrate(%dbps) * Channel Count Ratio(%d / %d) * Sample Rate Ratio(%d / %d) = %d", baseBitrate, actualChannelCount, baseChannelCount, actualSampleRate, baseSampleRate, resolvedBitrate);
        }
        if (!AudioSpec.BITRATE_RANGE_AUTO.equals(clampedRange)) {
            resolvedBitrate = (Integer)clampedRange.clamp((Comparable)Integer.valueOf(resolvedBitrate));
            if (Logger.isDebugEnabled((String)TAG)) {
                debugString = debugString + String.format("\nClamped to range %s -> %dbps", clampedRange, resolvedBitrate);
            }
        }
        Logger.d((String)TAG, (String)debugString);
        return resolvedBitrate;
    }
}

