/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.video.internal.encoder.EncoderConfig;
import androidx.camera.video.internal.encoder.EncoderInfo;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.camera.video.internal.workaround.EncoderFinder;
import java.util.Objects;

@RequiresApi(value=21)
public abstract class EncoderInfoImpl
implements EncoderInfo {
    private final MediaCodecInfo mMediaCodecInfo;
    protected final MediaCodecInfo.CodecCapabilities mCodecCapabilities;

    EncoderInfoImpl(@NonNull MediaCodecInfo codecInfo, @NonNull String mime) throws InvalidConfigException {
        this.mMediaCodecInfo = codecInfo;
        try {
            this.mCodecCapabilities = Objects.requireNonNull(codecInfo.getCapabilitiesForType(mime));
        }
        catch (RuntimeException e) {
            throw new InvalidConfigException("Unable to get CodecCapabilities for mime: " + mime, e);
        }
    }

    @Override
    @NonNull
    public String getName() {
        return this.mMediaCodecInfo.getName();
    }

    @NonNull
    static MediaCodecInfo findCodecAndGetCodecInfo(@NonNull EncoderConfig encoderConfig) throws InvalidConfigException {
        MediaCodec codec = new EncoderFinder().findEncoder(encoderConfig.toMediaFormat());
        MediaCodecInfo codecInfo = codec.getCodecInfo();
        codec.release();
        return codecInfo;
    }
}

