/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.config.VideoConfigUtil;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderDataSpace;
import androidx.core.util.Supplier;
import java.util.Objects;

@RequiresApi(value=21)
public class VideoEncoderConfigVideoProfileResolver
implements Supplier<VideoEncoderConfig> {
    private static final String TAG = "VidEncVdPrflRslvr";
    private final String mMimeType;
    private final Timebase mInputTimebase;
    private final VideoSpec mVideoSpec;
    private final Size mSurfaceSize;
    private final EncoderProfilesProxy.VideoProfileProxy mVideoProfile;
    private final DynamicRange mDynamicRange;
    private final Range<Integer> mExpectedFrameRateRange;

    public VideoEncoderConfigVideoProfileResolver(@NonNull String mimeType, @NonNull Timebase inputTimebase, @NonNull VideoSpec videoSpec, @NonNull Size surfaceSize, @NonNull EncoderProfilesProxy.VideoProfileProxy videoProfile, @NonNull DynamicRange dynamicRange, @NonNull Range<Integer> expectedFrameRateRange) {
        this.mMimeType = mimeType;
        this.mInputTimebase = inputTimebase;
        this.mVideoSpec = videoSpec;
        this.mSurfaceSize = surfaceSize;
        this.mVideoProfile = videoProfile;
        this.mDynamicRange = dynamicRange;
        this.mExpectedFrameRateRange = expectedFrameRateRange;
    }

    @NonNull
    public VideoEncoderConfig get() {
        int resolvedFrameRate = this.resolveFrameRate();
        Logger.d((String)TAG, (String)("Resolved VIDEO frame rate: " + resolvedFrameRate + "fps"));
        Range<Integer> videoSpecBitrateRange = this.mVideoSpec.getBitrate();
        Logger.d((String)TAG, (String)"Using resolved VIDEO bitrate from EncoderProfiles");
        int resolvedBitrate = VideoConfigUtil.scaleAndClampBitrate(this.mVideoProfile.getBitrate(), this.mDynamicRange.getBitDepth(), this.mVideoProfile.getBitDepth(), resolvedFrameRate, this.mVideoProfile.getFrameRate(), this.mSurfaceSize.getWidth(), this.mVideoProfile.getWidth(), this.mSurfaceSize.getHeight(), this.mVideoProfile.getHeight(), videoSpecBitrateRange);
        int resolvedProfile = this.mVideoProfile.getProfile();
        VideoEncoderDataSpace dataSpace = VideoConfigUtil.mimeAndProfileToEncoderDataSpace(this.mMimeType, resolvedProfile);
        return VideoEncoderConfig.builder().setMimeType(this.mMimeType).setInputTimebase(this.mInputTimebase).setResolution(this.mSurfaceSize).setBitrate(resolvedBitrate).setFrameRate(resolvedFrameRate).setProfile(resolvedProfile).setDataSpace(dataSpace).build();
    }

    private int resolveFrameRate() {
        int videoProfileFrameRate = this.mVideoProfile.getFrameRate();
        int resolvedFrameRate = !Objects.equals(this.mExpectedFrameRateRange, SurfaceRequest.FRAME_RATE_RANGE_UNSPECIFIED) ? (Integer)this.mExpectedFrameRateRange.clamp((Comparable)Integer.valueOf(videoProfileFrameRate)) : videoProfileFrameRate;
        Logger.d((String)TAG, (String)String.format("Resolved frame rate %dfps [Video profile frame rate: %dfps, Expected operating range: %s]", resolvedFrameRate, videoProfileFrameRate, Objects.equals(this.mExpectedFrameRateRange, SurfaceRequest.FRAME_RATE_RANGE_UNSPECIFIED) ? this.mExpectedFrameRateRange : "<UNSPECIFIED>"));
        return resolvedFrameRate;
    }
}

