/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodec;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.video.internal.encoder.EncodedData;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
public class BufferCopiedEncodedData
implements EncodedData {
    private final ByteBuffer mByteBuffer;
    private final MediaCodec.BufferInfo mBufferInfo;
    private final ListenableFuture<Void> mClosedFuture;
    private final CallbackToFutureAdapter.Completer<Void> mClosedCompleter;

    public BufferCopiedEncodedData(@NonNull EncodedData encodedData) {
        this.mBufferInfo = this.generateCopiedByteInfo(encodedData);
        this.mByteBuffer = this.generateCopiedByteBuffer(encodedData);
        AtomicReference ref = new AtomicReference();
        this.mClosedFuture = CallbackToFutureAdapter.getFuture(completer -> {
            ref.set(completer);
            return "Data closed";
        });
        this.mClosedCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)((CallbackToFutureAdapter.Completer)ref.get()));
    }

    @NonNull
    private MediaCodec.BufferInfo generateCopiedByteInfo(@NonNull EncodedData encodedData) {
        MediaCodec.BufferInfo bufferInfo = encodedData.getBufferInfo();
        MediaCodec.BufferInfo copiedBufferInfo = new MediaCodec.BufferInfo();
        copiedBufferInfo.set(0, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
        return copiedBufferInfo;
    }

    @NonNull
    private ByteBuffer generateCopiedByteBuffer(@NonNull EncodedData encodedData) {
        ByteBuffer byteBuffer = encodedData.getByteBuffer();
        MediaCodec.BufferInfo bufferInfo = encodedData.getBufferInfo();
        byteBuffer.position(bufferInfo.offset);
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        ByteBuffer copiedByteBuffer = ByteBuffer.allocate(bufferInfo.size);
        copiedByteBuffer.put(byteBuffer);
        return copiedByteBuffer;
    }

    @Override
    @NonNull
    public ByteBuffer getByteBuffer() {
        return this.mByteBuffer;
    }

    @Override
    @NonNull
    public MediaCodec.BufferInfo getBufferInfo() {
        return this.mBufferInfo;
    }

    @Override
    public long getPresentationTimeUs() {
        return this.mBufferInfo.presentationTimeUs;
    }

    @Override
    public long size() {
        return this.mBufferInfo.size;
    }

    @Override
    public boolean isKeyFrame() {
        return (this.mBufferInfo.flags & 1) != 0;
    }

    @Override
    public void close() {
        this.mClosedCompleter.set(null);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getClosedFuture() {
        return Futures.nonCancellationPropagating(this.mClosedFuture);
    }
}

