/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CamcorderProfileProxy;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.config.VideoConfigUtil;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.core.util.Supplier;

@RequiresApi(value=21)
public class VideoEncoderConfigCamcorderProfileResolver
implements Supplier<VideoEncoderConfig> {
    private static final String TAG = "VidEncCmcrdrPrflRslvr";
    private final String mMimeType;
    private final VideoSpec mVideoSpec;
    private final Size mSurfaceSize;
    private final CamcorderProfileProxy mCamcorderProfile;

    public VideoEncoderConfigCamcorderProfileResolver(@NonNull String mimeType, @NonNull VideoSpec videoSpec, @NonNull Size surfaceSize, @NonNull CamcorderProfileProxy camcorderProfile) {
        this.mMimeType = mimeType;
        this.mVideoSpec = videoSpec;
        this.mSurfaceSize = surfaceSize;
        this.mCamcorderProfile = camcorderProfile;
    }

    @NonNull
    public VideoEncoderConfig get() {
        int resolvedFrameRate = VideoConfigUtil.resolveFrameRate(this.mVideoSpec);
        Range<Integer> videoSpecBitrateRange = this.mVideoSpec.getBitrate();
        Logger.d((String)TAG, (String)"Using resolved VIDEO bitrate from CamcorderProfile");
        int resolvedBitrate = VideoConfigUtil.scaleAndClampBitrate(this.mCamcorderProfile.getVideoBitRate(), resolvedFrameRate, this.mCamcorderProfile.getVideoFrameRate(), this.mSurfaceSize.getWidth(), this.mCamcorderProfile.getVideoFrameWidth(), this.mSurfaceSize.getHeight(), this.mCamcorderProfile.getVideoFrameHeight(), videoSpecBitrateRange);
        return VideoEncoderConfig.builder().setMimeType(this.mMimeType).setResolution(this.mSurfaceSize).setBitrate(resolvedBitrate).setFrameRate(resolvedFrameRate).build();
    }
}

