/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.AudioSource;
import java.util.ArrayList;
import java.util.Collections;

@RequiresApi(value=21)
public final class AudioConfigUtil {
    private static final String TAG = "AudioConfigUtil";
    static final int AUDIO_SAMPLE_RATE_DEFAULT = 44100;
    static final int AUDIO_CHANNEL_COUNT_DEFAULT = 1;
    static final int AUDIO_SOURCE_FORMAT_DEFAULT = 2;
    static final int AUDIO_SOURCE_DEFAULT = 5;

    private AudioConfigUtil() {
    }

    static int resolveAudioSource(@NonNull AudioSpec audioSpec) {
        int resolvedAudioSource = audioSpec.getSource();
        if (resolvedAudioSource == -1) {
            resolvedAudioSource = 5;
            Logger.d((String)TAG, (String)("Using default AUDIO source: " + resolvedAudioSource));
        } else {
            Logger.d((String)TAG, (String)("Using provided AUDIO source: " + resolvedAudioSource));
        }
        return resolvedAudioSource;
    }

    static int resolveAudioSourceFormat(@NonNull AudioSpec audioSpec) {
        int resolvedAudioSourceFormat = audioSpec.getSourceFormat();
        if (resolvedAudioSourceFormat == -1) {
            resolvedAudioSourceFormat = 2;
            Logger.d((String)TAG, (String)("Using default AUDIO source format: " + resolvedAudioSourceFormat));
        } else {
            Logger.d((String)TAG, (String)("Using provided AUDIO source format: " + resolvedAudioSourceFormat));
        }
        return resolvedAudioSourceFormat;
    }

    static int selectSampleRateOrNearestSupported(@NonNull Range<Integer> targetRange, int channelCount, int sourceFormat, int initialTargetSampleRate) {
        int selectedSampleRate = initialTargetSampleRate;
        ArrayList<Integer> sortedCommonSampleRates = null;
        int i = 0;
        while (true) {
            if (targetRange.contains((Comparable)Integer.valueOf(selectedSampleRate))) {
                if (AudioSource.isSettingsSupported(selectedSampleRate, channelCount, sourceFormat)) {
                    return selectedSampleRate;
                }
                Logger.d((String)TAG, (String)("Sample rate " + selectedSampleRate + "Hz is not supported by audio source with channel count " + channelCount + " and source format " + sourceFormat));
            } else {
                Logger.d((String)TAG, (String)("Sample rate " + selectedSampleRate + "Hz is not in target range " + targetRange));
            }
            if (sortedCommonSampleRates == null) {
                Logger.d((String)TAG, (String)("Trying common sample rates in proximity order to target " + initialTargetSampleRate + "Hz"));
                sortedCommonSampleRates = new ArrayList<Integer>(AudioSource.COMMON_SAMPLE_RATES);
                Collections.sort(sortedCommonSampleRates, (x, y) -> {
                    int relativeDifference = Math.abs(x - initialTargetSampleRate) - Math.abs(y - initialTargetSampleRate);
                    if (relativeDifference == 0) {
                        return (int)Math.signum(x - y);
                    }
                    return (int)Math.signum(relativeDifference);
                });
            }
            if (i >= sortedCommonSampleRates.size()) break;
            selectedSampleRate = (Integer)sortedCommonSampleRates.get(i++);
        }
        Logger.d((String)TAG, (String)"No sample rate found in target range or supported by audio source. Falling back to default sample rate of 44100Hz");
        return 44100;
    }

    static int scaleAndClampBitrate(int baseBitrate, int actualChannelCount, int baseChannelCount, int actualSampleRate, int baseSampleRate, Range<Integer> clampedRange) {
        Rational channelCountRatio = new Rational(actualChannelCount, baseChannelCount);
        Rational sampleRateRatio = new Rational(actualSampleRate, baseSampleRate);
        int resolvedBitrate = (int)((double)baseBitrate * channelCountRatio.doubleValue() * sampleRateRatio.doubleValue());
        String debugString = "";
        if (Logger.isDebugEnabled((String)TAG)) {
            debugString = String.format("Base Bitrate(%dbps) * Channel Count Ratio(%d / %d) * Sample Rate Ratio(%d / %d) = %d", baseBitrate, actualChannelCount, baseChannelCount, actualSampleRate, baseSampleRate, resolvedBitrate);
        }
        if (!AudioSpec.BITRATE_RANGE_AUTO.equals(clampedRange)) {
            resolvedBitrate = (Integer)clampedRange.clamp((Comparable)Integer.valueOf(resolvedBitrate));
            if (Logger.isDebugEnabled((String)TAG)) {
                debugString = debugString + String.format("\nClamped to range %s -> %dbps", clampedRange, resolvedBitrate);
            }
        }
        Logger.d((String)TAG, (String)debugString);
        return resolvedBitrate;
    }
}

