/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.CloseGuardHelper;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.PendingRecording;
import androidx.camera.video.Recorder;
import androidx.core.util.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public final class Recording
implements AutoCloseable {
    private final AtomicBoolean mIsStopped = new AtomicBoolean(false);
    private final Recorder mRecorder;
    private final long mRecordingId;
    private final OutputOptions mOutputOptions;
    private final CloseGuardHelper mCloseGuard = CloseGuardHelper.create();

    Recording(@NonNull Recorder recorder, long recordingId, @NonNull OutputOptions options, boolean finalizedOnCreation) {
        this.mRecorder = recorder;
        this.mRecordingId = recordingId;
        this.mOutputOptions = options;
        if (finalizedOnCreation) {
            this.mIsStopped.set(true);
        } else {
            this.mCloseGuard.open("stop");
        }
    }

    @NonNull
    static Recording from(@NonNull PendingRecording pendingRecording, long recordingId) {
        Preconditions.checkNotNull((Object)pendingRecording, (Object)"The given PendingRecording cannot be null.");
        return new Recording(pendingRecording.getRecorder(), recordingId, pendingRecording.getOutputOptions(), false);
    }

    @NonNull
    static Recording createFinalizedFrom(@NonNull PendingRecording pendingRecording, long recordingId) {
        Preconditions.checkNotNull((Object)pendingRecording, (Object)"The given PendingRecording cannot be null.");
        return new Recording(pendingRecording.getRecorder(), recordingId, pendingRecording.getOutputOptions(), true);
    }

    @NonNull
    OutputOptions getOutputOptions() {
        return this.mOutputOptions;
    }

    public void pause() {
        if (this.mIsStopped.get()) {
            throw new IllegalStateException("The recording has been stopped.");
        }
        this.mRecorder.pause(this);
    }

    public void resume() {
        if (this.mIsStopped.get()) {
            throw new IllegalStateException("The recording has been stopped.");
        }
        this.mRecorder.resume(this);
    }

    public void stop() {
        this.mCloseGuard.close();
        if (this.mIsStopped.getAndSet(true)) {
            return;
        }
        this.mRecorder.stop(this);
    }

    @Override
    public void close() {
        this.stop();
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    long getRecordingId() {
        return this.mRecordingId;
    }
}

