/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.video.AutoValue_FileOutputOptions_FileOutputOptionsInternal;
import androidx.camera.video.OutputOptions;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.io.File;

@RequiresApi(value=21)
public final class FileOutputOptions
extends OutputOptions {
    private final FileOutputOptionsInternal mFileOutputOptionsInternal;

    FileOutputOptions(@NonNull FileOutputOptionsInternal fileOutputOptionsInternal) {
        Preconditions.checkNotNull((Object)fileOutputOptionsInternal, (Object)"FileOutputOptionsInternal can't be null.");
        this.mFileOutputOptionsInternal = fileOutputOptionsInternal;
    }

    @NonNull
    public File getFile() {
        return this.mFileOutputOptionsInternal.getFile();
    }

    @Override
    public long getFileSizeLimit() {
        return this.mFileOutputOptionsInternal.getFileSizeLimit();
    }

    @NonNull
    public String toString() {
        return this.mFileOutputOptionsInternal.toString().replaceFirst("FileOutputOptionsInternal", "FileOutputOptions");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileOutputOptions)) {
            return false;
        }
        return this.mFileOutputOptionsInternal.equals(((FileOutputOptions)o).mFileOutputOptionsInternal);
    }

    public int hashCode() {
        return this.mFileOutputOptionsInternal.hashCode();
    }

    @AutoValue
    static abstract class FileOutputOptionsInternal {
        FileOutputOptionsInternal() {
        }

        @NonNull
        abstract File getFile();

        abstract long getFileSizeLimit();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            @NonNull
            abstract Builder setFile(@NonNull File var1);

            @NonNull
            abstract Builder setFileSizeLimit(long var1);

            @NonNull
            abstract FileOutputOptionsInternal build();
        }
    }

    @RequiresApi(value=21)
    public static final class Builder
    implements OutputOptions.Builder<FileOutputOptions, Builder> {
        private final FileOutputOptionsInternal.Builder mInternalBuilder = new AutoValue_FileOutputOptions_FileOutputOptionsInternal.Builder().setFileSizeLimit(0L);

        public Builder(@NonNull File file) {
            Preconditions.checkNotNull((Object)file, (Object)"File can't be null.");
            this.mInternalBuilder.setFile(file);
        }

        @Override
        @NonNull
        public Builder setFileSizeLimit(long fileSizeLimitBytes) {
            this.mInternalBuilder.setFileSizeLimit(fileSizeLimitBytes);
            return this;
        }

        @Override
        @NonNull
        public FileOutputOptions build() {
            return new FileOutputOptions(this.mInternalBuilder.build());
        }
    }
}

