/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.lifecycle.AutoValue_LifecycleCameraRepository_Key;
import androidx.camera.lifecycle.LifecycleCamera;
import androidx.core.util.Preconditions;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.google.auto.value.AutoValue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
final class LifecycleCameraRepository {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final Map<Key, LifecycleCamera> mCameraMap = new HashMap<Key, LifecycleCamera>();
    @GuardedBy(value="mLock")
    private final Map<LifecycleCameraRepositoryObserver, Set<Key>> mLifecycleObserverMap = new HashMap<LifecycleCameraRepositoryObserver, Set<Key>>();
    @GuardedBy(value="mLock")
    private final ArrayDeque<LifecycleOwner> mActiveLifecycleOwners = new ArrayDeque();

    LifecycleCameraRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LifecycleCamera createLifecycleCamera(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraUseCaseAdapter cameraUseCaseAdaptor) {
        LifecycleCamera lifecycleCamera;
        Object object = this.mLock;
        synchronized (object) {
            Key key = Key.create(lifecycleOwner, cameraUseCaseAdaptor.getCameraId());
            Preconditions.checkArgument((this.mCameraMap.get(key) == null ? 1 : 0) != 0, (Object)"LifecycleCamera already exists for the given LifecycleOwner and set of cameras");
            if (lifecycleOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                throw new IllegalArgumentException("Trying to create LifecycleCamera with destroyed lifecycle.");
            }
            lifecycleCamera = new LifecycleCamera(lifecycleOwner, cameraUseCaseAdaptor);
            if (cameraUseCaseAdaptor.getUseCases().isEmpty()) {
                lifecycleCamera.suspend();
            }
            this.registerCamera(lifecycleCamera);
        }
        return lifecycleCamera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    LifecycleCamera getLifecycleCamera(LifecycleOwner lifecycleOwner, CameraUseCaseAdapter.CameraId cameraId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraMap.get(Key.create(lifecycleOwner, cameraId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<LifecycleCamera> getLifecycleCameras() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.mCameraMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.mLock;
        synchronized (object) {
            HashSet<LifecycleCameraRepositoryObserver> keySet = new HashSet<LifecycleCameraRepositoryObserver>(this.mLifecycleObserverMap.keySet());
            for (LifecycleCameraRepositoryObserver observer : keySet) {
                this.unregisterLifecycle(observer.getLifecycleOwner());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCamera(LifecycleCamera lifecycleCamera) {
        Object object = this.mLock;
        synchronized (object) {
            LifecycleOwner lifecycleOwner = lifecycleCamera.getLifecycleOwner();
            Key key = Key.create(lifecycleOwner, lifecycleCamera.getCameraUseCaseAdapter().getCameraId());
            LifecycleCameraRepositoryObserver observer = this.getLifecycleCameraRepositoryObserver(lifecycleOwner);
            Set<Key> lifecycleCameraKeySet = observer != null ? this.mLifecycleObserverMap.get(observer) : new HashSet<Key>();
            lifecycleCameraKeySet.add(key);
            this.mCameraMap.put(key, lifecycleCamera);
            if (observer == null) {
                observer = new LifecycleCameraRepositoryObserver(lifecycleOwner, this);
                this.mLifecycleObserverMap.put(observer, lifecycleCameraKeySet);
                lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterLifecycle(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            LifecycleCameraRepositoryObserver observer = this.getLifecycleCameraRepositoryObserver(lifecycleOwner);
            if (observer == null) {
                return;
            }
            this.setInactive(lifecycleOwner);
            for (Key key : this.mLifecycleObserverMap.get(observer)) {
                this.mCameraMap.remove(key);
            }
            this.mLifecycleObserverMap.remove(observer);
            observer.getLifecycleOwner().getLifecycle().removeObserver((LifecycleObserver)observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleCameraRepositoryObserver getLifecycleCameraRepositoryObserver(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            for (LifecycleCameraRepositoryObserver observer : this.mLifecycleObserverMap.keySet()) {
                if (!lifecycleOwner.equals(observer.getLifecycleOwner())) continue;
                return observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindToLifecycleCamera(@NonNull LifecycleCamera lifecycleCamera, @Nullable ViewPort viewPort, @NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkArgument((!useCases.isEmpty() ? 1 : 0) != 0);
            LifecycleOwner lifecycleOwner = lifecycleCamera.getLifecycleOwner();
            LifecycleCameraRepositoryObserver observer = this.getLifecycleCameraRepositoryObserver(lifecycleOwner);
            Set<Key> lifecycleCameraKeySet = this.mLifecycleObserverMap.get(observer);
            for (Key key : lifecycleCameraKeySet) {
                LifecycleCamera camera = (LifecycleCamera)Preconditions.checkNotNull((Object)this.mCameraMap.get(key));
                if (camera.equals(lifecycleCamera) || camera.getUseCases().isEmpty()) continue;
                throw new IllegalArgumentException("Multiple LifecycleCameras with use cases are registered to the same LifecycleOwner.");
            }
            try {
                lifecycleCamera.getCameraUseCaseAdapter().setViewPort(viewPort);
                lifecycleCamera.bind(useCases);
            }
            catch (CameraUseCaseAdapter.CameraException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (lifecycleOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                this.setActive(lifecycleOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbind(@NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            for (Key key : this.mCameraMap.keySet()) {
                LifecycleCamera lifecycleCamera = this.mCameraMap.get(key);
                boolean hasUseCase = !lifecycleCamera.getUseCases().isEmpty();
                lifecycleCamera.unbind(useCases);
                if (!hasUseCase || !lifecycleCamera.getUseCases().isEmpty()) continue;
                this.setInactive(lifecycleCamera.getLifecycleOwner());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindAll() {
        Object object = this.mLock;
        synchronized (object) {
            for (Key key : this.mCameraMap.keySet()) {
                LifecycleCamera lifecycleCamera = this.mCameraMap.get(key);
                lifecycleCamera.unbindAll();
                this.setInactive(lifecycleCamera.getLifecycleOwner());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActive(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.hasUseCaseBound(lifecycleOwner)) {
                return;
            }
            if (this.mActiveLifecycleOwners.isEmpty()) {
                this.mActiveLifecycleOwners.push(lifecycleOwner);
            } else {
                LifecycleOwner currentActiveLifecycleOwner = this.mActiveLifecycleOwners.peek();
                if (!lifecycleOwner.equals(currentActiveLifecycleOwner)) {
                    this.suspendUseCases(currentActiveLifecycleOwner);
                    this.mActiveLifecycleOwners.remove(lifecycleOwner);
                    this.mActiveLifecycleOwners.push(lifecycleOwner);
                }
            }
            this.unsuspendUseCases(lifecycleOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInactive(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActiveLifecycleOwners.remove(lifecycleOwner);
            this.suspendUseCases(lifecycleOwner);
            if (!this.mActiveLifecycleOwners.isEmpty()) {
                LifecycleOwner newActiveLifecycleOwner = this.mActiveLifecycleOwners.peek();
                this.unsuspendUseCases(newActiveLifecycleOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUseCaseBound(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            LifecycleCameraRepositoryObserver observer = this.getLifecycleCameraRepositoryObserver(lifecycleOwner);
            if (observer == null) {
                return false;
            }
            Set<Key> lifecycleCameraKeySet = this.mLifecycleObserverMap.get(observer);
            for (Key key : lifecycleCameraKeySet) {
                if (((LifecycleCamera)Preconditions.checkNotNull((Object)this.mCameraMap.get(key))).getUseCases().isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendUseCases(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            LifecycleCameraRepositoryObserver observer = this.getLifecycleCameraRepositoryObserver(lifecycleOwner);
            if (observer == null) {
                return;
            }
            for (Key key : this.mLifecycleObserverMap.get(observer)) {
                ((LifecycleCamera)Preconditions.checkNotNull((Object)this.mCameraMap.get(key))).suspend();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsuspendUseCases(LifecycleOwner lifecycleOwner) {
        Object object = this.mLock;
        synchronized (object) {
            LifecycleCameraRepositoryObserver observer = this.getLifecycleCameraRepositoryObserver(lifecycleOwner);
            for (Key key : this.mLifecycleObserverMap.get(observer)) {
                LifecycleCamera lifecycleCamera = this.mCameraMap.get(key);
                if (((LifecycleCamera)Preconditions.checkNotNull((Object)lifecycleCamera)).getUseCases().isEmpty()) continue;
                lifecycleCamera.unsuspend();
            }
        }
    }

    private static class LifecycleCameraRepositoryObserver
    implements LifecycleObserver {
        private final LifecycleCameraRepository mLifecycleCameraRepository;
        private final LifecycleOwner mLifecycleOwner;

        LifecycleCameraRepositoryObserver(LifecycleOwner lifecycleOwner, LifecycleCameraRepository lifecycleCameraRepository) {
            this.mLifecycleOwner = lifecycleOwner;
            this.mLifecycleCameraRepository = lifecycleCameraRepository;
        }

        LifecycleOwner getLifecycleOwner() {
            return this.mLifecycleOwner;
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        public void onStart(LifecycleOwner lifecycleOwner) {
            this.mLifecycleCameraRepository.setActive(lifecycleOwner);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
        public void onStop(LifecycleOwner lifecycleOwner) {
            this.mLifecycleCameraRepository.setInactive(lifecycleOwner);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public void onDestroy(LifecycleOwner lifecycleOwner) {
            this.mLifecycleCameraRepository.unregisterLifecycle(lifecycleOwner);
        }
    }

    @AutoValue
    static abstract class Key {
        Key() {
        }

        static Key create(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraUseCaseAdapter.CameraId cameraId) {
            return new AutoValue_LifecycleCameraRepository_Key(lifecycleOwner, cameraId);
        }

        @NonNull
        public abstract LifecycleOwner getLifecycleOwner();

        @NonNull
        public abstract CameraUseCaseAdapter.CameraId getCameraId();
    }
}

