/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.internal.AdaptingCaptureProcessor;
import androidx.camera.extensions.internal.AdaptingCaptureStage;
import androidx.camera.extensions.internal.BasicVendorExtender;
import androidx.camera.extensions.internal.VendorExtender;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public class ImageCaptureConfigProvider
implements ConfigProvider<ImageCaptureConfig> {
    private static final String TAG = "ImageCaptureConfigProvider";
    static final Config.Option<Integer> OPTION_IMAGE_CAPTURE_CONFIG_PROVIDER_MODE = Config.Option.create((String)"camerax.extensions.imageCaptureConfigProvider.mode", Integer.class);
    private final VendorExtender mVendorExtender;
    private final Context mContext;
    private final int mEffectMode;

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public ImageCaptureConfigProvider(int mode, @NonNull VendorExtender vendorExtender, @NonNull Context context) {
        this.mEffectMode = mode;
        this.mVendorExtender = vendorExtender;
        this.mContext = context;
    }

    @NonNull
    public ImageCaptureConfig getConfig() {
        ImageCapture.Builder builder = new ImageCapture.Builder();
        this.updateBuilderConfig(builder, this.mEffectMode, this.mVendorExtender, this.mContext);
        return builder.getUseCaseConfig();
    }

    void updateBuilderConfig(@NonNull ImageCapture.Builder builder, int effectMode, @NonNull VendorExtender vendorExtender, @NonNull Context context) {
        if (vendorExtender instanceof BasicVendorExtender) {
            ImageCaptureExtenderImpl imageCaptureExtenderImpl = ((BasicVendorExtender)vendorExtender).getImageCaptureExtenderImpl();
            if (imageCaptureExtenderImpl != null) {
                CaptureProcessorImpl captureProcessor = imageCaptureExtenderImpl.getCaptureProcessor();
                if (captureProcessor != null) {
                    builder.setCaptureProcessor((CaptureProcessor)new AdaptingCaptureProcessor(captureProcessor));
                }
                if (imageCaptureExtenderImpl.getMaxCaptureStage() > 0) {
                    builder.setMaxCaptureStages(imageCaptureExtenderImpl.getMaxCaptureStage());
                }
                ImageCaptureEventAdapter imageCaptureEventAdapter = new ImageCaptureEventAdapter(imageCaptureExtenderImpl, context);
                new Camera2ImplConfig.Extender((ExtendableBuilder)builder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{imageCaptureEventAdapter}));
                builder.setUseCaseEventCallback((UseCase.EventCallback)imageCaptureEventAdapter);
                builder.setCaptureBundle((CaptureBundle)imageCaptureEventAdapter);
            } else {
                Logger.e((String)TAG, (String)"ImageCaptureExtenderImpl is null!");
            }
        }
        builder.getMutableConfig().insertOption(OPTION_IMAGE_CAPTURE_CONFIG_PROVIDER_MODE, (Object)effectMode);
        List<Pair<Integer, Size[]>> supportedResolutions = vendorExtender.getSupportedCaptureOutputResolutions();
        builder.setSupportedResolutions(supportedResolutions);
    }

    private static class ImageCaptureEventAdapter
    extends CameraEventCallback
    implements UseCase.EventCallback,
    CaptureBundle {
        @NonNull
        private final ImageCaptureExtenderImpl mImpl;
        @NonNull
        private final Context mContext;
        private final AtomicBoolean mActive = new AtomicBoolean(true);
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private volatile int mEnabledSessionCount = 0;
        @GuardedBy(value="mLock")
        private volatile boolean mUnbind = false;

        ImageCaptureEventAdapter(@NonNull ImageCaptureExtenderImpl impl, @NonNull Context context) {
            this.mImpl = impl;
            this.mContext = context;
        }

        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        public void onAttach(@NonNull CameraInfo cameraInfo) {
            if (this.mActive.get()) {
                String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
                CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
                this.mImpl.onInit(cameraId, cameraCharacteristics, this.mContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDetach() {
            Object object = this.mLock;
            synchronized (object) {
                this.mUnbind = true;
                if (this.mEnabledSessionCount == 0) {
                    this.callDeInit();
                }
            }
        }

        private void callDeInit() {
            if (this.mActive.get()) {
                this.mImpl.onDeInit();
                this.mActive.set(false);
            }
        }

        @Nullable
        public CaptureConfig onPresetSession() {
            CaptureStageImpl captureStageImpl;
            if (this.mActive.get() && (captureStageImpl = this.mImpl.onPresetSession()) != null) {
                if (Build.VERSION.SDK_INT >= 28) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
                Logger.w((String)ImageCaptureConfigProvider.TAG, (String)"The CaptureRequest parameters returned from onPresetSession() will be passed to the camera device as part of the capture session via SessionConfiguration#setSessionParameters(CaptureRequest) which only supported from API level 28!");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onEnableSession() {
            try {
                CaptureStageImpl captureStageImpl;
                if (this.mActive.get() && (captureStageImpl = this.mImpl.onEnableSession()) != null) {
                    CaptureConfig captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    return captureConfig;
                }
                CaptureConfig captureConfig = null;
                return captureConfig;
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    ++this.mEnabledSessionCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onDisableSession() {
            try {
                CaptureStageImpl captureStageImpl;
                if (this.mActive.get() && (captureStageImpl = this.mImpl.onDisableSession()) != null) {
                    CaptureConfig captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    return captureConfig;
                }
                CaptureConfig captureConfig = null;
                return captureConfig;
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    --this.mEnabledSessionCount;
                    if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                        this.callDeInit();
                    }
                }
            }
        }

        @Nullable
        public List<CaptureStage> getCaptureStages() {
            List captureStages;
            if (this.mActive.get() && (captureStages = this.mImpl.getCaptureStages()) != null && !captureStages.isEmpty()) {
                ArrayList<CaptureStage> ret = new ArrayList<CaptureStage>();
                for (CaptureStageImpl s : captureStages) {
                    ret.add(new AdaptingCaptureStage(s));
                }
                return ret;
            }
            return null;
        }
    }
}

