/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.extensions.internal.ImageCaptureConfigProvider;
import androidx.camera.extensions.internal.PreviewConfigProvider;
import androidx.camera.extensions.internal.VendorExtender;

@RequiresApi(value=21)
public final class ExtensionsUseCaseConfigFactory
implements UseCaseConfigFactory {
    private final ImageCaptureConfigProvider mImageCaptureConfigProvider;
    private final PreviewConfigProvider mPreviewConfigProvider;

    public ExtensionsUseCaseConfigFactory(int mode, @NonNull VendorExtender vendorExtender, @NonNull Context context) {
        this.mImageCaptureConfigProvider = new ImageCaptureConfigProvider(mode, vendorExtender, context);
        this.mPreviewConfigProvider = new PreviewConfigProvider(mode, vendorExtender, context);
    }

    @Nullable
    public Config getConfig(@NonNull UseCaseConfigFactory.CaptureType captureType, int captureMode) {
        MutableOptionsBundle mutableOptionsBundle;
        switch (captureType) {
            case IMAGE_CAPTURE: {
                mutableOptionsBundle = MutableOptionsBundle.from((Config)this.mImageCaptureConfigProvider.getConfig());
                break;
            }
            case PREVIEW: {
                mutableOptionsBundle = MutableOptionsBundle.from((Config)this.mPreviewConfigProvider.getConfig());
                break;
            }
            case VIDEO_CAPTURE: {
                throw new IllegalArgumentException("CameraX Extensions doesn't support VideoCapture!");
            }
            default: {
                return null;
            }
        }
        return OptionsBundle.from((Config)mutableOptionsBundle);
    }
}

