/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import androidx.annotation.GuardedBy;
import androidx.annotation.RequiresApi;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@RequiresApi(value=21)
final class BlockingCloseAccessCounter {
    @GuardedBy(value="mLock")
    private AtomicInteger mAccessCount = new AtomicInteger(0);
    private final Lock mLock = new ReentrantLock();
    private final Condition mDoneCondition = this.mLock.newCondition();
    private static final int COUNTER_DESTROYED_FLAG = -1;

    BlockingCloseAccessCounter() {
    }

    boolean tryIncrement() {
        this.mLock.lock();
        try {
            if (this.mAccessCount.get() == -1) {
                boolean bl = false;
                return bl;
            }
            this.mAccessCount.getAndIncrement();
        }
        finally {
            this.mLock.unlock();
        }
        return true;
    }

    void decrement() {
        this.mLock.lock();
        try {
            switch (this.mAccessCount.getAndDecrement()) {
                case -1: {
                    throw new IllegalStateException("Unable to decrement. Counter already destroyed");
                }
                case 0: {
                    throw new IllegalStateException("Unable to decrement. No corresponding counter increment");
                }
            }
            this.mDoneCondition.signal();
        }
        finally {
            this.mLock.unlock();
        }
    }

    void destroyAndWaitForZeroAccess() {
        this.mLock.lock();
        try {
            while (!this.mAccessCount.compareAndSet(0, -1)) {
                try {
                    this.mDoneCondition.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.mLock.unlock();
        }
    }
}

