/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.impl.AutoImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.AutoPreviewExtenderImpl;
import androidx.camera.extensions.impl.BeautyImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.BokehImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BokehPreviewExtenderImpl;
import androidx.camera.extensions.impl.HdrImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.HdrPreviewExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.VendorExtender;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.compat.workaround.ExtensionDisabledValidator;
import androidx.core.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
public class BasicVendorExtender
implements VendorExtender {
    private static final String TAG = "BasicVendorExtender";
    private final ExtensionDisabledValidator mExtensionDisabledValidator = new ExtensionDisabledValidator();
    private final int mMode;
    private PreviewExtenderImpl mPreviewExtenderImpl = null;
    private ImageCaptureExtenderImpl mImageCaptureExtenderImpl = null;
    private CameraInfo mCameraInfo;

    public BasicVendorExtender(int mode) {
        this.mMode = mode;
        try {
            switch (mode) {
                case 1: {
                    this.mPreviewExtenderImpl = new BokehPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new BokehImageCaptureExtenderImpl();
                    break;
                }
                case 2: {
                    this.mPreviewExtenderImpl = new HdrPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new HdrImageCaptureExtenderImpl();
                    break;
                }
                case 3: {
                    this.mPreviewExtenderImpl = new NightPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new NightImageCaptureExtenderImpl();
                    break;
                }
                case 4: {
                    this.mPreviewExtenderImpl = new BeautyPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new BeautyImageCaptureExtenderImpl();
                    break;
                }
                case 5: {
                    this.mPreviewExtenderImpl = new AutoPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new AutoImageCaptureExtenderImpl();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Should not activate ExtensionMode.NONE");
                }
            }
        }
        catch (NoClassDefFoundError e) {
            Logger.e((String)TAG, (String)("OEM implementation for extension mode " + mode + "does not exist!"));
        }
    }

    @Nullable
    public PreviewExtenderImpl getPreviewExtenderImpl() {
        return this.mPreviewExtenderImpl;
    }

    @Nullable
    public ImageCaptureExtenderImpl getImageCaptureExtenderImpl() {
        return this.mImageCaptureExtenderImpl;
    }

    @Override
    public boolean isExtensionAvailable(@NonNull String cameraId, @NonNull Map<String, CameraCharacteristics> characteristicsMap) {
        if (this.mExtensionDisabledValidator.shouldDisableExtension(cameraId, this.mMode)) {
            return false;
        }
        if (this.mPreviewExtenderImpl == null || this.mImageCaptureExtenderImpl == null) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = characteristicsMap.get(cameraId);
        return this.mPreviewExtenderImpl.isExtensionAvailable(cameraId, cameraCharacteristics) && this.mImageCaptureExtenderImpl.isExtensionAvailable(cameraId, cameraCharacteristics);
    }

    @Override
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void init(@NonNull CameraInfo cameraInfo) {
        this.mCameraInfo = cameraInfo;
        if (this.mPreviewExtenderImpl == null || this.mImageCaptureExtenderImpl == null) {
            return;
        }
        String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
        CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
        this.mPreviewExtenderImpl.init(cameraId, cameraCharacteristics);
        this.mImageCaptureExtenderImpl.init(cameraId, cameraCharacteristics);
        Logger.d((String)TAG, (String)("Extension init Mode = " + this.mMode));
        Logger.d((String)TAG, (String)("PreviewExtender processorType= " + this.mPreviewExtenderImpl.getProcessorType()));
        Logger.d((String)TAG, (String)("ImageCaptureExtender processor= " + this.mImageCaptureExtenderImpl.getCaptureProcessor()));
    }

    @Override
    @Nullable
    public Range<Long> getEstimatedCaptureLatencyRange(@Nullable Size size) {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        if (this.mImageCaptureExtenderImpl != null && ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) >= 0) {
            try {
                return this.mImageCaptureExtenderImpl.getEstimatedCaptureLatencyRange(size);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return null;
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private Size[] getOutputSizes(int imageFormat) {
        StreamConfigurationMap map = (StreamConfigurationMap)Camera2CameraInfo.from((CameraInfo)this.mCameraInfo).getCameraCharacteristic(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        return map.getOutputSizes(imageFormat);
    }

    private int getPreviewOutputImageFormat() {
        return 34;
    }

    private int getCaptureOutputImageFormat() {
        if (this.mImageCaptureExtenderImpl != null && this.mImageCaptureExtenderImpl.getCaptureProcessor() != null) {
            return 35;
        }
        return 256;
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedPreviewOutputResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        if (this.mPreviewExtenderImpl != null && ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) >= 0) {
            try {
                List result = this.mPreviewExtenderImpl.getSupportedResolutions();
                if (result != null) {
                    return result;
                }
            }
            catch (NoSuchMethodError result) {
                // empty catch block
            }
        }
        int imageformat = this.getPreviewOutputImageFormat();
        return Arrays.asList(new Pair((Object)imageformat, (Object)this.getOutputSizes(imageformat)));
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedCaptureOutputResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        if (this.mImageCaptureExtenderImpl != null && ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) >= 0) {
            try {
                List result = this.mImageCaptureExtenderImpl.getSupportedResolutions();
                if (result != null) {
                    return result;
                }
            }
            catch (NoSuchMethodError result) {
                // empty catch block
            }
        }
        int imageFormat = this.getCaptureOutputImageFormat();
        return Arrays.asList(new Pair((Object)imageFormat, (Object)this.getOutputSizes(imageFormat)));
    }

    @Override
    @NonNull
    public Size[] getSupportedYuvAnalysisResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        return this.getOutputSizes(35);
    }

    @Override
    @Nullable
    public SessionProcessor createSessionProcessor(@NonNull Context context) {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        return null;
    }
}

