/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing.concurrent;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.Matrix;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.LayoutSettings;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.processing.OpenGlRenderer;
import androidx.camera.core.processing.ShaderProvider;
import androidx.camera.core.processing.util.GLUtils;
import androidx.camera.core.processing.util.GraphicDeviceInfo;
import androidx.camera.core.processing.util.OutputSurface;
import androidx.core.util.Preconditions;
import java.util.Map;

@WorkerThread
public final class DualOpenGlRenderer
extends OpenGlRenderer {
    private static final String TAG = "DualOpenGlRenderer";
    private int mPrimaryExternalTextureId = -1;
    private int mSecondaryExternalTextureId = -1;
    @NonNull
    private final LayoutSettings mPrimaryLayoutSettings;
    @NonNull
    private final LayoutSettings mSecondaryLayoutSettings;

    public DualOpenGlRenderer(@NonNull LayoutSettings primaryLayoutSettings, @NonNull LayoutSettings secondaryLayoutSettings) {
        this.mPrimaryLayoutSettings = primaryLayoutSettings;
        this.mSecondaryLayoutSettings = secondaryLayoutSettings;
    }

    @Override
    @NonNull
    public GraphicDeviceInfo init(@NonNull DynamicRange dynamicRange, @NonNull Map<GLUtils.InputFormat, ShaderProvider> shaderProviderOverrides) {
        GraphicDeviceInfo graphicDeviceInfo = super.init(dynamicRange, shaderProviderOverrides);
        this.mPrimaryExternalTextureId = GLUtils.createTexture();
        this.mSecondaryExternalTextureId = GLUtils.createTexture();
        return graphicDeviceInfo;
    }

    @Override
    public void release() {
        super.release();
        this.mPrimaryExternalTextureId = -1;
        this.mSecondaryExternalTextureId = -1;
    }

    public int getTextureName(boolean isPrimary) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        return isPrimary ? this.mPrimaryExternalTextureId : this.mSecondaryExternalTextureId;
    }

    public void render(long timestampNs, @NonNull Surface surface, @NonNull SurfaceOutput surfaceOutput, @NonNull SurfaceTexture primarySurfaceTexture, @NonNull SurfaceTexture secondarySurfaceTexture) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        OutputSurface outputSurface = this.getOutSurfaceOrThrow(surface);
        if (outputSurface == GLUtils.NO_OUTPUT_SURFACE) {
            outputSurface = this.createOutputSurfaceInternal(surface);
            if (outputSurface == null) {
                return;
            }
            this.mOutputSurfaceMap.put(surface, outputSurface);
        }
        if (surface != this.mCurrentSurface) {
            this.makeCurrent(outputSurface.getEglSurface());
            this.mCurrentSurface = surface;
        }
        GLES30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES30.glClear((int)16384);
        this.renderInternal(outputSurface, surfaceOutput, primarySurfaceTexture, this.mPrimaryLayoutSettings, this.mPrimaryExternalTextureId, true);
        this.renderInternal(outputSurface, surfaceOutput, secondarySurfaceTexture, this.mSecondaryLayoutSettings, this.mSecondaryExternalTextureId, true);
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)outputSurface.getEglSurface(), (long)timestampNs);
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)outputSurface.getEglSurface())) {
            Logger.w(TAG, "Failed to swap buffers with EGL error: 0x" + Integer.toHexString(EGL14.eglGetError()));
            this.removeOutputSurfaceInternal(surface, false);
        }
    }

    private void renderInternal(@NonNull OutputSurface outputSurface, @NonNull SurfaceOutput surfaceOutput, @NonNull SurfaceTexture surfaceTexture, @NonNull LayoutSettings layoutSettings, int externalTextureId, boolean isPrimary) {
        this.useAndConfigureProgramWithTexture(externalTextureId);
        GLES20.glViewport((int)0, (int)0, (int)outputSurface.getWidth(), (int)outputSurface.getHeight());
        GLES20.glScissor((int)0, (int)0, (int)outputSurface.getWidth(), (int)outputSurface.getHeight());
        float[] textureTransform = new float[16];
        surfaceTexture.getTransformMatrix(textureTransform);
        float[] surfaceOutputMatrix = new float[16];
        surfaceOutput.updateTransformMatrix(surfaceOutputMatrix, textureTransform, isPrimary);
        GLUtils.Program2D currentProgram = (GLUtils.Program2D)Preconditions.checkNotNull((Object)this.mCurrentProgram);
        if (currentProgram instanceof GLUtils.SamplerShaderProgram) {
            ((GLUtils.SamplerShaderProgram)currentProgram).updateTextureMatrix(surfaceOutputMatrix);
        }
        float[] transTransform = DualOpenGlRenderer.getTransformMatrix(new Size((int)((float)outputSurface.getWidth() * layoutSettings.getWidth()), (int)((float)outputSurface.getHeight() * layoutSettings.getHeight())), new Size(outputSurface.getWidth(), outputSurface.getHeight()), layoutSettings);
        currentProgram.updateTransformMatrix(transTransform);
        currentProgram.updateAlpha(layoutSettings.getAlpha());
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLUtils.checkGlErrorOrThrow("glDrawArrays");
        GLES20.glDisable((int)3042);
    }

    @NonNull
    private static float[] getTransformMatrix(@NonNull Size overlaySize, @NonNull Size backgroundSize, @NonNull LayoutSettings layoutSettings) {
        float[] aspectRatioMatrix = GLUtils.create4x4IdentityMatrix();
        float[] overlayFrameAnchorMatrix = GLUtils.create4x4IdentityMatrix();
        float[] transformationMatrix = GLUtils.create4x4IdentityMatrix();
        Matrix.scaleM((float[])aspectRatioMatrix, (int)0, (float)((float)overlaySize.getWidth() / (float)backgroundSize.getWidth()), (float)((float)overlaySize.getHeight() / (float)backgroundSize.getHeight()), (float)1.0f);
        Matrix.translateM((float[])overlayFrameAnchorMatrix, (int)0, (float)(layoutSettings.getOffsetX() / layoutSettings.getWidth()), (float)(layoutSettings.getOffsetY() / layoutSettings.getHeight()), (float)0.0f);
        Matrix.multiplyMM((float[])transformationMatrix, (int)0, (float[])aspectRatioMatrix, (int)0, (float[])overlayFrameAnchorMatrix, (int)0);
        return transformationMatrix;
    }
}

