/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ImageProcessingUtil;
import androidx.camera.core.Logger;
import androidx.camera.core.processing.ShaderProvider;
import androidx.camera.core.processing.util.GLUtils;
import androidx.camera.core.processing.util.GraphicDeviceInfo;
import androidx.camera.core.processing.util.OutputSurface;
import androidx.core.util.Pair;
import androidx.core.util.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

@WorkerThread
public class OpenGlRenderer {
    private static final String TAG = "OpenGlRenderer";
    protected final AtomicBoolean mInitialized = new AtomicBoolean(false);
    protected final Map<Surface, OutputSurface> mOutputSurfaceMap = new HashMap<Surface, OutputSurface>();
    @Nullable
    protected Thread mGlThread;
    @NonNull
    protected EGLDisplay mEglDisplay = EGL14.EGL_NO_DISPLAY;
    @NonNull
    protected EGLContext mEglContext = EGL14.EGL_NO_CONTEXT;
    @NonNull
    protected int[] mSurfaceAttrib = GLUtils.EMPTY_ATTRIBS;
    @Nullable
    protected EGLConfig mEglConfig;
    @NonNull
    protected EGLSurface mTempSurface = EGL14.EGL_NO_SURFACE;
    @Nullable
    protected Surface mCurrentSurface;
    @NonNull
    protected Map<GLUtils.InputFormat, GLUtils.Program2D> mProgramHandles = Collections.emptyMap();
    @Nullable
    protected GLUtils.Program2D mCurrentProgram = null;
    @NonNull
    protected GLUtils.InputFormat mCurrentInputformat = GLUtils.InputFormat.UNKNOWN;
    private int mExternalTextureId = -1;

    @NonNull
    public GraphicDeviceInfo init(@NonNull DynamicRange dynamicRange) {
        return this.init(dynamicRange, Collections.emptyMap());
    }

    @NonNull
    public GraphicDeviceInfo init(@NonNull DynamicRange dynamicRange, @NonNull Map<GLUtils.InputFormat, ShaderProvider> shaderOverrides) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, false);
        GraphicDeviceInfo.Builder infoBuilder = GraphicDeviceInfo.builder();
        try {
            if (dynamicRange.is10BitHdr()) {
                Pair<String, String> extensions = this.getExtensionsBeforeInitialized(dynamicRange);
                String glExtensions = (String)Preconditions.checkNotNull((Object)((String)extensions.first));
                String eglExtensions = (String)Preconditions.checkNotNull((Object)((String)extensions.second));
                if (!glExtensions.contains("GL_EXT_YUV_target")) {
                    Logger.w(TAG, "Device does not support GL_EXT_YUV_target. Fallback to SDR.");
                    dynamicRange = DynamicRange.SDR;
                }
                this.mSurfaceAttrib = GLUtils.chooseSurfaceAttrib(eglExtensions, dynamicRange);
                infoBuilder.setGlExtensions(glExtensions);
                infoBuilder.setEglExtensions(eglExtensions);
            }
            this.createEglContext(dynamicRange, infoBuilder);
            this.createTempSurface();
            this.makeCurrent(this.mTempSurface);
            infoBuilder.setGlVersion(GLUtils.getGlVersionNumber());
            this.mProgramHandles = GLUtils.createPrograms(dynamicRange, shaderOverrides);
            this.mExternalTextureId = GLUtils.createTexture();
            this.useAndConfigureProgramWithTexture(this.mExternalTextureId);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.releaseInternal();
            throw e;
        }
        this.mGlThread = Thread.currentThread();
        this.mInitialized.set(true);
        return infoBuilder.build();
    }

    public void release() {
        if (!this.mInitialized.getAndSet(false)) {
            return;
        }
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        this.releaseInternal();
    }

    public void registerOutputSurface(@NonNull Surface surface) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        if (!this.mOutputSurfaceMap.containsKey(surface)) {
            this.mOutputSurfaceMap.put(surface, GLUtils.NO_OUTPUT_SURFACE);
        }
    }

    public void unregisterOutputSurface(@NonNull Surface surface) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        this.removeOutputSurfaceInternal(surface, true);
    }

    public int getTextureName() {
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        return this.mExternalTextureId;
    }

    public void setInputFormat(@NonNull GLUtils.InputFormat inputFormat) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        if (this.mCurrentInputformat != inputFormat) {
            this.mCurrentInputformat = inputFormat;
            this.useAndConfigureProgramWithTexture(this.mExternalTextureId);
        }
    }

    private void activateExternalTexture(int externalTextureId) {
        GLES20.glActiveTexture((int)33984);
        GLUtils.checkGlErrorOrThrow("glActiveTexture");
        GLES20.glBindTexture((int)36197, (int)externalTextureId);
        GLUtils.checkGlErrorOrThrow("glBindTexture");
    }

    public void render(long timestampNs, @NonNull float[] textureTransform, @NonNull Surface surface) {
        GLUtils.Program2D program;
        GLUtils.checkInitializedOrThrow(this.mInitialized, true);
        GLUtils.checkGlThreadOrThrow(this.mGlThread);
        OutputSurface outputSurface = this.getOutSurfaceOrThrow(surface);
        if (outputSurface == GLUtils.NO_OUTPUT_SURFACE) {
            outputSurface = this.createOutputSurfaceInternal(surface);
            if (outputSurface == null) {
                return;
            }
            this.mOutputSurfaceMap.put(surface, outputSurface);
        }
        if (surface != this.mCurrentSurface) {
            this.makeCurrent(outputSurface.getEglSurface());
            this.mCurrentSurface = surface;
            GLES20.glViewport((int)0, (int)0, (int)outputSurface.getWidth(), (int)outputSurface.getHeight());
            GLES20.glScissor((int)0, (int)0, (int)outputSurface.getWidth(), (int)outputSurface.getHeight());
        }
        if ((program = (GLUtils.Program2D)Preconditions.checkNotNull((Object)this.mCurrentProgram)) instanceof GLUtils.SamplerShaderProgram) {
            ((GLUtils.SamplerShaderProgram)program).updateTextureMatrix(textureTransform);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLUtils.checkGlErrorOrThrow("glDrawArrays");
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)outputSurface.getEglSurface(), (long)timestampNs);
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)outputSurface.getEglSurface())) {
            Logger.w(TAG, "Failed to swap buffers with EGL error: 0x" + Integer.toHexString(EGL14.eglGetError()));
            this.removeOutputSurfaceInternal(surface, false);
        }
    }

    @NonNull
    public Bitmap snapshot(@NonNull Size size, @NonNull float[] textureTransform) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size.getWidth() * size.getHeight() * 4);
        this.snapshot(byteBuffer, size, textureTransform);
        Bitmap bitmap = Bitmap.createBitmap((int)size.getWidth(), (int)size.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        byteBuffer.rewind();
        ImageProcessingUtil.copyByteBufferToBitmap(bitmap, byteBuffer, size.getWidth() * 4);
        return bitmap;
    }

    private void snapshot(@NonNull ByteBuffer byteBuffer, @NonNull Size size, @NonNull float[] textureTransform) {
        Preconditions.checkArgument((byteBuffer.capacity() == size.getWidth() * size.getHeight() * 4 ? 1 : 0) != 0, (Object)"ByteBuffer capacity is not equal to width * height * 4.");
        Preconditions.checkArgument((boolean)byteBuffer.isDirect(), (Object)"ByteBuffer is not direct.");
        int texture = GLUtils.generateTexture();
        GLES20.glActiveTexture((int)33985);
        GLUtils.checkGlErrorOrThrow("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)texture);
        GLUtils.checkGlErrorOrThrow("glBindTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)6407, (int)size.getWidth(), (int)size.getHeight(), (int)0, (int)6407, (int)5121, null);
        GLUtils.checkGlErrorOrThrow("glTexImage2D");
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        int fbo = GLUtils.generateFbo();
        GLES20.glBindFramebuffer((int)36160, (int)fbo);
        GLUtils.checkGlErrorOrThrow("glBindFramebuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
        GLUtils.checkGlErrorOrThrow("glFramebufferTexture2D");
        GLES20.glActiveTexture((int)33984);
        GLUtils.checkGlErrorOrThrow("glActiveTexture");
        GLES20.glBindTexture((int)36197, (int)this.mExternalTextureId);
        GLUtils.checkGlErrorOrThrow("glBindTexture");
        this.mCurrentSurface = null;
        GLES20.glViewport((int)0, (int)0, (int)size.getWidth(), (int)size.getHeight());
        GLES20.glScissor((int)0, (int)0, (int)size.getWidth(), (int)size.getHeight());
        GLUtils.Program2D program = (GLUtils.Program2D)Preconditions.checkNotNull((Object)this.mCurrentProgram);
        if (program instanceof GLUtils.SamplerShaderProgram) {
            ((GLUtils.SamplerShaderProgram)program).updateTextureMatrix(textureTransform);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLUtils.checkGlErrorOrThrow("glDrawArrays");
        GLES20.glReadPixels((int)0, (int)0, (int)size.getWidth(), (int)size.getHeight(), (int)6408, (int)5121, (Buffer)byteBuffer);
        GLUtils.checkGlErrorOrThrow("glReadPixels");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLUtils.deleteTexture(texture);
        GLUtils.deleteFbo(fbo);
        this.activateExternalTexture(this.mExternalTextureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Pair<String, String> getExtensionsBeforeInitialized(@NonNull DynamicRange dynamicRangeToInitialize) {
        GLUtils.checkInitializedOrThrow(this.mInitialized, false);
        try {
            this.createEglContext(dynamicRangeToInitialize, null);
            this.createTempSurface();
            this.makeCurrent(this.mTempSurface);
            String glExtensions = GLES20.glGetString((int)7939);
            String eglExtensions = EGL14.eglQueryString((EGLDisplay)this.mEglDisplay, (int)12373);
            Pair pair = new Pair((Object)(glExtensions != null ? glExtensions : ""), (Object)(eglExtensions != null ? eglExtensions : ""));
            return pair;
        }
        catch (IllegalStateException e) {
            Logger.w(TAG, "Failed to get GL or EGL extensions: " + e.getMessage(), e);
            Pair pair = new Pair((Object)"", (Object)"");
            return pair;
        }
        finally {
            this.releaseInternal();
        }
    }

    private void createEglContext(@NonNull DynamicRange dynamicRange, @Nullable GraphicDeviceInfo.Builder infoBuilder) {
        int[] numConfigs;
        EGLConfig[] configs;
        int recordableAndroid;
        int renderType;
        int alphaBits;
        int rgbBits;
        int[] attribToChooseConfig;
        this.mEglDisplay = EGL14.eglGetDisplay((int)0);
        if (Objects.equals(this.mEglDisplay, EGL14.EGL_NO_DISPLAY)) {
            throw new IllegalStateException("Unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
            throw new IllegalStateException("Unable to initialize EGL14");
        }
        if (infoBuilder != null) {
            infoBuilder.setEglVersion(version[0] + "." + version[1]);
        }
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])(attribToChooseConfig = new int[]{12324, rgbBits = dynamicRange.is10BitHdr() ? 10 : 8, 12323, rgbBits, 12322, rgbBits, 12321, alphaBits = dynamicRange.is10BitHdr() ? 2 : 8, 12325, 0, 12326, 0, 12352, renderType = dynamicRange.is10BitHdr() ? 64 : 4, 12610, recordableAndroid = dynamicRange.is10BitHdr() ? -1 : 1, 12339, 5, 12344}), (int)0, (EGLConfig[])(configs = new EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
            throw new IllegalStateException("Unable to find a suitable EGLConfig");
        }
        EGLConfig config = configs[0];
        int[] attribToCreateContext = new int[]{12440, dynamicRange.is10BitHdr() ? 3 : 2, 12344};
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)config, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attribToCreateContext, (int)0);
        GLUtils.checkEglErrorOrThrow("eglCreateContext");
        this.mEglConfig = config;
        this.mEglContext = context;
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mEglContext, (int)12440, (int[])values, (int)0);
        Log.d((String)TAG, (String)("EGLContext created, client version " + values[0]));
    }

    private void createTempSurface() {
        this.mTempSurface = GLUtils.createPBufferSurface(this.mEglDisplay, Objects.requireNonNull(this.mEglConfig), 1, 1);
    }

    protected void makeCurrent(@NonNull EGLSurface eglSurface) {
        Preconditions.checkNotNull((Object)this.mEglDisplay);
        Preconditions.checkNotNull((Object)this.mEglContext);
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)this.mEglContext)) {
            throw new IllegalStateException("eglMakeCurrent failed");
        }
    }

    protected void useAndConfigureProgramWithTexture(int textureId) {
        GLUtils.Program2D program = this.mProgramHandles.get((Object)this.mCurrentInputformat);
        if (program == null) {
            throw new IllegalStateException("Unable to configure program for input format: " + (Object)((Object)this.mCurrentInputformat));
        }
        if (this.mCurrentProgram != program) {
            this.mCurrentProgram = program;
            this.mCurrentProgram.use();
            Log.d((String)TAG, (String)("Using program for input format " + (Object)((Object)this.mCurrentInputformat) + ": " + this.mCurrentProgram));
        }
        this.activateExternalTexture(textureId);
    }

    private void releaseInternal() {
        for (GLUtils.Program2D program : this.mProgramHandles.values()) {
            program.delete();
        }
        this.mProgramHandles = Collections.emptyMap();
        this.mCurrentProgram = null;
        if (!Objects.equals(this.mEglDisplay, EGL14.EGL_NO_DISPLAY)) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            for (OutputSurface outputSurface : this.mOutputSurfaceMap.values()) {
                if (Objects.equals(outputSurface.getEglSurface(), EGL14.EGL_NO_SURFACE) || EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)outputSurface.getEglSurface())) continue;
                GLUtils.checkEglErrorOrLog("eglDestroySurface");
            }
            this.mOutputSurfaceMap.clear();
            if (!Objects.equals(this.mTempSurface, EGL14.EGL_NO_SURFACE)) {
                EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mTempSurface);
                this.mTempSurface = EGL14.EGL_NO_SURFACE;
            }
            if (!Objects.equals(this.mEglContext, EGL14.EGL_NO_CONTEXT)) {
                EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mEglContext);
                this.mEglContext = EGL14.EGL_NO_CONTEXT;
            }
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
        }
        this.mEglConfig = null;
        this.mExternalTextureId = -1;
        this.mCurrentInputformat = GLUtils.InputFormat.UNKNOWN;
        this.mCurrentSurface = null;
        this.mGlThread = null;
    }

    @NonNull
    protected OutputSurface getOutSurfaceOrThrow(@NonNull Surface surface) {
        Preconditions.checkState((boolean)this.mOutputSurfaceMap.containsKey(surface), (String)"The surface is not registered.");
        return Objects.requireNonNull(this.mOutputSurfaceMap.get(surface));
    }

    @Nullable
    protected OutputSurface createOutputSurfaceInternal(@NonNull Surface surface) {
        EGLSurface eglSurface;
        try {
            eglSurface = GLUtils.createWindowSurface(this.mEglDisplay, Objects.requireNonNull(this.mEglConfig), surface, this.mSurfaceAttrib);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            Logger.w(TAG, "Failed to create EGL surface: " + e.getMessage(), e);
            return null;
        }
        Size size = GLUtils.getSurfaceSize(this.mEglDisplay, eglSurface);
        return OutputSurface.of(eglSurface, size.getWidth(), size.getHeight());
    }

    protected void removeOutputSurfaceInternal(@NonNull Surface surface, boolean unregister) {
        OutputSurface removedOutputSurface;
        if (this.mCurrentSurface == surface) {
            this.mCurrentSurface = null;
            this.makeCurrent(this.mTempSurface);
        }
        if ((removedOutputSurface = unregister ? this.mOutputSurfaceMap.remove(surface) : this.mOutputSurfaceMap.put(surface, GLUtils.NO_OUTPUT_SURFACE)) != null && removedOutputSurface != GLUtils.NO_OUTPUT_SURFACE) {
            try {
                EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)removedOutputSurface.getEglSurface());
            }
            catch (RuntimeException e) {
                Logger.w(TAG, "Failed to destroy EGL surface: " + e.getMessage(), e);
            }
        }
    }
}

