/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalImageCaptureOutputFormat;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.LayoutSettings;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.RestrictedCameraControl;
import androidx.camera.core.impl.RestrictedCameraInfo;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.AutoValue_CameraUseCaseAdapter_CameraId;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ViewPorts;
import androidx.camera.core.processing.TargetUtils;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class CameraUseCaseAdapter
implements Camera {
    @NonNull
    private final CameraInternal mCameraInternal;
    @Nullable
    private final CameraInternal mSecondaryCameraInternal;
    private final CameraDeviceSurfaceManager mCameraDeviceSurfaceManager;
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    private static final String TAG = "CameraUseCaseAdapter";
    private final CameraId mId;
    @GuardedBy(value="mLock")
    private final List<UseCase> mAppUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    private final List<UseCase> mCameraUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    private final CameraCoordinator mCameraCoordinator;
    @GuardedBy(value="mLock")
    @Nullable
    private ViewPort mViewPort;
    @GuardedBy(value="mLock")
    @NonNull
    private List<CameraEffect> mEffects = Collections.emptyList();
    @GuardedBy(value="mLock")
    @NonNull
    private final CameraConfig mCameraConfig;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mAttached = true;
    @GuardedBy(value="mLock")
    private Config mInteropConfig = null;
    @GuardedBy(value="mLock")
    @Nullable
    private UseCase mPlaceholderForExtensions;
    @GuardedBy(value="mLock")
    @Nullable
    private StreamSharing mStreamSharing;
    @NonNull
    private final RestrictedCameraControl mAdapterCameraControl;
    @NonNull
    private final RestrictedCameraInfo mAdapterCameraInfo;
    @Nullable
    private final RestrictedCameraInfo mAdapterSecondaryCameraInfo;
    @NonNull
    private final LayoutSettings mLayoutSettings;
    @NonNull
    private final LayoutSettings mSecondaryLayoutSettings;

    public CameraUseCaseAdapter(@NonNull CameraInternal camera, @NonNull CameraCoordinator cameraCoordinator, @NonNull CameraDeviceSurfaceManager cameraDeviceSurfaceManager, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this(camera, null, new RestrictedCameraInfo(camera.getCameraInfoInternal(), CameraConfigs.defaultConfig()), null, LayoutSettings.DEFAULT, LayoutSettings.DEFAULT, cameraCoordinator, cameraDeviceSurfaceManager, useCaseConfigFactory);
    }

    public CameraUseCaseAdapter(@NonNull CameraInternal camera, @Nullable CameraInternal secondaryCamera, @NonNull RestrictedCameraInfo restrictedCameraInfo, @Nullable RestrictedCameraInfo secondaryRestrictedCameraInfo, @NonNull LayoutSettings layoutSettings, @NonNull LayoutSettings secondaryLayoutSettings, @NonNull CameraCoordinator cameraCoordinator, @NonNull CameraDeviceSurfaceManager cameraDeviceSurfaceManager, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this.mCameraInternal = camera;
        this.mSecondaryCameraInternal = secondaryCamera;
        this.mLayoutSettings = layoutSettings;
        this.mSecondaryLayoutSettings = secondaryLayoutSettings;
        this.mCameraCoordinator = cameraCoordinator;
        this.mCameraDeviceSurfaceManager = cameraDeviceSurfaceManager;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
        this.mCameraConfig = restrictedCameraInfo.getCameraConfig();
        SessionProcessor sessionProcessor = this.mCameraConfig.getSessionProcessor(null);
        this.mAdapterCameraControl = new RestrictedCameraControl(this.mCameraInternal.getCameraControlInternal(), sessionProcessor);
        this.mAdapterCameraInfo = restrictedCameraInfo;
        this.mAdapterSecondaryCameraInfo = secondaryRestrictedCameraInfo;
        this.mId = CameraUseCaseAdapter.generateCameraId(restrictedCameraInfo, secondaryRestrictedCameraInfo);
    }

    @NonNull
    public static CameraId generateCameraId(@NonNull RestrictedCameraInfo primaryCameraInfo, @Nullable RestrictedCameraInfo secondaryCameraInfo) {
        return CameraId.create(primaryCameraInfo.getCameraId() + (secondaryCameraInfo == null ? "" : secondaryCameraInfo.getCameraId()), primaryCameraInfo.getCameraConfig().getCompatibilityId());
    }

    @NonNull
    public CameraId getCameraId() {
        return this.mId;
    }

    public boolean isEquivalent(@NonNull CameraUseCaseAdapter cameraUseCaseAdapter) {
        return this.getCameraId().equals(cameraUseCaseAdapter.getCameraId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPort(@Nullable ViewPort viewPort) {
        Object object = this.mLock;
        synchronized (object) {
            this.mViewPort = viewPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffects(@Nullable List<CameraEffect> effects) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEffects = effects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUseCases(@NonNull Collection<UseCase> appUseCasesToAdd) throws CameraException {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraInternal.setExtendedConfig(this.mCameraConfig);
            if (this.mSecondaryCameraInternal != null) {
                this.mSecondaryCameraInternal.setExtendedConfig(this.mCameraConfig);
            }
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.addAll(appUseCasesToAdd);
            try {
                this.updateUseCases(appUseCases, this.mSecondaryCameraInternal != null, this.mSecondaryCameraInternal != null);
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUseCases(@NonNull Collection<UseCase> useCasesToRemove) {
        Object object = this.mLock;
        synchronized (object) {
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.removeAll(useCasesToRemove);
            this.updateUseCases(appUseCases, this.mSecondaryCameraInternal != null, this.mSecondaryCameraInternal != null);
        }
    }

    void updateUseCases(@NonNull Collection<UseCase> appUseCases) {
        this.updateUseCases(appUseCases, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUseCases(@NonNull Collection<UseCase> appUseCases, boolean applyStreamSharing, boolean isDualCamera) {
        Object object = this.mLock;
        synchronized (object) {
            Map<UseCase, StreamSpec> primaryStreamSpecMap;
            this.checkUnsupportedFeatureCombinationAndThrow(appUseCases);
            if (!applyStreamSharing && this.hasExtension() && CameraUseCaseAdapter.hasVideoCapture(appUseCases)) {
                this.updateUseCases(appUseCases, true, isDualCamera);
                return;
            }
            StreamSharing streamSharing = this.createOrReuseStreamSharing(appUseCases, applyStreamSharing);
            UseCase placeholderForExtensions = this.calculatePlaceholderForExtensions(appUseCases, streamSharing);
            Collection<UseCase> cameraUseCases = CameraUseCaseAdapter.calculateCameraUseCases(appUseCases, placeholderForExtensions, streamSharing);
            ArrayList<UseCase> cameraUseCasesToAttach = new ArrayList<UseCase>(cameraUseCases);
            cameraUseCasesToAttach.removeAll(this.mCameraUseCases);
            ArrayList<UseCase> cameraUseCasesToKeep = new ArrayList<UseCase>(cameraUseCases);
            cameraUseCasesToKeep.retainAll(this.mCameraUseCases);
            ArrayList<UseCase> cameraUseCasesToDetach = new ArrayList<UseCase>(this.mCameraUseCases);
            cameraUseCasesToDetach.removeAll(cameraUseCases);
            Map<UseCase, ConfigPair> configs = CameraUseCaseAdapter.getConfigs(cameraUseCasesToAttach, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
            Map<Object, Object> secondaryStreamSpecMap = Collections.emptyMap();
            try {
                primaryStreamSpecMap = this.calculateSuggestedStreamSpecs(this.getCameraMode(), this.mCameraInternal.getCameraInfoInternal(), cameraUseCasesToAttach, cameraUseCasesToKeep, configs);
                if (this.mSecondaryCameraInternal != null) {
                    secondaryStreamSpecMap = this.calculateSuggestedStreamSpecs(this.getCameraMode(), Objects.requireNonNull(this.mSecondaryCameraInternal).getCameraInfoInternal(), cameraUseCasesToAttach, cameraUseCasesToKeep, configs);
                }
            }
            catch (IllegalArgumentException exception) {
                if (!applyStreamSharing && !this.hasExtension() && this.mCameraCoordinator.getCameraOperatingMode() != 2) {
                    this.updateUseCases(appUseCases, true, isDualCamera);
                    return;
                }
                throw exception;
            }
            this.updateViewPortAndSensorToBufferMatrix(primaryStreamSpecMap, cameraUseCases);
            CameraUseCaseAdapter.updateEffects(this.mEffects, cameraUseCases, appUseCases);
            for (UseCase useCase : cameraUseCasesToDetach) {
                useCase.unbindFromCamera(this.mCameraInternal);
            }
            this.mCameraInternal.detachUseCases(cameraUseCasesToDetach);
            if (this.mSecondaryCameraInternal != null) {
                for (UseCase useCase : cameraUseCasesToDetach) {
                    useCase.unbindFromCamera(Objects.requireNonNull(this.mSecondaryCameraInternal));
                }
                Objects.requireNonNull(this.mSecondaryCameraInternal).detachUseCases(cameraUseCasesToDetach);
            }
            if (cameraUseCasesToDetach.isEmpty()) {
                for (UseCase useCase : cameraUseCasesToKeep) {
                    StreamSpec newStreamSpec;
                    Config config;
                    if (!primaryStreamSpecMap.containsKey(useCase) || (config = (newStreamSpec = primaryStreamSpecMap.get(useCase)).getImplementationOptions()) == null || !CameraUseCaseAdapter.hasImplementationOptionChanged(newStreamSpec, useCase.getSessionConfig())) continue;
                    useCase.updateSuggestedStreamSpecImplementationOptions(config);
                    if (!this.mAttached) continue;
                    this.mCameraInternal.onUseCaseUpdated(useCase);
                    if (this.mSecondaryCameraInternal == null) continue;
                    Objects.requireNonNull(this.mSecondaryCameraInternal).onUseCaseUpdated(useCase);
                }
            }
            for (UseCase useCase : cameraUseCasesToAttach) {
                ConfigPair configPair = Objects.requireNonNull(configs.get(useCase));
                if (this.mSecondaryCameraInternal != null) {
                    useCase.bindToCamera(this.mCameraInternal, Objects.requireNonNull(this.mSecondaryCameraInternal), configPair.mExtendedConfig, configPair.mCameraConfig);
                    useCase.updateSuggestedStreamSpec((StreamSpec)Preconditions.checkNotNull((Object)primaryStreamSpecMap.get(useCase)), (StreamSpec)secondaryStreamSpecMap.get(useCase));
                    continue;
                }
                useCase.bindToCamera(this.mCameraInternal, null, configPair.mExtendedConfig, configPair.mCameraConfig);
                useCase.updateSuggestedStreamSpec((StreamSpec)Preconditions.checkNotNull((Object)primaryStreamSpecMap.get(useCase)), null);
            }
            if (this.mAttached) {
                this.mCameraInternal.attachUseCases(cameraUseCasesToAttach);
                if (this.mSecondaryCameraInternal != null) {
                    Objects.requireNonNull(this.mSecondaryCameraInternal).attachUseCases(cameraUseCasesToAttach);
                }
            }
            for (UseCase useCase : cameraUseCasesToAttach) {
                useCase.notifyState();
            }
            this.mAppUseCases.clear();
            this.mAppUseCases.addAll(appUseCases);
            this.mCameraUseCases.clear();
            this.mCameraUseCases.addAll(cameraUseCases);
            this.mPlaceholderForExtensions = placeholderForExtensions;
            this.mStreamSharing = streamSharing;
        }
    }

    private static boolean hasImplementationOptionChanged(StreamSpec streamSpec, SessionConfig sessionConfig) {
        Config newStreamSpecOptions = streamSpec.getImplementationOptions();
        Config sessionConfigOptions = sessionConfig.getImplementationOptions();
        if (newStreamSpecOptions.listOptions().size() != sessionConfig.getImplementationOptions().listOptions().size()) {
            return true;
        }
        for (Config.Option<?> newOption : newStreamSpecOptions.listOptions()) {
            if (sessionConfigOptions.containsOption(newOption) && Objects.equals(sessionConfigOptions.retrieveOption(newOption), newStreamSpecOptions.retrieveOption(newOption))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCameraMode() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraCoordinator.getCameraOperatingMode() == 2) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasExtension() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig.getSessionProcessor(null) != null;
        }
    }

    @NonNull
    private Set<UseCase> getStreamSharingChildren(@NonNull Collection<UseCase> appUseCases, boolean forceSharingToPreviewAndVideo) {
        HashSet<UseCase> children = new HashSet<UseCase>();
        int sharingTargets = this.getSharingTargets(forceSharingToPreviewAndVideo);
        for (UseCase useCase : appUseCases) {
            Preconditions.checkArgument((!StreamSharing.isStreamSharing(useCase) ? 1 : 0) != 0, (Object)"Only support one level of sharing for now.");
            if (!useCase.isEffectTargetsSupported(sharingTargets)) continue;
            children.add(useCase);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSharingTargets(boolean forceSharingToPreviewAndVideo) {
        Object object = this.mLock;
        synchronized (object) {
            int sharingTargets;
            CameraEffect sharingEffect = null;
            for (CameraEffect effect : this.mEffects) {
                if (TargetUtils.getNumberOfTargets(effect.getTargets()) <= 1) continue;
                Preconditions.checkState((sharingEffect == null ? 1 : 0) != 0, (String)"Can only have one sharing effect.");
                sharingEffect = effect;
            }
            int n = sharingTargets = sharingEffect == null ? 0 : sharingEffect.getTargets();
            if (forceSharingToPreviewAndVideo) {
                sharingTargets |= 3;
            }
            return sharingTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StreamSharing createOrReuseStreamSharing(@NonNull Collection<UseCase> appUseCases, boolean forceSharingToPreviewAndVideo) {
        Object object = this.mLock;
        synchronized (object) {
            Set<UseCase> newChildren = this.getStreamSharingChildren(appUseCases, forceSharingToPreviewAndVideo);
            if (!(newChildren.size() >= 2 || this.hasExtension() && CameraUseCaseAdapter.hasVideoCapture(newChildren))) {
                return null;
            }
            if (this.mStreamSharing != null && this.mStreamSharing.getChildren().equals(newChildren)) {
                return Objects.requireNonNull(this.mStreamSharing);
            }
            if (!CameraUseCaseAdapter.isStreamSharingChildrenCombinationValid(newChildren)) {
                return null;
            }
            return new StreamSharing(this.mCameraInternal, this.mSecondaryCameraInternal, this.mLayoutSettings, this.mSecondaryLayoutSettings, newChildren, this.mUseCaseConfigFactory);
        }
    }

    static boolean isStreamSharingChildrenCombinationValid(@NonNull Collection<UseCase> children) {
        int[] validChildrenTypes = new int[]{1, 2, 4};
        HashSet<Integer> childrenTypes = new HashSet<Integer>();
        for (UseCase child : children) {
            for (int type : validChildrenTypes) {
                if (!child.isEffectTargetsSupported(type)) continue;
                if (childrenTypes.contains(type)) {
                    return false;
                }
                childrenTypes.add(type);
            }
        }
        return true;
    }

    static Collection<UseCase> calculateCameraUseCases(@NonNull Collection<UseCase> appUseCases, @Nullable UseCase placeholderForExtensions, @Nullable StreamSharing streamSharing) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(appUseCases);
        if (placeholderForExtensions != null) {
            useCases.add(placeholderForExtensions);
        }
        if (streamSharing != null) {
            useCases.add(streamSharing);
            useCases.removeAll(streamSharing.getChildren());
        }
        return useCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<UseCase> getUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mAppUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    public Collection<UseCase> getCameraUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mCameraUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAttached) {
                if (!this.mCameraUseCases.isEmpty()) {
                    this.mCameraInternal.setExtendedConfig(this.mCameraConfig);
                    if (this.mSecondaryCameraInternal != null) {
                        this.mSecondaryCameraInternal.setExtendedConfig(this.mCameraConfig);
                    }
                }
                this.mCameraInternal.attachUseCases(this.mCameraUseCases);
                if (this.mSecondaryCameraInternal != null) {
                    this.mSecondaryCameraInternal.attachUseCases(this.mCameraUseCases);
                }
                this.restoreInteropConfig();
                for (UseCase useCase : this.mCameraUseCases) {
                    useCase.notifyState();
                }
                this.mAttached = true;
            }
        }
    }

    public void setActiveResumingMode(boolean enabled) {
        this.mCameraInternal.setActiveResumingMode(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAttached) {
                this.mCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mCameraUseCases));
                if (this.mSecondaryCameraInternal != null) {
                    this.mSecondaryCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mCameraUseCases));
                }
                this.cacheInteropConfig();
                this.mAttached = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteropConfig != null) {
                this.mCameraInternal.getCameraControlInternal().addInteropConfig(this.mInteropConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            CameraControlInternal cameraControlInternal = this.mCameraInternal.getCameraControlInternal();
            this.mInteropConfig = cameraControlInternal.getInteropConfig();
            cameraControlInternal.clearInteropConfig();
        }
    }

    private Map<UseCase, StreamSpec> calculateSuggestedStreamSpecs(int cameraMode, @NonNull CameraInfoInternal cameraInfoInternal, @NonNull Collection<UseCase> newUseCases, @NonNull Collection<UseCase> currentUseCases, @NonNull Map<UseCase, ConfigPair> configPairMap) {
        ArrayList<AttachedSurfaceInfo> existingSurfaces = new ArrayList<AttachedSurfaceInfo>();
        String cameraId = cameraInfoInternal.getCameraId();
        HashMap<UseCase, StreamSpec> suggestedStreamSpecs = new HashMap<UseCase, StreamSpec>();
        HashMap<AttachedSurfaceInfo, UseCase> surfaceInfoUseCaseMap = new HashMap<AttachedSurfaceInfo, UseCase>();
        for (UseCase useCase : currentUseCases) {
            SurfaceConfig surfaceConfig = this.mCameraDeviceSurfaceManager.transformSurfaceConfig(cameraMode, cameraId, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution());
            AttachedSurfaceInfo attachedSurfaceInfo = AttachedSurfaceInfo.create(surfaceConfig, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution(), ((StreamSpec)Preconditions.checkNotNull((Object)useCase.getAttachedStreamSpec())).getDynamicRange(), StreamSharing.getCaptureTypes(useCase), useCase.getAttachedStreamSpec().getImplementationOptions(), useCase.getCurrentConfig().getTargetFrameRate(null));
            existingSurfaces.add(attachedSurfaceInfo);
            surfaceInfoUseCaseMap.put(attachedSurfaceInfo, useCase);
            suggestedStreamSpecs.put(useCase, useCase.getAttachedStreamSpec());
        }
        if (!newUseCases.isEmpty()) {
            Rect sensorRect;
            HashMap configToUseCaseMap = new HashMap();
            HashMap configToSupportedSizesMap = new HashMap();
            try {
                sensorRect = this.mCameraInternal.getCameraControlInternal().getSensorRect();
            }
            catch (NullPointerException e) {
                sensorRect = null;
            }
            SupportedOutputSizesSorter supportedOutputSizesSorter = new SupportedOutputSizesSorter(cameraInfoInternal, sensorRect != null ? TransformUtils.rectToSize(sensorRect) : null);
            boolean isPreviewStabilizationOn = false;
            for (UseCase useCase : newUseCases) {
                ConfigPair configPair = configPairMap.get(useCase);
                UseCaseConfig<?> combinedUseCaseConfig = useCase.mergeConfigs(cameraInfoInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                configToUseCaseMap.put(combinedUseCaseConfig, useCase);
                configToSupportedSizesMap.put(combinedUseCaseConfig, supportedOutputSizesSorter.getSortedSupportedOutputSizes(combinedUseCaseConfig));
                if (!(useCase.getCurrentConfig() instanceof PreviewConfig)) continue;
                isPreviewStabilizationOn = ((PreviewConfig)useCase.getCurrentConfig()).getPreviewStabilizationMode() == 2;
            }
            Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> streamSpecMaps = this.mCameraDeviceSurfaceManager.getSuggestedStreamSpecs(cameraMode, cameraId, existingSurfaces, configToSupportedSizesMap, isPreviewStabilizationOn, CameraUseCaseAdapter.hasVideoCapture(newUseCases));
            for (Map.Entry entry : configToUseCaseMap.entrySet()) {
                suggestedStreamSpecs.put((UseCase)entry.getValue(), (StreamSpec)((Map)streamSpecMaps.first).get(entry.getKey()));
            }
            for (Map.Entry entry : ((Map)streamSpecMaps.second).entrySet()) {
                if (!surfaceInfoUseCaseMap.containsKey(entry.getKey())) continue;
                suggestedStreamSpecs.put((UseCase)surfaceInfoUseCaseMap.get(entry.getKey()), (StreamSpec)entry.getValue());
            }
        }
        return suggestedStreamSpecs;
    }

    @VisibleForTesting
    static void updateEffects(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> cameraUseCases, @NonNull Collection<UseCase> appUseCases) {
        List<CameraEffect> unusedEffects = CameraUseCaseAdapter.setEffectsOnUseCases(effects, cameraUseCases);
        ArrayList<UseCase> appOnlyUseCases = new ArrayList<UseCase>(appUseCases);
        appOnlyUseCases.removeAll(cameraUseCases);
        unusedEffects = CameraUseCaseAdapter.setEffectsOnUseCases(unusedEffects, appOnlyUseCases);
        if (unusedEffects.size() > 0) {
            Logger.w(TAG, "Unused effects: " + unusedEffects);
        }
    }

    @NonNull
    private static List<CameraEffect> setEffectsOnUseCases(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> useCases) {
        ArrayList<CameraEffect> unusedEffects = new ArrayList<CameraEffect>(effects);
        for (UseCase useCase : useCases) {
            useCase.setEffect(null);
            for (CameraEffect effect : effects) {
                if (!useCase.isEffectTargetsSupported(effect.getTargets())) continue;
                Preconditions.checkState((useCase.getEffect() == null ? 1 : 0) != 0, (String)(useCase + " already has effect" + useCase.getEffect()));
                useCase.setEffect(effect);
                unusedEffects.remove(effect);
            }
        }
        return unusedEffects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewPortAndSensorToBufferMatrix(@NonNull Map<UseCase, StreamSpec> suggestedStreamSpecMap, @NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mViewPort != null && !useCases.isEmpty()) {
                boolean isFrontCamera;
                Integer lensFacing = this.mCameraInternal.getCameraInfoInternal().getLensFacing();
                if (lensFacing == null) {
                    Logger.w(TAG, "The lens facing is null, probably an external.");
                    isFrontCamera = true;
                } else {
                    isFrontCamera = lensFacing == 0;
                }
                Map<UseCase, Rect> cropRectMap = ViewPorts.calculateViewPortRects(this.mCameraInternal.getCameraControlInternal().getSensorRect(), isFrontCamera, this.mViewPort.getAspectRatio(), this.mCameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.mViewPort.getRotation()), this.mViewPort.getScaleType(), this.mViewPort.getLayoutDirection(), suggestedStreamSpecMap);
                for (UseCase useCase : useCases) {
                    useCase.setViewPortCropRect((Rect)Preconditions.checkNotNull((Object)cropRectMap.get(useCase)));
                }
            }
            for (UseCase useCase : useCases) {
                useCase.setSensorToBufferTransformMatrix(CameraUseCaseAdapter.calculateSensorToBufferTransformMatrix(this.mCameraInternal.getCameraControlInternal().getSensorRect(), ((StreamSpec)Preconditions.checkNotNull((Object)suggestedStreamSpecMap.get(useCase))).getResolution()));
            }
        }
    }

    @NonNull
    private static Matrix calculateSensorToBufferTransformMatrix(@NonNull Rect fullSensorRect, @NonNull Size useCaseSize) {
        Preconditions.checkArgument((fullSensorRect.width() > 0 && fullSensorRect.height() > 0 ? 1 : 0) != 0, (Object)"Cannot compute viewport crop rects zero sized sensor rect.");
        RectF fullSensorRectF = new RectF(fullSensorRect);
        Matrix sensorToUseCaseTransformation = new Matrix();
        RectF srcRect = new RectF(0.0f, 0.0f, (float)useCaseSize.getWidth(), (float)useCaseSize.getHeight());
        sensorToUseCaseTransformation.setRectToRect(srcRect, fullSensorRectF, Matrix.ScaleToFit.CENTER);
        sensorToUseCaseTransformation.invert(sensorToUseCaseTransformation);
        return sensorToUseCaseTransformation;
    }

    private static Map<UseCase, ConfigPair> getConfigs(@NonNull Collection<UseCase> useCases, @NonNull UseCaseConfigFactory extendedFactory, @NonNull UseCaseConfigFactory cameraFactory) {
        HashMap<UseCase, ConfigPair> configs = new HashMap<UseCase, ConfigPair>();
        for (UseCase useCase : useCases) {
            UseCaseConfig<?> extendedConfig = StreamSharing.isStreamSharing(useCase) ? CameraUseCaseAdapter.generateExtendedStreamSharingConfigFromPreview(extendedFactory, (StreamSharing)useCase) : useCase.getDefaultConfig(false, extendedFactory);
            UseCaseConfig<?> cameraConfig = useCase.getDefaultConfig(true, cameraFactory);
            configs.put(useCase, new ConfigPair(extendedConfig, cameraConfig));
        }
        return configs;
    }

    private static UseCaseConfig<?> generateExtendedStreamSharingConfigFromPreview(@NonNull UseCaseConfigFactory extendedFactory, @NonNull StreamSharing streamSharing) {
        Preview preview = new Preview.Builder().build();
        UseCaseConfig<?> previewConfig = preview.getDefaultConfig(false, extendedFactory);
        if (previewConfig == null) {
            return null;
        }
        MutableOptionsBundle mutableConfig = MutableOptionsBundle.from(previewConfig);
        mutableConfig.removeOption(TargetConfig.OPTION_TARGET_CLASS);
        return streamSharing.getUseCaseConfigBuilder(mutableConfig).getUseCaseConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnsupportedFeatureCombinationAndThrow(@NonNull Collection<UseCase> useCases) throws IllegalArgumentException {
        if (this.hasExtension()) {
            if (CameraUseCaseAdapter.hasNonSdrConfig(useCases)) {
                throw new IllegalArgumentException("Extensions are only supported for use with standard dynamic range.");
            }
            if (CameraUseCaseAdapter.hasUltraHdrImageCapture(useCases)) {
                throw new IllegalArgumentException("Extensions are not supported for use with Ultra HDR image capture.");
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEffects.isEmpty() && CameraUseCaseAdapter.hasUltraHdrImageCapture(useCases)) {
                throw new IllegalArgumentException("Ultra HDR image capture does not support for use with CameraEffect.");
            }
        }
    }

    private static boolean hasNonSdrConfig(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            DynamicRange dynamicRange = useCase.getCurrentConfig().getDynamicRange();
            if (!CameraUseCaseAdapter.isNotSdr(dynamicRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotSdr(@NonNull DynamicRange dynamicRange) {
        boolean is10Bit = dynamicRange.getBitDepth() == 10;
        boolean isHdr = dynamicRange.getEncoding() != 1 && dynamicRange.getEncoding() != 0;
        return is10Bit || isHdr;
    }

    @OptIn(markerClass={ExperimentalImageCaptureOutputFormat.class})
    private static boolean hasUltraHdrImageCapture(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            UseCaseConfig<?> config;
            if (!CameraUseCaseAdapter.isImageCapture(useCase) || !(config = useCase.getCurrentConfig()).containsOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT) || (Integer)Preconditions.checkNotNull((Object)config.retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT)) != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public CameraControl getCameraControl() {
        return this.mAdapterCameraControl;
    }

    @Override
    @NonNull
    public CameraInfo getCameraInfo() {
        return this.mAdapterCameraInfo;
    }

    @Nullable
    public CameraInfo getSecondaryCameraInfo() {
        return this.mAdapterSecondaryCameraInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CameraConfig getExtendedConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUseCasesCombinationSupported(boolean withStreamSharing, UseCase ... useCases) {
        Collection<UseCase> useCasesToVerify = Arrays.asList(useCases);
        if (withStreamSharing) {
            StreamSharing streamSharing = this.createOrReuseStreamSharing(useCasesToVerify, true);
            useCasesToVerify = CameraUseCaseAdapter.calculateCameraUseCases(useCasesToVerify, null, streamSharing);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                Map<UseCase, ConfigPair> configs = CameraUseCaseAdapter.getConfigs(useCasesToVerify, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
                this.calculateSuggestedStreamSpecs(this.getCameraMode(), this.mCameraInternal.getCameraInfoInternal(), useCasesToVerify, Collections.emptyList(), configs);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private UseCase calculatePlaceholderForExtensions(@NonNull Collection<UseCase> appUseCases, @Nullable StreamSharing streamSharing) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<UseCase> useCasesToCheck = new ArrayList<UseCase>(appUseCases);
            if (streamSharing != null) {
                useCasesToCheck.add(streamSharing);
                useCasesToCheck.removeAll(streamSharing.getChildren());
            }
            UseCase placeholder = null;
            if (this.isCoexistingPreviewImageCaptureRequired()) {
                if (CameraUseCaseAdapter.isExtraPreviewRequired(useCasesToCheck)) {
                    placeholder = CameraUseCaseAdapter.isPreview(this.mPlaceholderForExtensions) ? this.mPlaceholderForExtensions : this.createExtraPreview();
                } else if (CameraUseCaseAdapter.isExtraImageCaptureRequired(useCasesToCheck)) {
                    placeholder = CameraUseCaseAdapter.isImageCapture(this.mPlaceholderForExtensions) ? this.mPlaceholderForExtensions : this.createExtraImageCapture();
                }
            }
            return placeholder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCoexistingPreviewImageCaptureRequired() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig.getUseCaseCombinationRequiredRule() == 1;
        }
    }

    private static boolean isExtraPreviewRequired(@NonNull Collection<UseCase> useCases) {
        boolean hasPreviewOrStreamSharing = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (CameraUseCaseAdapter.isPreview(useCase) || StreamSharing.isStreamSharing(useCase)) {
                hasPreviewOrStreamSharing = true;
                continue;
            }
            if (!CameraUseCaseAdapter.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasImageCapture && !hasPreviewOrStreamSharing;
    }

    private static boolean isExtraImageCaptureRequired(@NonNull Collection<UseCase> useCases) {
        boolean hasPreviewOrStreamSharing = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (CameraUseCaseAdapter.isPreview(useCase) || StreamSharing.isStreamSharing(useCase)) {
                hasPreviewOrStreamSharing = true;
                continue;
            }
            if (!CameraUseCaseAdapter.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasPreviewOrStreamSharing && !hasImageCapture;
    }

    private static boolean hasVideoCapture(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            if (!CameraUseCaseAdapter.isVideoCapture(useCase)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVideoCapture(@Nullable UseCase useCase) {
        if (useCase != null) {
            if (useCase.getCurrentConfig().containsOption(UseCaseConfig.OPTION_CAPTURE_TYPE)) {
                return useCase.getCurrentConfig().getCaptureType() == UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE;
            }
            Log.e((String)TAG, (String)(useCase + " UseCase does not have capture type."));
        }
        return false;
    }

    private static boolean isPreview(@Nullable UseCase useCase) {
        return useCase instanceof Preview;
    }

    private static boolean isImageCapture(@Nullable UseCase useCase) {
        return useCase instanceof ImageCapture;
    }

    private Preview createExtraPreview() {
        Preview preview = new Preview.Builder().setTargetName("Preview-Extra").build();
        preview.setSurfaceProvider(surfaceRequest -> {
            SurfaceTexture surfaceTexture = new SurfaceTexture(0);
            surfaceTexture.setDefaultBufferSize(surfaceRequest.getResolution().getWidth(), surfaceRequest.getResolution().getHeight());
            surfaceTexture.detachFromGLContext();
            Surface surface = new Surface(surfaceTexture);
            surfaceRequest.provideSurface(surface, CameraXExecutors.directExecutor(), (Consumer<SurfaceRequest.Result>)((Consumer)surfaceResponse -> {
                surface.release();
                surfaceTexture.release();
            }));
        });
        return preview;
    }

    private ImageCapture createExtraImageCapture() {
        return new ImageCapture.Builder().setTargetName("ImageCapture-Extra").build();
    }

    @AutoValue
    public static abstract class CameraId {
        @NonNull
        public static CameraId create(@NonNull String cameraIdString, @NonNull Identifier cameraConfigId) {
            return new AutoValue_CameraUseCaseAdapter_CameraId(cameraIdString, cameraConfigId);
        }

        @NonNull
        public abstract String getCameraIdString();

        @NonNull
        public abstract Identifier getCameraConfigId();
    }

    public static final class CameraException
    extends Exception {
        public CameraException() {
        }

        public CameraException(@NonNull String message) {
            super(message);
        }

        public CameraException(@NonNull Throwable cause) {
            super(cause);
        }
    }

    private static class ConfigPair {
        UseCaseConfig<?> mExtendedConfig;
        UseCaseConfig<?> mCameraConfig;

        ConfigPair(UseCaseConfig<?> extendedConfig, UseCaseConfig<?> cameraConfig) {
            this.mExtendedConfig = extendedConfig;
            this.mCameraConfig = cameraConfig;
        }
    }
}

