/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.Objects;

public final class ContextUtil {
    @NonNull
    public static Context getApplicationContext(@NonNull Context context) {
        String attributeTagResultContext;
        String attributeTagContext;
        int deviceIdResultContext;
        int deviceIdContext;
        Context resultContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 34 && (deviceIdContext = Api34Impl.getDeviceId(context)) != (deviceIdResultContext = Api34Impl.getDeviceId(resultContext))) {
            resultContext = Api34Impl.createDeviceContext(resultContext, deviceIdContext);
        }
        if (Build.VERSION.SDK_INT >= 30 && !Objects.equals(attributeTagContext = Api30Impl.getAttributionTag(context), attributeTagResultContext = Api30Impl.getAttributionTag(resultContext))) {
            resultContext = Api30Impl.createAttributionContext(resultContext, attributeTagContext);
        }
        return resultContext;
    }

    @Nullable
    public static Application getApplicationFromContext(@NonNull Context context) {
        Application application = null;
        Context appContext = ContextUtil.getApplicationContext(context);
        while (appContext instanceof ContextWrapper) {
            if (appContext instanceof Application) {
                application = (Application)appContext;
                break;
            }
            appContext = ((ContextWrapper)appContext).getBaseContext();
        }
        return application;
    }

    private ContextUtil() {
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @NonNull
        static Context createDeviceContext(@NonNull Context context, int deviceId) {
            return context.createDeviceContext(deviceId);
        }

        static int getDeviceId(@NonNull Context context) {
            return context.getDeviceId();
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @NonNull
        static Context createAttributionContext(@NonNull Context context, @Nullable String attributeTag) {
            return context.createAttributionContext(attributeTag);
        }

        @Nullable
        static String getAttributionTag(@NonNull Context context) {
            return context.getAttributionTag();
        }
    }
}

