/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AutoValue_StreamSpec;
import androidx.camera.core.impl.Config;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class StreamSpec {
    public static final Range<Integer> FRAME_RATE_RANGE_UNSPECIFIED = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));

    @NonNull
    public abstract Size getResolution();

    @NonNull
    public abstract DynamicRange getDynamicRange();

    @NonNull
    public abstract Range<Integer> getExpectedFrameRateRange();

    @Nullable
    public abstract Config getImplementationOptions();

    public abstract boolean getZslDisabled();

    @NonNull
    public static Builder builder(@NonNull Size resolution) {
        return new AutoValue_StreamSpec.Builder().setResolution(resolution).setExpectedFrameRateRange(FRAME_RATE_RANGE_UNSPECIFIED).setDynamicRange(DynamicRange.SDR).setZslDisabled(false);
    }

    @NonNull
    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        @NonNull
        public abstract Builder setResolution(@NonNull Size var1);

        @NonNull
        public abstract Builder setDynamicRange(@NonNull DynamicRange var1);

        @NonNull
        public abstract Builder setExpectedFrameRateRange(@NonNull Range<Integer> var1);

        @NonNull
        public abstract Builder setImplementationOptions(@NonNull Config var1);

        @NonNull
        public abstract Builder setZslDisabled(boolean var1);

        @NonNull
        public abstract StreamSpec build();
    }
}

