/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Quirk;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class QuirkSettings {
    private final boolean mEnabledWhenDeviceHasQuirk;
    private final Set<Class<? extends Quirk>> mForceEnabledQuirks;
    private final Set<Class<? extends Quirk>> mForceDisabledQuirks;

    private QuirkSettings(boolean enabledWhenDeviceHasQuirk, @Nullable Set<Class<? extends Quirk>> forceEnabledQuirks, @Nullable Set<Class<? extends Quirk>> forceDisabledQuirks) {
        this.mEnabledWhenDeviceHasQuirk = enabledWhenDeviceHasQuirk;
        this.mForceEnabledQuirks = forceEnabledQuirks == null ? Collections.emptySet() : new HashSet<Class<? extends Quirk>>(forceEnabledQuirks);
        this.mForceDisabledQuirks = forceDisabledQuirks == null ? Collections.emptySet() : new HashSet<Class<? extends Quirk>>(forceDisabledQuirks);
    }

    @NonNull
    public static QuirkSettings withDefaultBehavior() {
        return new Builder().setEnabledWhenDeviceHasQuirk(true).build();
    }

    @NonNull
    public static QuirkSettings withAllQuirksDisabled() {
        return new Builder().setEnabledWhenDeviceHasQuirk(false).build();
    }

    @NonNull
    public static QuirkSettings withQuirksForceEnabled(@NonNull Set<Class<? extends Quirk>> quirks) {
        return new Builder().forceEnableQuirks(quirks).build();
    }

    @NonNull
    public static QuirkSettings withQuirksForceDisabled(@NonNull Set<Class<? extends Quirk>> quirks) {
        return new Builder().forceDisableQuirks(quirks).build();
    }

    public boolean isEnabledWhenDeviceHasQuirk() {
        return this.mEnabledWhenDeviceHasQuirk;
    }

    @NonNull
    public Set<Class<? extends Quirk>> getForceEnabledQuirks() {
        return Collections.unmodifiableSet(this.mForceEnabledQuirks);
    }

    @NonNull
    public Set<Class<? extends Quirk>> getForceDisabledQuirks() {
        return Collections.unmodifiableSet(this.mForceDisabledQuirks);
    }

    public boolean shouldEnableQuirk(@NonNull Class<? extends Quirk> quirk, boolean deviceHasQuirk) {
        if (this.mForceEnabledQuirks.contains(quirk)) {
            return true;
        }
        if (this.mForceDisabledQuirks.contains(quirk)) {
            return false;
        }
        return this.mEnabledWhenDeviceHasQuirk && deviceHasQuirk;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof QuirkSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        QuirkSettings other = (QuirkSettings)obj;
        return this.mEnabledWhenDeviceHasQuirk == other.mEnabledWhenDeviceHasQuirk && Objects.equals(this.mForceEnabledQuirks, other.mForceEnabledQuirks) && Objects.equals(this.mForceDisabledQuirks, other.mForceDisabledQuirks);
    }

    public int hashCode() {
        return Objects.hash(this.mEnabledWhenDeviceHasQuirk, this.mForceEnabledQuirks, this.mForceDisabledQuirks);
    }

    @NonNull
    public String toString() {
        return "QuirkSettings{enabledWhenDeviceHasQuirk=" + this.mEnabledWhenDeviceHasQuirk + ", forceEnabledQuirks=" + this.mForceEnabledQuirks + ", forceDisabledQuirks=" + this.mForceDisabledQuirks + '}';
    }

    public static class Builder {
        private boolean mEnabledWhenDeviceHasQuirk = true;
        private Set<Class<? extends Quirk>> mForceEnabledQuirks;
        private Set<Class<? extends Quirk>> mForceDisabledQuirks;

        @NonNull
        public Builder setEnabledWhenDeviceHasQuirk(boolean enabled) {
            this.mEnabledWhenDeviceHasQuirk = enabled;
            return this;
        }

        @NonNull
        public Builder forceEnableQuirks(@NonNull Set<Class<? extends Quirk>> quirks) {
            this.mForceEnabledQuirks = new HashSet<Class<? extends Quirk>>(quirks);
            return this;
        }

        @NonNull
        public Builder forceDisableQuirks(@NonNull Set<Class<? extends Quirk>> quirks) {
            this.mForceDisabledQuirks = new HashSet<Class<? extends Quirk>>(quirks);
            return this;
        }

        @NonNull
        public QuirkSettings build() {
            return new QuirkSettings(this.mEnabledWhenDeviceHasQuirk, this.mForceEnabledQuirks, this.mForceDisabledQuirks);
        }
    }
}

