/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.MultiValueSet;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.MutableTagBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class CaptureConfig {
    public static final int TEMPLATE_TYPE_NONE = -1;
    public static final Config.Option<Integer> OPTION_ROTATION = Config.Option.create("camerax.core.captureConfig.rotation", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_JPEG_QUALITY = Config.Option.create("camerax.core.captureConfig.jpegQuality", Integer.class);
    private static final Config.Option<Range<Integer>> OPTION_RESOLVED_FRAME_RATE = Config.Option.create("camerax.core.captureConfig.resolvedFrameRate", Range.class);
    public static final String CAPTURE_CONFIG_ID_TAG_KEY = "CAPTURE_CONFIG_ID_KEY";
    public static final int DEFAULT_ID = -1;
    final List<DeferrableSurface> mSurfaces;
    final Config mImplementationOptions;
    final int mTemplateType;
    final boolean mPostviewEnabled;
    final List<CameraCaptureCallback> mCameraCaptureCallbacks;
    private final boolean mUseRepeatingSurface;
    @NonNull
    private final TagBundle mTagBundle;
    @Nullable
    private final CameraCaptureResult mCameraCaptureResult;

    CaptureConfig(List<DeferrableSurface> surfaces, Config implementationOptions, int templateType, boolean postviewEnabled, List<CameraCaptureCallback> cameraCaptureCallbacks, boolean useRepeatingSurface, @NonNull TagBundle tagBundle, @Nullable CameraCaptureResult cameraCaptureResult) {
        this.mSurfaces = surfaces;
        this.mImplementationOptions = implementationOptions;
        this.mTemplateType = templateType;
        this.mCameraCaptureCallbacks = Collections.unmodifiableList(cameraCaptureCallbacks);
        this.mUseRepeatingSurface = useRepeatingSurface;
        this.mTagBundle = tagBundle;
        this.mCameraCaptureResult = cameraCaptureResult;
        this.mPostviewEnabled = postviewEnabled;
    }

    @NonNull
    public static CaptureConfig defaultEmptyCaptureConfig() {
        return new Builder().build();
    }

    @Nullable
    public CameraCaptureResult getCameraCaptureResult() {
        return this.mCameraCaptureResult;
    }

    @NonNull
    public List<DeferrableSurface> getSurfaces() {
        return Collections.unmodifiableList(this.mSurfaces);
    }

    @NonNull
    public Config getImplementationOptions() {
        return this.mImplementationOptions;
    }

    public int getTemplateType() {
        return this.mTemplateType;
    }

    public int getId() {
        Object id = this.mTagBundle.getTag(CAPTURE_CONFIG_ID_TAG_KEY);
        if (id == null) {
            return -1;
        }
        return (Integer)id;
    }

    @NonNull
    public Range<Integer> getExpectedFrameRateRange() {
        return Objects.requireNonNull(this.mImplementationOptions.retrieveOption(OPTION_RESOLVED_FRAME_RATE, StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED));
    }

    public int getPreviewStabilizationMode() {
        return Objects.requireNonNull(this.mImplementationOptions.retrieveOption(UseCaseConfig.OPTION_PREVIEW_STABILIZATION_MODE, 0));
    }

    public int getVideoStabilizationMode() {
        return Objects.requireNonNull(this.mImplementationOptions.retrieveOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE, 0));
    }

    public boolean isPostviewEnabled() {
        return this.mPostviewEnabled;
    }

    public boolean isUseRepeatingSurface() {
        return this.mUseRepeatingSurface;
    }

    @NonNull
    public List<CameraCaptureCallback> getCameraCaptureCallbacks() {
        return this.mCameraCaptureCallbacks;
    }

    @NonNull
    public TagBundle getTagBundle() {
        return this.mTagBundle;
    }

    public static final class Builder {
        private final Set<DeferrableSurface> mSurfaces = new HashSet<DeferrableSurface>();
        private MutableConfig mImplementationOptions = MutableOptionsBundle.create();
        private int mTemplateType = -1;
        private boolean mPostviewEnabled = false;
        private List<CameraCaptureCallback> mCameraCaptureCallbacks = new ArrayList<CameraCaptureCallback>();
        private boolean mUseRepeatingSurface = false;
        private MutableTagBundle mMutableTagBundle = MutableTagBundle.create();
        @Nullable
        private CameraCaptureResult mCameraCaptureResult;

        public Builder() {
        }

        private Builder(CaptureConfig base) {
            this.mSurfaces.addAll(base.mSurfaces);
            this.mImplementationOptions = MutableOptionsBundle.from(base.mImplementationOptions);
            this.mTemplateType = base.mTemplateType;
            this.mCameraCaptureCallbacks.addAll(base.getCameraCaptureCallbacks());
            this.mUseRepeatingSurface = base.isUseRepeatingSurface();
            this.mMutableTagBundle = MutableTagBundle.from(base.getTagBundle());
            this.mPostviewEnabled = base.mPostviewEnabled;
        }

        @NonNull
        public static Builder createFrom(@NonNull UseCaseConfig<?> config) {
            OptionUnpacker unpacker = config.getCaptureOptionUnpacker(null);
            if (unpacker == null) {
                throw new IllegalStateException("Implementation is missing option unpacker for " + config.getTargetName(config.toString()));
            }
            Builder builder = new Builder();
            unpacker.unpack(config, builder);
            return builder;
        }

        @NonNull
        public static Builder from(@NonNull CaptureConfig base) {
            return new Builder(base);
        }

        public void setCameraCaptureResult(@NonNull CameraCaptureResult cameraCaptureResult) {
            this.mCameraCaptureResult = cameraCaptureResult;
        }

        public int getTemplateType() {
            return this.mTemplateType;
        }

        @Nullable
        public Range<Integer> getExpectedFrameRateRange() {
            return this.mImplementationOptions.retrieveOption(OPTION_RESOLVED_FRAME_RATE, StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED);
        }

        public void setTemplateType(int templateType) {
            this.mTemplateType = templateType;
        }

        public void setExpectedFrameRateRange(@NonNull Range<Integer> expectedFrameRateRange) {
            this.addImplementationOption(OPTION_RESOLVED_FRAME_RATE, expectedFrameRateRange);
        }

        public void setPreviewStabilization(int mode) {
            if (mode != 0) {
                this.addImplementationOption(UseCaseConfig.OPTION_PREVIEW_STABILIZATION_MODE, mode);
            }
        }

        public void setVideoStabilization(int mode) {
            if (mode != 0) {
                this.addImplementationOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE, mode);
            }
        }

        public void setPostviewEnabled(boolean postviewEnabled) {
            this.mPostviewEnabled = postviewEnabled;
        }

        public void addCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            if (this.mCameraCaptureCallbacks.contains(cameraCaptureCallback)) {
                return;
            }
            this.mCameraCaptureCallbacks.add(cameraCaptureCallback);
        }

        public void addAllCameraCaptureCallbacks(@NonNull Collection<CameraCaptureCallback> cameraCaptureCallbacks) {
            for (CameraCaptureCallback c : cameraCaptureCallbacks) {
                this.addCameraCaptureCallback(c);
            }
        }

        public boolean removeCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            return this.mCameraCaptureCallbacks.remove(cameraCaptureCallback);
        }

        public void addSurface(@NonNull DeferrableSurface surface) {
            this.mSurfaces.add(surface);
        }

        public void removeSurface(@NonNull DeferrableSurface surface) {
            this.mSurfaces.remove(surface);
        }

        public void clearSurfaces() {
            this.mSurfaces.clear();
        }

        @NonNull
        public Set<DeferrableSurface> getSurfaces() {
            return this.mSurfaces;
        }

        public void setImplementationOptions(@NonNull Config config) {
            this.mImplementationOptions = MutableOptionsBundle.from(config);
        }

        public void addImplementationOptions(@NonNull Config config) {
            Iterator<Config.Option<?>> iterator = config.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option<?> option;
                Config.Option<?> objectOpt = option = iterator.next();
                Object existValue = this.mImplementationOptions.retrieveOption(objectOpt, null);
                Object newValue = config.retrieveOption(objectOpt);
                if (existValue instanceof MultiValueSet) {
                    ((MultiValueSet)existValue).addAll(((MultiValueSet)newValue).getAllItems());
                    continue;
                }
                if (newValue instanceof MultiValueSet) {
                    newValue = ((MultiValueSet)newValue).clone();
                }
                this.mImplementationOptions.insertOption(objectOpt, config.getOptionPriority(option), newValue);
            }
        }

        public <T> void addImplementationOption(@NonNull Config.Option<T> option, @NonNull T value) {
            this.mImplementationOptions.insertOption(option, value);
        }

        @NonNull
        public Config getImplementationOptions() {
            return this.mImplementationOptions;
        }

        public boolean isUseRepeatingSurface() {
            return this.mUseRepeatingSurface;
        }

        public void setUseRepeatingSurface(boolean useRepeatingSurface) {
            this.mUseRepeatingSurface = useRepeatingSurface;
        }

        @Nullable
        public Object getTag(@NonNull String key) {
            return this.mMutableTagBundle.getTag(key);
        }

        public void addTag(@NonNull String key, @NonNull Object tag) {
            this.mMutableTagBundle.putTag(key, tag);
        }

        public void setId(int id) {
            this.mMutableTagBundle.putTag(CaptureConfig.CAPTURE_CONFIG_ID_TAG_KEY, id);
        }

        public void addAllTags(@NonNull TagBundle bundle) {
            this.mMutableTagBundle.addTagBundle(bundle);
        }

        @NonNull
        public CaptureConfig build() {
            return new CaptureConfig(new ArrayList<DeferrableSurface>(this.mSurfaces), OptionsBundle.from(this.mImplementationOptions), this.mTemplateType, this.mPostviewEnabled, new ArrayList<CameraCaptureCallback>(this.mCameraCaptureCallbacks), this.mUseRepeatingSurface, TagBundle.from(this.mMutableTagBundle), this.mCameraCaptureResult);
        }
    }

    public static interface OptionUnpacker {
        public void unpack(@NonNull UseCaseConfig<?> var1, @NonNull Builder var2);
    }
}

