/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.Observable;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;

public interface CameraInternal
extends Camera,
UseCase.StateChangeCallback {
    public void open();

    public void close();

    default public void setActiveResumingMode(boolean enabled) {
    }

    default public boolean isFrontFacing() {
        return this.getCameraInfo().getLensFacing() == 0;
    }

    @NonNull
    public ListenableFuture<Void> release();

    @NonNull
    public Observable<State> getCameraState();

    public void attachUseCases(@NonNull Collection<UseCase> var1);

    public void detachUseCases(@NonNull Collection<UseCase> var1);

    @NonNull
    public CameraControlInternal getCameraControlInternal();

    @NonNull
    public CameraInfoInternal getCameraInfoInternal();

    @Override
    @NonNull
    default public CameraControl getCameraControl() {
        return this.getCameraControlInternal();
    }

    @Override
    @NonNull
    default public CameraInfo getCameraInfo() {
        return this.getCameraInfoInternal();
    }

    default public boolean getHasTransform() {
        return true;
    }

    default public void setPrimary(boolean isPrimary) {
    }

    @Override
    @NonNull
    default public CameraConfig getExtendedConfig() {
        return CameraConfigs.defaultConfig();
    }

    default public void setExtendedConfig(@Nullable CameraConfig cameraConfig) {
    }

    public static enum State {
        RELEASED(false),
        RELEASING(true),
        CLOSED(false),
        PENDING_OPEN(false),
        CLOSING(true),
        OPENING(true),
        OPEN(true),
        CONFIGURED(true);

        private final boolean mHoldsCameraSlot;

        private State(boolean holdsCameraSlot) {
            this.mHoldsCameraSlot = holdsCameraSlot;
        }

        boolean holdsCameraSlot() {
            return this.mHoldsCameraSlot;
        }
    }
}

