/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;

final class AutoValue_StreamSpec
extends StreamSpec {
    private final Size resolution;
    private final DynamicRange dynamicRange;
    private final Range<Integer> expectedFrameRateRange;
    private final Config implementationOptions;
    private final boolean zslDisabled;

    private AutoValue_StreamSpec(Size resolution, DynamicRange dynamicRange, Range<Integer> expectedFrameRateRange, @Nullable Config implementationOptions, boolean zslDisabled) {
        this.resolution = resolution;
        this.dynamicRange = dynamicRange;
        this.expectedFrameRateRange = expectedFrameRateRange;
        this.implementationOptions = implementationOptions;
        this.zslDisabled = zslDisabled;
    }

    @Override
    @NonNull
    public Size getResolution() {
        return this.resolution;
    }

    @Override
    @NonNull
    public DynamicRange getDynamicRange() {
        return this.dynamicRange;
    }

    @Override
    @NonNull
    public Range<Integer> getExpectedFrameRateRange() {
        return this.expectedFrameRateRange;
    }

    @Override
    @Nullable
    public Config getImplementationOptions() {
        return this.implementationOptions;
    }

    @Override
    public boolean getZslDisabled() {
        return this.zslDisabled;
    }

    public String toString() {
        return "StreamSpec{resolution=" + this.resolution + ", dynamicRange=" + this.dynamicRange + ", expectedFrameRateRange=" + this.expectedFrameRateRange + ", implementationOptions=" + this.implementationOptions + ", zslDisabled=" + this.zslDisabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StreamSpec) {
            StreamSpec that = (StreamSpec)o;
            return this.resolution.equals((Object)that.getResolution()) && this.dynamicRange.equals(that.getDynamicRange()) && this.expectedFrameRateRange.equals(that.getExpectedFrameRateRange()) && (this.implementationOptions == null ? that.getImplementationOptions() == null : this.implementationOptions.equals(that.getImplementationOptions())) && this.zslDisabled == that.getZslDisabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.dynamicRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.expectedFrameRateRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.implementationOptions == null ? 0 : this.implementationOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.zslDisabled ? 1231 : 1237;
    }

    @Override
    public StreamSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends StreamSpec.Builder {
        private Size resolution;
        private DynamicRange dynamicRange;
        private Range<Integer> expectedFrameRateRange;
        private Config implementationOptions;
        private Boolean zslDisabled;

        Builder() {
        }

        private Builder(StreamSpec source) {
            this.resolution = source.getResolution();
            this.dynamicRange = source.getDynamicRange();
            this.expectedFrameRateRange = source.getExpectedFrameRateRange();
            this.implementationOptions = source.getImplementationOptions();
            this.zslDisabled = source.getZslDisabled();
        }

        @Override
        public StreamSpec.Builder setResolution(Size resolution) {
            if (resolution == null) {
                throw new NullPointerException("Null resolution");
            }
            this.resolution = resolution;
            return this;
        }

        @Override
        public StreamSpec.Builder setDynamicRange(DynamicRange dynamicRange) {
            if (dynamicRange == null) {
                throw new NullPointerException("Null dynamicRange");
            }
            this.dynamicRange = dynamicRange;
            return this;
        }

        @Override
        public StreamSpec.Builder setExpectedFrameRateRange(Range<Integer> expectedFrameRateRange) {
            if (expectedFrameRateRange == null) {
                throw new NullPointerException("Null expectedFrameRateRange");
            }
            this.expectedFrameRateRange = expectedFrameRateRange;
            return this;
        }

        @Override
        public StreamSpec.Builder setImplementationOptions(Config implementationOptions) {
            this.implementationOptions = implementationOptions;
            return this;
        }

        @Override
        public StreamSpec.Builder setZslDisabled(boolean zslDisabled) {
            this.zslDisabled = zslDisabled;
            return this;
        }

        @Override
        public StreamSpec build() {
            String missing = "";
            if (this.resolution == null) {
                missing = missing + " resolution";
            }
            if (this.dynamicRange == null) {
                missing = missing + " dynamicRange";
            }
            if (this.expectedFrameRateRange == null) {
                missing = missing + " expectedFrameRateRange";
            }
            if (this.zslDisabled == null) {
                missing = missing + " zslDisabled";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_StreamSpec(this.resolution, this.dynamicRange, this.expectedFrameRateRange, this.implementationOptions, this.zslDisabled);
        }
    }
}

