/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Matrix;
import android.graphics.Rect;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CameraCaptureCallback;
import java.util.List;
import java.util.concurrent.Executor;

final class AutoValue_TakePictureRequest
extends TakePictureRequest {
    private final Executor appExecutor;
    private final ImageCapture.OnImageCapturedCallback inMemoryCallback;
    private final ImageCapture.OnImageSavedCallback onDiskCallback;
    private final ImageCapture.OutputFileOptions outputFileOptions;
    private final Rect cropRect;
    private final Matrix sensorToBufferTransform;
    private final int rotationDegrees;
    private final int jpegQuality;
    private final int captureMode;
    private final List<CameraCaptureCallback> sessionConfigCameraCaptureCallbacks;

    AutoValue_TakePictureRequest(Executor appExecutor, @Nullable ImageCapture.OnImageCapturedCallback inMemoryCallback, @Nullable ImageCapture.OnImageSavedCallback onDiskCallback, @Nullable ImageCapture.OutputFileOptions outputFileOptions, Rect cropRect, Matrix sensorToBufferTransform, int rotationDegrees, int jpegQuality, int captureMode, List<CameraCaptureCallback> sessionConfigCameraCaptureCallbacks) {
        if (appExecutor == null) {
            throw new NullPointerException("Null appExecutor");
        }
        this.appExecutor = appExecutor;
        this.inMemoryCallback = inMemoryCallback;
        this.onDiskCallback = onDiskCallback;
        this.outputFileOptions = outputFileOptions;
        if (cropRect == null) {
            throw new NullPointerException("Null cropRect");
        }
        this.cropRect = cropRect;
        if (sensorToBufferTransform == null) {
            throw new NullPointerException("Null sensorToBufferTransform");
        }
        this.sensorToBufferTransform = sensorToBufferTransform;
        this.rotationDegrees = rotationDegrees;
        this.jpegQuality = jpegQuality;
        this.captureMode = captureMode;
        if (sessionConfigCameraCaptureCallbacks == null) {
            throw new NullPointerException("Null sessionConfigCameraCaptureCallbacks");
        }
        this.sessionConfigCameraCaptureCallbacks = sessionConfigCameraCaptureCallbacks;
    }

    @Override
    @NonNull
    Executor getAppExecutor() {
        return this.appExecutor;
    }

    @Override
    @Nullable
    public ImageCapture.OnImageCapturedCallback getInMemoryCallback() {
        return this.inMemoryCallback;
    }

    @Override
    @Nullable
    public ImageCapture.OnImageSavedCallback getOnDiskCallback() {
        return this.onDiskCallback;
    }

    @Override
    @Nullable
    ImageCapture.OutputFileOptions getOutputFileOptions() {
        return this.outputFileOptions;
    }

    @Override
    @NonNull
    Rect getCropRect() {
        return this.cropRect;
    }

    @Override
    @NonNull
    Matrix getSensorToBufferTransform() {
        return this.sensorToBufferTransform;
    }

    @Override
    int getRotationDegrees() {
        return this.rotationDegrees;
    }

    @Override
    @IntRange(from=1L, to=100L)
    int getJpegQuality() {
        return this.jpegQuality;
    }

    @Override
    int getCaptureMode() {
        return this.captureMode;
    }

    @Override
    @NonNull
    List<CameraCaptureCallback> getSessionConfigCameraCaptureCallbacks() {
        return this.sessionConfigCameraCaptureCallbacks;
    }

    public String toString() {
        return "TakePictureRequest{appExecutor=" + this.appExecutor + ", inMemoryCallback=" + this.inMemoryCallback + ", onDiskCallback=" + this.onDiskCallback + ", outputFileOptions=" + this.outputFileOptions + ", cropRect=" + this.cropRect + ", sensorToBufferTransform=" + this.sensorToBufferTransform + ", rotationDegrees=" + this.rotationDegrees + ", jpegQuality=" + this.jpegQuality + ", captureMode=" + this.captureMode + ", sessionConfigCameraCaptureCallbacks=" + this.sessionConfigCameraCaptureCallbacks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TakePictureRequest) {
            TakePictureRequest that = (TakePictureRequest)o;
            return this.appExecutor.equals(that.getAppExecutor()) && (this.inMemoryCallback == null ? that.getInMemoryCallback() == null : this.inMemoryCallback.equals(that.getInMemoryCallback())) && (this.onDiskCallback == null ? that.getOnDiskCallback() == null : this.onDiskCallback.equals(that.getOnDiskCallback())) && (this.outputFileOptions == null ? that.getOutputFileOptions() == null : this.outputFileOptions.equals(that.getOutputFileOptions())) && this.cropRect.equals((Object)that.getCropRect()) && this.sensorToBufferTransform.equals((Object)that.getSensorToBufferTransform()) && this.rotationDegrees == that.getRotationDegrees() && this.jpegQuality == that.getJpegQuality() && this.captureMode == that.getCaptureMode() && this.sessionConfigCameraCaptureCallbacks.equals(that.getSessionConfigCameraCaptureCallbacks());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.appExecutor.hashCode();
        h$ *= 1000003;
        h$ ^= this.inMemoryCallback == null ? 0 : this.inMemoryCallback.hashCode();
        h$ *= 1000003;
        h$ ^= this.onDiskCallback == null ? 0 : this.onDiskCallback.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputFileOptions == null ? 0 : this.outputFileOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.cropRect.hashCode();
        h$ *= 1000003;
        h$ ^= this.sensorToBufferTransform.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationDegrees;
        h$ *= 1000003;
        h$ ^= this.jpegQuality;
        h$ *= 1000003;
        h$ ^= this.captureMode;
        h$ *= 1000003;
        return h$ ^= this.sessionConfigCameraCaptureCallbacks.hashCode();
    }
}

