/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.AutoValue_SurfaceRequest_Result;
import androidx.camera.core.AutoValue_SurfaceRequest_TransformationInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class SurfaceRequest {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Range<Integer> FRAME_RATE_RANGE_UNSPECIFIED = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
    private final Object mLock = new Object();
    private final Size mResolution;
    @NonNull
    private final DynamicRange mDynamicRange;
    private final Range<Integer> mExpectedFrameRate;
    private final CameraInternal mCamera;
    private final boolean mIsPrimary;
    final ListenableFuture<Surface> mSurfaceFuture;
    private final CallbackToFutureAdapter.Completer<Surface> mSurfaceCompleter;
    private final ListenableFuture<Void> mSessionStatusFuture;
    @NonNull
    private final CallbackToFutureAdapter.Completer<Void> mSurfaceRecreationCompleter;
    private final CallbackToFutureAdapter.Completer<Void> mRequestCancellationCompleter;
    private final DeferrableSurface mInternalDeferrableSurface;
    @GuardedBy(value="mLock")
    @Nullable
    private TransformationInfo mTransformationInfo;
    @GuardedBy(value="mLock")
    @Nullable
    private TransformationInfoListener mTransformationInfoListener;
    @GuardedBy(value="mLock")
    @Nullable
    private Executor mTransformationInfoExecutor;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceRequest(@NonNull Size resolution, @NonNull CameraInternal camera, @NonNull Runnable onInvalidated) {
        this(resolution, camera, DynamicRange.SDR, FRAME_RATE_RANGE_UNSPECIFIED, onInvalidated);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceRequest(@NonNull Size resolution, @NonNull CameraInternal camera, @NonNull DynamicRange dynamicRange, @NonNull Range<Integer> expectedFrameRate, @NonNull Runnable onInvalidated) {
        this(resolution, camera, true, dynamicRange, expectedFrameRate, onInvalidated);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceRequest(@NonNull Size resolution, @NonNull CameraInternal camera, boolean isPrimary, @NonNull DynamicRange dynamicRange, @NonNull Range<Integer> expectedFrameRate, @NonNull Runnable onInvalidated) {
        CallbackToFutureAdapter.Completer requestCancellationCompleter;
        this.mResolution = resolution;
        this.mCamera = camera;
        this.mIsPrimary = isPrimary;
        this.mDynamicRange = dynamicRange;
        this.mExpectedFrameRate = expectedFrameRate;
        final String surfaceRequestString = "SurfaceRequest[size: " + resolution + ", id: " + this.hashCode() + "]";
        AtomicReference<Object> cancellationCompleterRef = new AtomicReference<Object>(null);
        final ListenableFuture requestCancellationFuture = CallbackToFutureAdapter.getFuture(completer -> {
            cancellationCompleterRef.set(completer);
            return surfaceRequestString + "-cancellation";
        });
        this.mRequestCancellationCompleter = requestCancellationCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)cancellationCompleterRef.get());
        AtomicReference<Object> sessionStatusCompleterRef = new AtomicReference<Object>(null);
        this.mSessionStatusFuture = CallbackToFutureAdapter.getFuture(completer -> {
            sessionStatusCompleterRef.set(completer);
            return surfaceRequestString + "-status";
        });
        Futures.addCallback(this.mSessionStatusFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
                Preconditions.checkState((boolean)requestCancellationCompleter.set(null));
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                if (t instanceof RequestCancelledException) {
                    Preconditions.checkState((boolean)requestCancellationFuture.cancel(false));
                } else {
                    Preconditions.checkState((boolean)requestCancellationCompleter.set(null));
                }
            }
        }, CameraXExecutors.directExecutor());
        final CallbackToFutureAdapter.Completer sessionStatusCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)sessionStatusCompleterRef.get());
        AtomicReference<Object> surfaceCompleterRef = new AtomicReference<Object>(null);
        this.mSurfaceFuture = CallbackToFutureAdapter.getFuture(completer -> {
            surfaceCompleterRef.set(completer);
            return surfaceRequestString + "-Surface";
        });
        this.mSurfaceCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)surfaceCompleterRef.get());
        this.mInternalDeferrableSurface = new DeferrableSurface(resolution, 34){

            @Override
            @NonNull
            protected ListenableFuture<Surface> provideSurface() {
                return SurfaceRequest.this.mSurfaceFuture;
            }
        };
        final ListenableFuture<Void> terminationFuture = this.mInternalDeferrableSurface.getTerminationFuture();
        Futures.addCallback(this.mSurfaceFuture, new FutureCallback<Surface>(){

            @Override
            public void onSuccess(@Nullable Surface result) {
                Futures.propagate(terminationFuture, sessionStatusCompleter);
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                if (t instanceof CancellationException) {
                    Preconditions.checkState((boolean)sessionStatusCompleter.setException((Throwable)new RequestCancelledException(surfaceRequestString + " cancelled.", t)));
                } else {
                    sessionStatusCompleter.set(null);
                }
            }
        }, CameraXExecutors.directExecutor());
        terminationFuture.addListener(() -> this.mSurfaceFuture.cancel(true), CameraXExecutors.directExecutor());
        this.mSurfaceRecreationCompleter = this.initialSurfaceRecreationCompleter(CameraXExecutors.directExecutor(), onInvalidated);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public DeferrableSurface getDeferrableSurface() {
        return this.mInternalDeferrableSurface;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isServiced() {
        return this.mSurfaceFuture.isDone();
    }

    @NonNull
    public Size getResolution() {
        return this.mResolution;
    }

    @NonNull
    public DynamicRange getDynamicRange() {
        return this.mDynamicRange;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Range<Integer> getExpectedFrameRate() {
        return this.mExpectedFrameRate;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CameraInternal getCamera() {
        return this.mCamera;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    public void provideSurface(final @NonNull Surface surface, @NonNull Executor executor, final @NonNull Consumer<Result> resultListener) {
        if (this.mSurfaceCompleter.set((Object)surface) || this.mSurfaceFuture.isCancelled()) {
            Futures.addCallback(this.mSessionStatusFuture, new FutureCallback<Void>(){

                @Override
                public void onSuccess(@Nullable Void result) {
                    resultListener.accept((Object)Result.of(0, surface));
                }

                @Override
                public void onFailure(@NonNull Throwable t) {
                    Preconditions.checkState((boolean)(t instanceof RequestCancelledException), (String)("Camera surface session should only fail with request cancellation. Instead failed due to:\n" + t));
                    resultListener.accept((Object)Result.of(1, surface));
                }
            }, executor);
        } else {
            Preconditions.checkState((boolean)this.mSurfaceFuture.isDone());
            try {
                this.mSurfaceFuture.get();
                executor.execute(() -> resultListener.accept((Object)Result.of(3, surface)));
            }
            catch (InterruptedException | ExecutionException e) {
                executor.execute(() -> resultListener.accept((Object)Result.of(4, surface)));
            }
        }
    }

    public boolean willNotProvideSurface() {
        return this.mSurfaceCompleter.setException((Throwable)new DeferrableSurface.SurfaceUnavailableException("Surface request will not complete."));
    }

    private CallbackToFutureAdapter.Completer<Void> initialSurfaceRecreationCompleter(@NonNull Executor executor, final @NonNull Runnable runnable) {
        AtomicReference<Object> completerRef = new AtomicReference<Object>(null);
        ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
            completerRef.set(completer);
            return "SurfaceRequest-surface-recreation(" + this.hashCode() + ")";
        });
        Futures.addCallback(future, new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
                runnable.run();
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
            }
        }, executor);
        return (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)completerRef.get());
    }

    public boolean invalidate() {
        this.willNotProvideSurface();
        return this.mSurfaceRecreationCompleter.set(null);
    }

    @SuppressLint(value={"PairedRegistration"})
    public void addRequestCancellationListener(@NonNull Executor executor, @NonNull Runnable listener) {
        this.mRequestCancellationCompleter.addCancellationListener(listener, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateTransformationInfo(@NonNull TransformationInfo transformationInfo) {
        Executor executor;
        TransformationInfoListener listener;
        Object object = this.mLock;
        synchronized (object) {
            this.mTransformationInfo = transformationInfo;
            listener = this.mTransformationInfoListener;
            executor = this.mTransformationInfoExecutor;
        }
        if (listener != null && executor != null) {
            executor.execute(() -> listener.onTransformationInfoUpdate(transformationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformationInfoListener(@NonNull Executor executor, @NonNull TransformationInfoListener listener) {
        TransformationInfo transformationInfo;
        Object object = this.mLock;
        synchronized (object) {
            this.mTransformationInfoListener = listener;
            this.mTransformationInfoExecutor = executor;
            transformationInfo = this.mTransformationInfo;
        }
        if (transformationInfo != null) {
            executor.execute(() -> listener.onTransformationInfoUpdate(transformationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransformationInfoListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTransformationInfoListener = null;
            this.mTransformationInfoExecutor = null;
        }
    }

    @AutoValue
    public static abstract class TransformationInfo {
        @NonNull
        public abstract Rect getCropRect();

        public abstract int getRotationDegrees();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public abstract int getTargetRotation();

        public abstract boolean hasCameraTransform();

        @NonNull
        public abstract Matrix getSensorToBufferTransform();

        public abstract boolean isMirroring();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static TransformationInfo of(@NonNull Rect cropRect, int rotationDegrees, int targetRotation, boolean hasCameraTransform, @NonNull Matrix sensorToBufferTransform, boolean mirroring) {
            return new AutoValue_SurfaceRequest_TransformationInfo(cropRect, rotationDegrees, targetRotation, hasCameraTransform, sensorToBufferTransform, mirroring);
        }

        TransformationInfo() {
        }
    }

    public static interface TransformationInfoListener {
        public void onTransformationInfoUpdate(@NonNull TransformationInfo var1);
    }

    @AutoValue
    public static abstract class Result {
        public static final int RESULT_SURFACE_USED_SUCCESSFULLY = 0;
        public static final int RESULT_REQUEST_CANCELLED = 1;
        public static final int RESULT_INVALID_SURFACE = 2;
        public static final int RESULT_SURFACE_ALREADY_PROVIDED = 3;
        public static final int RESULT_WILL_NOT_PROVIDE_SURFACE = 4;

        @NonNull
        static Result of(int code, @NonNull Surface surface) {
            return new AutoValue_SurfaceRequest_Result(code, surface);
        }

        public abstract int getResultCode();

        @NonNull
        public abstract Surface getSurface();

        Result() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ResultCode {
        }
    }

    private static final class RequestCancelledException
    extends RuntimeException {
        RequestCancelledException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }
    }
}

