/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.PointF;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.MeteringPointFactory;

public final class DisplayOrientedMeteringPointFactory
extends MeteringPointFactory {
    private final float mWidth;
    private final float mHeight;
    @NonNull
    private final Display mDisplay;
    @NonNull
    private final CameraInfo mCameraInfo;

    public DisplayOrientedMeteringPointFactory(@NonNull Display display, @NonNull CameraInfo cameraInfo, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mDisplay = display;
        this.mCameraInfo = cameraInfo;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected PointF convertPoint(float x, float y) {
        float width = this.mWidth;
        float height = this.mHeight;
        int lensFacing = this.mCameraInfo.getLensFacing();
        boolean compensateForMirroring = lensFacing == 0;
        int relativeCameraOrientation = this.getRelativeCameraOrientation(compensateForMirroring);
        float outputX = x;
        float outputY = y;
        float outputWidth = width;
        float outputHeight = height;
        if (relativeCameraOrientation == 90 || relativeCameraOrientation == 270) {
            outputX = y;
            outputY = x;
            outputWidth = height;
            outputHeight = width;
        }
        switch (relativeCameraOrientation) {
            case 90: {
                outputY = outputHeight - outputY;
                break;
            }
            case 180: {
                outputX = outputWidth - outputX;
                outputY = outputHeight - outputY;
                break;
            }
            case 270: {
                outputX = outputWidth - outputX;
                break;
            }
        }
        if (compensateForMirroring) {
            outputX = outputWidth - outputX;
        }
        return new PointF(outputX /= outputWidth, outputY /= outputHeight);
    }

    private int getRelativeCameraOrientation(boolean compensateForMirroring) {
        int rotationDegrees;
        try {
            int displayRotation = this.mDisplay.getRotation();
            rotationDegrees = this.mCameraInfo.getSensorRotationDegrees(displayRotation);
            if (compensateForMirroring) {
                rotationDegrees = (360 - rotationDegrees) % 360;
            }
        }
        catch (Exception e) {
            rotationDegrees = 0;
        }
        return rotationDegrees;
    }
}

