/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.LargeJpegImageQuirk;

@RequiresApi(value=21)
public class InvalidJpegDataParser {
    private final boolean mHasQuirk = DeviceQuirks.get(LargeJpegImageQuirk.class) != null;

    public int getValidDataLength(@NonNull byte[] bytes) {
        if (!this.mHasQuirk) {
            return bytes.length;
        }
        int markPosition = 2;
        while (true) {
            if (markPosition + 4 > bytes.length || bytes[markPosition] != -1) {
                return bytes.length;
            }
            int segmentLength = (bytes[markPosition + 2] & 0xFF) << 8 | bytes[markPosition + 3] & 0xFF;
            if (bytes[markPosition] == -1 && bytes[markPosition + 1] == -38) break;
            markPosition += segmentLength + 2;
        }
        int eoiPosition = markPosition + 2;
        while (true) {
            if (eoiPosition + 2 > bytes.length) {
                return bytes.length;
            }
            if (bytes[eoiPosition] == -1 && bytes[eoiPosition + 1] == -39) break;
            ++eoiPosition;
        }
        return eoiPosition + 2;
    }
}

