/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AutoValue_AttachedSurfaceInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import com.google.auto.value.AutoValue;
import java.util.List;

@RequiresApi(value=21)
@AutoValue
public abstract class AttachedSurfaceInfo {
    AttachedSurfaceInfo() {
    }

    @NonNull
    public static AttachedSurfaceInfo create(@NonNull SurfaceConfig surfaceConfig, int imageFormat, @NonNull Size size, @NonNull DynamicRange dynamicRange, @NonNull List<UseCaseConfigFactory.CaptureType> captureTypes, @Nullable Config implementationOptions, @Nullable Range<Integer> targetFrameRate) {
        return new AutoValue_AttachedSurfaceInfo(surfaceConfig, imageFormat, size, dynamicRange, captureTypes, implementationOptions, targetFrameRate);
    }

    @NonNull
    public StreamSpec toStreamSpec(@NonNull Config implementationOptions) {
        StreamSpec.Builder streamSpecBuilder = StreamSpec.builder(this.getSize()).setDynamicRange(this.getDynamicRange()).setImplementationOptions(implementationOptions);
        if (this.getTargetFrameRate() != null) {
            streamSpecBuilder.setExpectedFrameRateRange(this.getTargetFrameRate());
        }
        return streamSpecBuilder.build();
    }

    @NonNull
    public abstract SurfaceConfig getSurfaceConfig();

    public abstract int getImageFormat();

    @NonNull
    public abstract Size getSize();

    @NonNull
    public abstract DynamicRange getDynamicRange();

    @NonNull
    public abstract List<UseCaseConfigFactory.CaptureType> getCaptureTypes();

    @Nullable
    public abstract Config getImplementationOptions();

    @Nullable
    public abstract Range<Integer> getTargetFrameRate();
}

