/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.Image;
import android.media.ImageReader;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.AndroidImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
class AndroidImageReaderProxy
implements ImageReaderProxy {
    @GuardedBy(value="mLock")
    private final ImageReader mImageReader;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mIsImageAvailableListenerCleared = true;

    AndroidImageReaderProxy(ImageReader imageReader) {
        this.mImageReader = imageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            Image image;
            try {
                image = this.mImageReader.acquireLatestImage();
            }
            catch (RuntimeException e) {
                if (this.isImageReaderContextNotInitializedException(e)) {
                    image = null;
                }
                throw e;
            }
            if (image == null) {
                return null;
            }
            return new AndroidImageProxy(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            Image image;
            try {
                image = this.mImageReader.acquireNextImage();
            }
            catch (RuntimeException e) {
                if (this.isImageReaderContextNotInitializedException(e)) {
                    image = null;
                }
                throw e;
            }
            if (image == null) {
                return null;
            }
            return new AndroidImageProxy(image);
        }
    }

    private boolean isImageReaderContextNotInitializedException(RuntimeException e) {
        return "ImageReaderContext is not initialized".equals(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReader.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReader.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReader.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReader.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReader.getSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsImageAvailableListenerCleared = false;
            ImageReader.OnImageAvailableListener transformedListener = imageReader -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.mIsImageAvailableListenerCleared) {
                        executor.execute(() -> listener.onImageAvailable(this));
                    }
                }
            };
            this.mImageReader.setOnImageAvailableListener(transformedListener, MainThreadAsyncHandler.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnImageAvailableListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsImageAvailableListenerCleared = true;
            this.mImageReader.setOnImageAvailableListener(null, null);
        }
    }
}

