/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.Node;
import androidx.camera.core.processing.SettableSurface;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.core.util.Preconditions;
import java.util.Collections;

@RequiresApi(api=21)
public class SurfaceProcessorNode
implements Node<SurfaceEdge, SurfaceEdge> {
    private final SurfaceOutput.GlTransformOptions mGlTransformOptions;
    @NonNull
    final SurfaceProcessorInternal mSurfaceProcessor;
    @NonNull
    final CameraInternal mCameraInternal;
    @Nullable
    private SurfaceEdge mOutputEdge;
    @Nullable
    private SurfaceEdge mInputEdge;

    public SurfaceProcessorNode(@NonNull CameraInternal cameraInternal, @NonNull SurfaceOutput.GlTransformOptions glTransformOptions, @NonNull SurfaceProcessorInternal surfaceProcessor) {
        this.mCameraInternal = cameraInternal;
        this.mGlTransformOptions = glTransformOptions;
        this.mSurfaceProcessor = surfaceProcessor;
    }

    @Override
    @NonNull
    @MainThread
    public SurfaceEdge transform(@NonNull SurfaceEdge inputEdge) {
        Threads.checkMainThread();
        Preconditions.checkArgument((inputEdge.getSurfaces().size() == 1 ? 1 : 0) != 0, (Object)"Multiple input stream not supported yet.");
        this.mInputEdge = inputEdge;
        SettableSurface inputSurface = inputEdge.getSurfaces().get(0);
        SettableSurface outputSurface = this.createOutputSurface(inputSurface);
        this.sendSurfacesToProcessorWhenReady(inputSurface, outputSurface);
        this.mOutputEdge = SurfaceEdge.create(Collections.singletonList(outputSurface));
        return this.mOutputEdge;
    }

    @NonNull
    private SettableSurface createOutputSurface(@NonNull SettableSurface inputSurface) {
        SettableSurface outputSurface;
        switch (this.mGlTransformOptions) {
            case APPLY_CROP_ROTATE_AND_MIRRORING: {
                Size resolution = inputSurface.getSize();
                Rect cropRect = inputSurface.getCropRect();
                int rotationDegrees = inputSurface.getRotationDegrees();
                boolean mirroring = inputSurface.getMirroring();
                Size rotatedCroppedSize = TransformUtils.is90or270(rotationDegrees) ? new Size(cropRect.height(), cropRect.width()) : TransformUtils.rectToSize(cropRect);
                Matrix sensorToBufferTransform = new Matrix(inputSurface.getSensorToBufferTransform());
                Matrix imageTransform = TransformUtils.getRectToRect(TransformUtils.sizeToRectF(resolution), new RectF(cropRect), rotationDegrees, mirroring);
                sensorToBufferTransform.postConcat(imageTransform);
                outputSurface = new SettableSurface(inputSurface.getTargets(), rotatedCroppedSize, inputSurface.getFormat(), sensorToBufferTransform, false, TransformUtils.sizeToRect(rotatedCroppedSize), 0, false);
                break;
            }
            case USE_SURFACE_TEXTURE_TRANSFORM: {
                outputSurface = new SettableSurface(inputSurface.getTargets(), inputSurface.getSize(), inputSurface.getFormat(), inputSurface.getSensorToBufferTransform(), false, inputSurface.getCropRect(), inputSurface.getRotationDegrees(), inputSurface.getMirroring());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown GlTransformOptions: " + (Object)((Object)this.mGlTransformOptions)));
            }
        }
        return outputSurface;
    }

    private void sendSurfacesToProcessorWhenReady(final @NonNull SettableSurface input, final @NonNull SettableSurface output) {
        final SurfaceRequest surfaceRequest = input.createSurfaceRequest(this.mCameraInternal);
        Futures.addCallback(output.createSurfaceOutputFuture(this.mGlTransformOptions, input.getSize(), input.getCropRect(), input.getRotationDegrees(), input.getMirroring()), new FutureCallback<SurfaceOutput>(){

            @Override
            public void onSuccess(@Nullable SurfaceOutput surfaceOutput) {
                Preconditions.checkNotNull((Object)surfaceOutput);
                SurfaceProcessorNode.this.mSurfaceProcessor.onOutputSurface(surfaceOutput);
                SurfaceProcessorNode.this.mSurfaceProcessor.onInputSurface(surfaceRequest);
                SurfaceProcessorNode.this.setupSurfaceUpdatePipeline(input, surfaceRequest, output, surfaceOutput);
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                surfaceRequest.willNotProvideSurface();
            }
        }, CameraXExecutors.mainThreadExecutor());
    }

    void setupSurfaceUpdatePipeline(@NonNull SettableSurface input, @NonNull SurfaceRequest inputSurfaceRequest, @NonNull SettableSurface output, @NonNull SurfaceOutput surfaceOutput) {
        inputSurfaceRequest.setTransformationInfoListener(CameraXExecutors.mainThreadExecutor(), info -> {
            int rotationDegrees = info.getRotationDegrees() - surfaceOutput.getRotationDegrees();
            if (input.getMirroring()) {
                rotationDegrees = -rotationDegrees;
            }
            output.setRotationDegrees(TransformUtils.within360(rotationDegrees));
        });
    }

    @Override
    public void release() {
        this.mSurfaceProcessor.release();
        CameraXExecutors.mainThreadExecutor().execute(() -> {
            if (this.mOutputEdge != null) {
                for (SettableSurface surface : this.mOutputEdge.getSurfaces()) {
                    surface.close();
                }
            }
        });
    }
}

