/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.camera.core.Logger;
import androidx.camera.core.processing.AutoValue_OpenGlRenderer_OutputSurface;
import androidx.camera.core.processing.ShaderProvider;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

@WorkerThread
@RequiresApi(value=21)
public final class OpenGlRenderer {
    private static final String TAG = "OpenGlRenderer";
    private static final String VAR_TEXTURE_COORD = "vTextureCoord";
    private static final String VAR_TEXTURE = "sTexture";
    private static final String DEFAULT_VERTEX_SHADER = String.format(Locale.US, "uniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 %s;\nvoid main() {\n    gl_Position = aPosition;\n    %s = (uTexMatrix * aTextureCoord).xy;\n}\n", "vTextureCoord", "vTextureCoord");
    private static final String DEFAULT_FRAGMENT_SHADER = String.format(Locale.US, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 %s;\nuniform samplerExternalOES %s;\nvoid main() {\n    gl_FragColor = texture2D(%s, %s);\n}\n", "vTextureCoord", "sTexture", "sTexture", "vTextureCoord");
    private static final float[] VERTEX_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final FloatBuffer VERTEX_BUF = OpenGlRenderer.createFloatBuffer(VERTEX_COORDS);
    private static final float[] TEX_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final FloatBuffer TEX_BUF = OpenGlRenderer.createFloatBuffer(TEX_COORDS);
    private static final int SIZEOF_FLOAT = 4;
    private static final int TEX_TARGET = 36197;
    private final AtomicBoolean mInitialized = new AtomicBoolean(false);
    private final Map<Surface, OutputSurface> mOutputSurfaceMap = new HashMap<Surface, OutputSurface>();
    @Nullable
    private Thread mGlThread;
    @NonNull
    private EGLDisplay mEglDisplay = EGL14.EGL_NO_DISPLAY;
    @NonNull
    private EGLContext mEglContext = EGL14.EGL_NO_CONTEXT;
    @Nullable
    private EGLConfig mEglConfig;
    @NonNull
    private EGLSurface mTempSurface = EGL14.EGL_NO_SURFACE;
    @Nullable
    private OutputSurface mCurrentOutputSurface;
    private int mTexId = -1;
    private int mProgramHandle = -1;
    private int mTexMatrixLoc = -1;
    private int mPositionLoc = -1;
    private int mTexCoordLoc = -1;

    public void init(@NonNull ShaderProvider shaderProvider) {
        this.checkInitializedOrThrow(false);
        try {
            this.createEglContext();
            this.createTempSurface();
            this.makeCurrent(this.mTempSurface);
            this.createProgram(shaderProvider);
            this.loadLocations();
            this.createTexture();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.releaseInternal();
            throw e;
        }
        this.mGlThread = Thread.currentThread();
        this.mInitialized.set(true);
    }

    public void release() {
        if (!this.mInitialized.getAndSet(false)) {
            return;
        }
        this.checkGlThreadOrThrow();
        this.releaseInternal();
    }

    public void setOutputSurface(@NonNull Surface surface) {
        this.checkInitializedOrThrow(true);
        this.checkGlThreadOrThrow();
        if (!this.mOutputSurfaceMap.containsKey(surface)) {
            EGLSurface eglSurface = OpenGlRenderer.createWindowSurface(this.mEglDisplay, Objects.requireNonNull(this.mEglConfig), surface);
            Size size = this.getSurfaceSize(eglSurface);
            this.mOutputSurfaceMap.put(surface, OutputSurface.of(eglSurface, size.getWidth(), size.getHeight()));
        }
        this.mCurrentOutputSurface = Objects.requireNonNull(this.mOutputSurfaceMap.get(surface));
        this.makeCurrent(this.mCurrentOutputSurface.getEglSurface());
        GLES20.glViewport((int)0, (int)0, (int)this.mCurrentOutputSurface.getWidth(), (int)this.mCurrentOutputSurface.getHeight());
        GLES20.glScissor((int)0, (int)0, (int)this.mCurrentOutputSurface.getWidth(), (int)this.mCurrentOutputSurface.getHeight());
    }

    public int getTextureName() {
        this.checkInitializedOrThrow(true);
        this.checkGlThreadOrThrow();
        return this.mTexId;
    }

    public void render(long timestampNs, @NonNull float[] textureTransform) {
        this.checkInitializedOrThrow(true);
        this.checkGlThreadOrThrow();
        if (this.mCurrentOutputSurface == null) {
            return;
        }
        GLES20.glUseProgram((int)this.mProgramHandle);
        OpenGlRenderer.checkGlErrorOrThrow("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.mTexId);
        GLES20.glUniformMatrix4fv((int)this.mTexMatrixLoc, (int)1, (boolean)false, (float[])textureTransform, (int)0);
        OpenGlRenderer.checkGlErrorOrThrow("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.mPositionLoc);
        OpenGlRenderer.checkGlErrorOrThrow("glEnableVertexAttribArray");
        int coordsPerVertex = 2;
        int vertexStride = 0;
        GLES20.glVertexAttribPointer((int)this.mPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)VERTEX_BUF);
        OpenGlRenderer.checkGlErrorOrThrow("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordLoc);
        OpenGlRenderer.checkGlErrorOrThrow("glEnableVertexAttribArray");
        int coordsPerTex = 2;
        int texStride = 0;
        GLES20.glVertexAttribPointer((int)this.mTexCoordLoc, (int)coordsPerTex, (int)5126, (boolean)false, (int)texStride, (Buffer)TEX_BUF);
        OpenGlRenderer.checkGlErrorOrThrow("glVertexAttribPointer");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        OpenGlRenderer.checkGlErrorOrThrow("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.mPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.mTexCoordLoc);
        GLES20.glUseProgram((int)0);
        GLES20.glBindTexture((int)36197, (int)0);
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mCurrentOutputSurface.getEglSurface(), (long)timestampNs);
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mCurrentOutputSurface.getEglSurface())) {
            Logger.w(TAG, "Failed to swap buffers with EGL error: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    private void createEglContext() {
        this.mEglDisplay = EGL14.eglGetDisplay((int)0);
        if (Objects.equals(this.mEglDisplay, EGL14.EGL_NO_DISPLAY)) {
            throw new IllegalStateException("Unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
            throw new IllegalStateException("Unable to initialize EGL14");
        }
        int[] attribToChooseConfig = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12610, 1, 12339, 5, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])attribToChooseConfig, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            throw new IllegalStateException("Unable to find a suitable EGLConfig");
        }
        EGLConfig config = configs[0];
        int[] attribToCreateContext = new int[]{12440, 2, 12344};
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)config, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attribToCreateContext, (int)0);
        OpenGlRenderer.checkEglErrorOrThrow("eglCreateContext");
        this.mEglConfig = config;
        this.mEglContext = context;
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mEglContext, (int)12440, (int[])values, (int)0);
        Log.d((String)TAG, (String)("EGLContext created, client version " + values[0]));
    }

    private void createTempSurface() {
        this.mTempSurface = OpenGlRenderer.createPBufferSurface(this.mEglDisplay, Objects.requireNonNull(this.mEglConfig), 1, 1);
    }

    private void makeCurrent(@NonNull EGLSurface eglSurface) {
        Preconditions.checkNotNull((Object)this.mEglDisplay);
        Preconditions.checkNotNull((Object)this.mEglContext);
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)this.mEglContext)) {
            throw new IllegalStateException("eglMakeCurrent failed");
        }
    }

    private void createProgram(@NonNull ShaderProvider shaderProvider) {
        int vertexShader = -1;
        int fragmentShader = -1;
        int program = -1;
        try {
            vertexShader = OpenGlRenderer.loadShader(35633, DEFAULT_VERTEX_SHADER);
            fragmentShader = this.loadFragmentShader(shaderProvider);
            program = GLES20.glCreateProgram();
            OpenGlRenderer.checkGlErrorOrThrow("glCreateProgram");
            GLES20.glAttachShader((int)program, (int)vertexShader);
            OpenGlRenderer.checkGlErrorOrThrow("glAttachShader");
            GLES20.glAttachShader((int)program, (int)fragmentShader);
            OpenGlRenderer.checkGlErrorOrThrow("glAttachShader");
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                throw new IllegalStateException("Could not link program: " + GLES20.glGetProgramInfoLog((int)program));
            }
            this.mProgramHandle = program;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (vertexShader != -1) {
                GLES20.glDeleteShader((int)vertexShader);
            }
            if (fragmentShader != -1) {
                GLES20.glDeleteShader((int)fragmentShader);
            }
            if (program != -1) {
                GLES20.glDeleteProgram((int)program);
            }
            throw e;
        }
    }

    private void loadLocations() {
        this.mPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        OpenGlRenderer.checkLocationOrThrow(this.mPositionLoc, "aPosition");
        this.mTexCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        OpenGlRenderer.checkLocationOrThrow(this.mTexCoordLoc, "aTextureCoord");
        this.mTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        OpenGlRenderer.checkLocationOrThrow(this.mTexMatrixLoc, "uTexMatrix");
    }

    private void createTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        OpenGlRenderer.checkGlErrorOrThrow("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)36197, (int)texId);
        OpenGlRenderer.checkGlErrorOrThrow("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        OpenGlRenderer.checkGlErrorOrThrow("glTexParameter");
        this.mTexId = texId;
    }

    private int loadFragmentShader(@NonNull ShaderProvider shaderProvider) {
        if (shaderProvider == ShaderProvider.DEFAULT) {
            return OpenGlRenderer.loadShader(35632, DEFAULT_FRAGMENT_SHADER);
        }
        try {
            String source = shaderProvider.createFragmentShader(VAR_TEXTURE, VAR_TEXTURE_COORD);
            if (source == null || !source.contains(VAR_TEXTURE_COORD) || !source.contains(VAR_TEXTURE)) {
                throw new IllegalArgumentException("Invalid fragment shader");
            }
            return OpenGlRenderer.loadShader(35632, source);
        }
        catch (Throwable t) {
            if (t instanceof IllegalArgumentException) {
                throw t;
            }
            throw new IllegalArgumentException("Unable to compile fragment shader", t);
        }
    }

    @NonNull
    private Size getSurfaceSize(@NonNull EGLSurface eglSurface) {
        int width = OpenGlRenderer.querySurface(this.mEglDisplay, eglSurface, 12375);
        int height = OpenGlRenderer.querySurface(this.mEglDisplay, eglSurface, 12374);
        return new Size(width, height);
    }

    private void releaseInternal() {
        if (this.mProgramHandle != -1) {
            GLES20.glDeleteProgram((int)this.mProgramHandle);
            this.mProgramHandle = -1;
        }
        for (OutputSurface outputSurface : this.mOutputSurfaceMap.values()) {
            EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)outputSurface.getEglSurface());
        }
        this.mOutputSurfaceMap.clear();
        if (!Objects.equals(this.mTempSurface, EGL14.EGL_NO_SURFACE)) {
            EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mTempSurface);
            this.mTempSurface = EGL14.EGL_NO_SURFACE;
        }
        if (!Objects.equals(this.mEglDisplay, EGL14.EGL_NO_DISPLAY)) {
            if (!Objects.equals(this.mEglContext, EGL14.EGL_NO_CONTEXT)) {
                EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)this.mEglContext);
                EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mEglContext);
                this.mEglContext = EGL14.EGL_NO_CONTEXT;
            }
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
        }
        this.mEglConfig = null;
        this.mProgramHandle = -1;
        this.mTexMatrixLoc = -1;
        this.mPositionLoc = -1;
        this.mTexCoordLoc = -1;
        this.mTexId = -1;
        this.mCurrentOutputSurface = null;
        this.mGlThread = null;
    }

    private void checkInitializedOrThrow(boolean shouldInitialized) {
        boolean result = shouldInitialized == this.mInitialized.get();
        String message = shouldInitialized ? "OpenGlRenderer is not initialized" : "OpenGlRenderer is already initialized";
        Preconditions.checkState((boolean)result, (String)message);
    }

    private void checkGlThreadOrThrow() {
        Preconditions.checkState((this.mGlThread == Thread.currentThread() ? 1 : 0) != 0, (String)"Method call must be called on the GL thread.");
    }

    @NonNull
    private static EGLSurface createPBufferSurface(@NonNull EGLDisplay eglDisplay, @NonNull EGLConfig eglConfig, int width, int height) {
        int[] surfaceAttrib = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eglDisplay, (EGLConfig)eglConfig, (int[])surfaceAttrib, (int)0);
        OpenGlRenderer.checkEglErrorOrThrow("eglCreatePbufferSurface");
        if (eglSurface == null) {
            throw new IllegalStateException("surface was null");
        }
        return eglSurface;
    }

    @NonNull
    private static EGLSurface createWindowSurface(@NonNull EGLDisplay eglDisplay, @NonNull EGLConfig eglConfig, @NonNull Surface surface) {
        int[] surfaceAttrib = new int[]{12344};
        EGLSurface eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eglDisplay, (EGLConfig)eglConfig, (Object)surface, (int[])surfaceAttrib, (int)0);
        OpenGlRenderer.checkEglErrorOrThrow("eglCreateWindowSurface");
        if (eglSurface == null) {
            throw new IllegalStateException("surface was null");
        }
        return eglSurface;
    }

    private static int loadShader(int shaderType, @NonNull String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        OpenGlRenderer.checkGlErrorOrThrow("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Logger.w(TAG, "Could not compile shader: " + source);
            GLES20.glDeleteShader((int)shader);
            throw new IllegalStateException("Could not compile shader type " + shaderType + ":" + GLES20.glGetShaderInfoLog((int)shader));
        }
        return shader;
    }

    private static int querySurface(@NonNull EGLDisplay eglDisplay, @NonNull EGLSurface eglSurface, int what) {
        int[] value = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)eglDisplay, (EGLSurface)eglSurface, (int)what, (int[])value, (int)0);
        return value[0];
    }

    @NonNull
    public static FloatBuffer createFloatBuffer(@NonNull float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    private static void checkLocationOrThrow(int location, @NonNull String label) {
        if (location < 0) {
            throw new IllegalStateException("Unable to locate '" + label + "' in program");
        }
    }

    private static void checkEglErrorOrThrow(@NonNull String op) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new IllegalStateException(op + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }

    private static void checkGlErrorOrThrow(@NonNull String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new IllegalStateException(op + ": GL error 0x" + Integer.toHexString(error));
        }
    }

    @AutoValue
    static abstract class OutputSurface {
        OutputSurface() {
        }

        @NonNull
        static OutputSurface of(@NonNull EGLSurface eglSurface, int width, int height) {
            return new AutoValue_OpenGlRenderer_OutputSurface(eglSurface, width, height);
        }

        @NonNull
        abstract EGLSurface getEglSurface();

        abstract int getWidth();

        abstract int getHeight();
    }
}

