/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.processing.OpenGlRenderer;
import androidx.camera.core.processing.ShaderProvider;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public class DefaultSurfaceProcessor
implements SurfaceProcessorInternal,
SurfaceTexture.OnFrameAvailableListener {
    private final OpenGlRenderer mGlRenderer;
    @VisibleForTesting
    final HandlerThread mGlThread;
    private final Executor mGlExecutor;
    @VisibleForTesting
    final Handler mGlHandler;
    private final AtomicBoolean mIsReleased = new AtomicBoolean(false);
    private final float[] mTextureMatrix = new float[16];
    private final float[] mSurfaceOutputMatrix = new float[16];
    final Map<SurfaceOutput, Surface> mOutputSurfaces = new LinkedHashMap<SurfaceOutput, Surface>();
    private int mInputSurfaceCount = 0;

    public DefaultSurfaceProcessor() {
        this(ShaderProvider.DEFAULT);
    }

    public DefaultSurfaceProcessor(@NonNull ShaderProvider shaderProvider) {
        this.mGlThread = new HandlerThread("GL Thread");
        this.mGlThread.start();
        this.mGlHandler = new Handler(this.mGlThread.getLooper());
        this.mGlExecutor = CameraXExecutors.newHandlerExecutor(this.mGlHandler);
        this.mGlRenderer = new OpenGlRenderer();
        try {
            this.initGlRenderer(shaderProvider);
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    @Override
    public void onInputSurface(@NonNull SurfaceRequest surfaceRequest) {
        if (this.mIsReleased.get()) {
            surfaceRequest.willNotProvideSurface();
            return;
        }
        this.mGlExecutor.execute(() -> {
            ++this.mInputSurfaceCount;
            SurfaceTexture surfaceTexture = new SurfaceTexture(this.mGlRenderer.getTextureName());
            surfaceTexture.setDefaultBufferSize(surfaceRequest.getResolution().getWidth(), surfaceRequest.getResolution().getHeight());
            Surface surface = new Surface(surfaceTexture);
            surfaceRequest.provideSurface(surface, this.mGlExecutor, (Consumer<SurfaceRequest.Result>)((Consumer)result -> {
                surfaceTexture.setOnFrameAvailableListener(null);
                surfaceTexture.release();
                surface.release();
                --this.mInputSurfaceCount;
                this.checkReadyToRelease();
            }));
            surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this, this.mGlHandler);
        });
    }

    @Override
    public void onOutputSurface(@NonNull SurfaceOutput surfaceOutput) {
        if (this.mIsReleased.get()) {
            surfaceOutput.close();
            return;
        }
        this.mGlExecutor.execute(() -> this.mOutputSurfaces.put(surfaceOutput, surfaceOutput.getSurface(this.mGlExecutor, (Consumer<SurfaceOutput.Event>)((Consumer)event -> {
            surfaceOutput.close();
            this.mOutputSurfaces.remove(surfaceOutput);
        }))));
    }

    @Override
    public void release() {
        if (this.mIsReleased.getAndSet(true)) {
            return;
        }
        this.mGlExecutor.execute(this::checkReadyToRelease);
    }

    public void onFrameAvailable(@NonNull SurfaceTexture surfaceTexture) {
        if (this.mIsReleased.get()) {
            return;
        }
        surfaceTexture.updateTexImage();
        surfaceTexture.getTransformMatrix(this.mTextureMatrix);
        for (Map.Entry<SurfaceOutput, Surface> entry : this.mOutputSurfaces.entrySet()) {
            Surface surface = entry.getValue();
            SurfaceOutput surfaceOutput = entry.getKey();
            this.mGlRenderer.setOutputSurface(surface);
            surfaceOutput.updateTransformMatrix(this.mSurfaceOutputMatrix, this.mTextureMatrix);
            this.mGlRenderer.render(surfaceTexture.getTimestamp(), this.mSurfaceOutputMatrix);
        }
    }

    @WorkerThread
    private void checkReadyToRelease() {
        if (this.mIsReleased.get() && this.mInputSurfaceCount == 0) {
            for (SurfaceOutput surfaceOutput : this.mOutputSurfaces.keySet()) {
                surfaceOutput.close();
            }
            this.mOutputSurfaces.clear();
            this.mGlRenderer.release();
            this.mGlThread.quit();
        }
    }

    private void initGlRenderer(@NonNull ShaderProvider shaderProvider) {
        ListenableFuture initFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mGlExecutor.execute(() -> {
                try {
                    this.mGlRenderer.init(shaderProvider);
                    completer.set(null);
                }
                catch (RuntimeException e) {
                    completer.setException((Throwable)e);
                }
            });
            return "Init GlRenderer";
        });
        try {
            initFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof ExecutionException ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Failed to create DefaultSurfaceProcessor", cause);
        }
    }
}

