/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.opengl.Matrix;
import androidx.annotation.NonNull;
import java.util.Locale;

public final class MatrixExt {
    private static final float[] sTemp = new float[16];

    private MatrixExt() {
    }

    public static void setRotate(@NonNull float[] matrix, float degrees, float px, float py) {
        Matrix.setIdentityM((float[])matrix, (int)0);
        MatrixExt.preRotate(matrix, degrees, px, py);
    }

    public static void preRotate(@NonNull float[] matrix, float degrees, float px, float py) {
        MatrixExt.normalize(matrix, px, py);
        Matrix.rotateM((float[])matrix, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        MatrixExt.denormalize(matrix, px, py);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postRotate(@NonNull float[] matrix, float degrees, float px, float py) {
        float[] fArray = sTemp;
        synchronized (sTemp) {
            Matrix.setIdentityM((float[])sTemp, (int)0);
            MatrixExt.normalize(sTemp, px, py);
            Matrix.rotateM((float[])sTemp, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
            MatrixExt.denormalize(sTemp, px, py);
            Matrix.multiplyMM((float[])matrix, (int)0, (float[])sTemp, (int)0, (float[])matrix, (int)0);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @NonNull
    public static String toString(@NonNull float[] matrix, int offset) {
        return String.format(Locale.US, "Matrix:\n%2.1f %2.1f %2.1f %2.1f\n%2.1f %2.1f %2.1f %2.1f\n%2.1f %2.1f %2.1f %2.1f\n%2.1f %2.1f %2.1f %2.1f", Float.valueOf(matrix[offset]), Float.valueOf(matrix[offset + 4]), Float.valueOf(matrix[offset + 8]), Float.valueOf(matrix[offset + 12]), Float.valueOf(matrix[offset + 1]), Float.valueOf(matrix[offset + 5]), Float.valueOf(matrix[offset + 9]), Float.valueOf(matrix[offset + 13]), Float.valueOf(matrix[offset + 2]), Float.valueOf(matrix[offset + 6]), Float.valueOf(matrix[offset + 10]), Float.valueOf(matrix[offset + 14]), Float.valueOf(matrix[offset + 3]), Float.valueOf(matrix[offset + 7]), Float.valueOf(matrix[offset + 11]), Float.valueOf(matrix[offset + 15]));
    }

    private static void normalize(float[] matrix, float px, float py) {
        Matrix.translateM((float[])matrix, (int)0, (float)px, (float)py, (float)0.0f);
    }

    private static void denormalize(float[] matrix, float px, float py) {
        Matrix.translateM((float[])matrix, (int)0, (float)(-px), (float)(-py), (float)0.0f);
    }
}

